/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.object;

import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.PrimaryKey;
import com.harrand.dbwrench.object.Table;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public final class ColumnSortPanelCtrl {
    private Database db_;
    private Table table_;
    private List fkColumnNames_;
    private final String mapName_ = Column.getClassName();
    public static final int PREFERRED_WIDTH = 360;
    public static final int MAX_HEIGHT = 800;

    public ColumnSortPanelCtrl(Database db, Table table) {
        if (db == null) {
            System.out.println("ColumnSortPanelCtrl.db can not be null");
        }
        if (table == null) {
            System.out.println("ColumnSortPanelCtrl.table can not be null");
        }
        this.db_ = db;
        this.table_ = table;
    }

    public Table getTable() {
        return this.table_;
    }

    private void setSortedList(List sortedList) {
        this.table_.setSortedList(sortedList);
    }

    public void setUseManualSort(boolean useManualSort) {
        this.table_.setUseManualSort(useManualSort);
    }

    public boolean getUseManualSort() {
        return this.table_.getUseManualSort();
    }

    public void setSortedDescs(List sortedDescs) {
        ArrayList<Column> sortedColumns = new ArrayList<Column>();
        for (String desc : sortedDescs) {
            int idx = desc.indexOf(" (");
            String colName = idx < 0 ? desc : desc.substring(0, idx);
            Column column = this.table_.getColumn(colName);
            sortedColumns.add(column);
        }
        this.setSortedList(sortedColumns);
    }

    public List getSortedColDescs() {
        ArrayList<String> sortedDescs = new ArrayList<String>();
        this.fkColumnNames_ = this.getFkColumnNames();
        for (Column column : this.table_.values(this.mapName_)) {
            StringBuffer sbDesc = new StringBuffer(column.getName());
            this.appendKeyInfo(column, sbDesc);
            sortedDescs.add(sbDesc.toString());
        }
        return sortedDescs;
    }

    private void appendKeyInfo(Column column, StringBuffer sbDesc) {
        String colName = column.getName();
        PrimaryKey pk = this.table_.getPrimaryKey();
        if (pk != null && pk.containsColumnName(colName)) {
            sbDesc.append(" (PK)");
        }
        if (this.fkColumnNames_.contains(colName)) {
            sbDesc.append(" (FK)");
        }
    }

    private List getFkColumnNames() {
        ArrayList fkColumns = new ArrayList();
        if (this.db_ != null) {
            List fks = this.db_.getFkUtil().getFksForTable(this.table_, 1);
            for (ForeignKey fk : fks) {
                fkColumns.addAll(fk.getChildColumnsOld());
            }
        }
        return fkColumns;
    }

    public Rectangle getPreferredBounds(Font font) {
        int columnCount;
        int height;
        int fontSz = font.getSize();
        int expectedFontSiz = 11;
        int lineHeight = 24;
        int textHeight = 16;
        if (fontSz > expectedFontSiz) {
            int diffSz = fontSz - expectedFontSiz;
            lineHeight += 2 * diffSz;
            textHeight += 2 * diffSz;
        }
        if ((height = 14 * lineHeight + ((columnCount = this.table_.size(this.mapName_)) + 2) * textHeight) > 800) {
            height = 800;
        }
        return new Rectangle(360, height);
    }
}

