/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.object;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.ICommentReadable;
import com.harrand.coreclasses.interfaces.IConfirmRemove;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.rename.IRenameTrackable;
import com.harrand.dbwrench.diagram.column.ColumnDiagramTextFormatter;
import com.harrand.dbwrench.element.ITableObj;
import com.harrand.dbwrench.jdbc.DataTypeSvr;
import com.harrand.dbwrench.jdbc.IDataType;
import com.harrand.dbwrench.object.CustomType;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.dbwrench.object.PrimaryKey;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.index.IIndexColumn;
import com.harrand.dbwrench.security.App;
import com.harrand.util.LogUtil;

public final class Column
implements Identifiable,
ICommentReadable,
IRenameTrackable,
ITableObj,
IConfirmRemove,
IIndexColumn {
    private String name_;
    private String comment_ = "";
    private Table table = null;
    private IDataType dataType_;
    private Integer length_;
    private Integer scale_;
    private boolean nullable_;
    private boolean autoNumber_;
    private String default_;
    private String check_;
    private boolean signed_ = true;
    private boolean unique_ = false;
    private boolean isArray = false;
    private String enumCsv_ = "";
    private String defaultNm_ = "";
    private ColumnDiagramTextFormatter textFormatter;
    public static final String ARRAY_BRACKET_DISPLAY_STR = "[ ]";
    public static final int TABLE_HEADER_COUNT = 4;
    public static final String HD_DATA_TYPE_FULL = "Type";
    public static final String HD_DATA_TYPE = "Data Type";
    public static final String HD_LENGTH = "Length";
    public static final String HD_SCALE = "Scale";
    public static final String HD_NULLABLE = "Nulls";
    public static final String HD_UNIQUE = "Unique";
    public static final String HD_IS_ARRAY = "Is Array";
    public static final String HD_AUTONUMBER = "Auto Num.";
    public static final String XML_AUTONUMBER = "AutoNumber";
    public static final String XML_ENUM_VALUES = "EnumValues";
    public static final String HD_DEFAULT = "Default";
    public static final String HD_CHECK = "Check";
    public static final String HD_FOREIGN_KEY = "FK";
    public static final String HD_SIGNED = "Signed";
    public static final String HD_UNSIGNED = "Unsigned";
    public static final String HD_ENUM_VALUES = "ENUM Values";
    public static final String HD_DATA_TYPE_PACKED = "DataType";
    public static final String AUTONUMBER_DESC = "AUTO NUMBER";

    public Column(String name, int dataTypeId, Integer length, boolean nullable) throws Exception {
        this(name, dataTypeId, length, nullable, false, "", null, "");
    }

    public Column(String name) throws Exception {
        this(name, 4, null, true);
    }

    public Column(String name, int dataTypeId, Integer length, boolean nullable, boolean autoNumber, String defaultValue, Integer scale, String comment) throws Exception {
        this(name, dataTypeId, length, nullable, autoNumber, defaultValue, scale, comment, true, "");
    }

    public Column(String name, int dataTypeId, Integer length, boolean nullable, boolean autoNumber, String defaultValue, Integer scale, String comment, boolean signed, String enumCsv) throws Exception {
        this(name, DataTypeSvr.getDataType(dataTypeId), length, nullable, autoNumber, defaultValue, scale, comment, signed, enumCsv);
    }

    public Column(String name, IDataType dataType, Integer length, boolean nullable, boolean autoNumber, String defaultValue, Integer scale, String comment, String defaultNm) throws Exception {
        this(name, dataType, length, nullable, autoNumber, defaultValue, scale, comment, true, "");
        this.defaultNm_ = defaultNm;
    }

    public Column(String name, IDataType dataType, Integer length, boolean nullable, boolean autoNumber, String defaultValue, Integer scale, String comment, boolean signed, String enumCsv) throws Exception {
        Column.isNameValid(name);
        this.setDataType(dataType);
        this.setLength(length);
        this.setScale(scale);
        this.setSigned(signed);
        Column.isDefaultValid(defaultValue);
        this.setName(name);
        this.length_ = length;
        this.setIsNullable(nullable);
        this.setAutoNumber(autoNumber);
        this.setDefaultValue(defaultValue);
        this.check_ = "";
        this.scale_ = scale;
        this.setComment(comment);
        this.setSigned(signed);
        String stageA = enumCsv.replaceAll(",  ", ",");
        this.enumCsv_ = stageA.replaceAll(", ", ",");
        this.textFormatter = new ColumnDiagramTextFormatter(this);
    }

    public Column clone() {
        Column newColumn = null;
        try {
            newColumn = new Column(this.getName(), this.getDataType(), this.getLength(), this.getIsNullable(), this.getAutoNumber(), this.getDefault(), this.getScale(), this.getComment(), this.getSignedFlag(), this.getEnumCsv());
        }
        catch (Exception e) {
            LogUtil.logErr("Column.failed to duplicate column: " + this.getName() + ". " + e.getMessage());
        }
        return newColumn;
    }

    public void setAutoNumber(boolean autoNumber) {
        this.autoNumber_ = autoNumber;
    }

    public void setSigned(boolean signed) {
        this.signed_ = signed;
    }

    public void setComment(String comment) {
        this.comment_ = comment;
    }

    public boolean getIsArray() {
        return this.isArray;
    }

    public void setIsArray(boolean isArray) {
        this.isArray = isArray;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof Column)) {
            return false;
        }
        Column other = (Column)o;
        if (other.getIsNullable() != this.getIsNullable()) {
            return false;
        }
        if (other.getAutoNumber() != this.getAutoNumber()) {
            return false;
        }
        if (other.getDataTypeId() != this.getDataTypeId()) {
            return false;
        }
        if (!other.getName().equals(this.getName())) {
            return false;
        }
        if (!other.getComment().equals(this.getComment())) {
            return false;
        }
        if (!other.getDefault().equals(this.getDefault())) {
            return false;
        }
        if (!other.getEnumCsv().equals(this.getEnumCsv())) {
            return false;
        }
        if (other.getCheck() != this.getCheck()) {
            return false;
        }
        if (other.getSignedFlag() != this.getSignedFlag()) {
            return false;
        }
        if (other.getIsArray() != this.getIsArray()) {
            return false;
        }
        Integer otherLength = other.getLength();
        if (otherLength == null != (this.getLength() == null)) {
            return false;
        }
        if (this.getLength() != null && otherLength.intValue() != this.getLength().intValue()) {
            return false;
        }
        Integer otherScale = other.getScale();
        if (otherScale == null != (this.getScale() == null)) {
            return false;
        }
        return this.getScale() == null || otherScale.intValue() == this.getScale().intValue();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append(", DT=").append(this.dataType_.getName());
        sb.append(", L=").append(StrHelper.getNullSafeString(this.length_));
        sb.append(", COM=").append(this.getComment());
        sb.append(", N=").append(this.getIsNullable());
        sb.append(", AN=").append(this.getAutoNumber());
        sb.append(", DF=").append(StrHelper.getNullSafeString(this.getDefault()));
        sb.append(", SC=").append(StrHelper.getNullSafeString(this.getScale()));
        sb.append(", SI=").append(this.getSignedFlag());
        sb.append(", EN=").append(this.getEnumCsv());
        sb.append(", ARR=").append(this.getIsArray());
        sb.append(".");
        return sb.toString();
    }

    @Override
    public String getComment() {
        return this.comment_;
    }

    public String getDotNote() {
        String tablePart = this.table != null ? this.table.getName() + "." : "";
        return tablePart + this.getName();
    }

    @Override
    public boolean getConfirmRemove() {
        return false;
    }

    public static String getClassName() {
        return "Column";
    }

    public static String getClassNamePack() {
        return "Column";
    }

    public static String getClassAbbr() {
        return "col";
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public String getMapName() {
        return Column.getClassName();
    }

    public int getDataTypeId() {
        return this.dataType_.getId();
    }

    public String getDataTypeDesc() {
        return this.dataType_.getName();
    }

    @Override
    public String getDisplayClzNm() {
        return this.getMapName();
    }

    @Override
    public String getDisplayClzPlural() {
        return this.getDisplayClzNm() + "s";
    }

    public IDataType getDataType() {
        return this.dataType_;
    }

    public boolean getUnique() {
        return this.unique_;
    }

    public void setLength(Integer length) {
        this.length_ = length;
    }

    public void setScale(Integer scale) {
        this.scale_ = scale;
    }

    public void setDefaultValue(String defaultStr) {
        this.default_ = defaultStr;
    }

    public void setIsNullable(boolean nullable) {
        this.nullable_ = nullable;
    }

    public void setUnique(boolean unique) {
        this.unique_ = unique;
    }

    public void setDataType(IDataType type) {
        this.dataType_ = type;
    }

    public String getDataTypeDescFull() {
        StringBuilder sb = new StringBuilder(this.getDataTypeAndLength());
        if (this.getDataType().isNumberLikeType()) {
            sb.append(" " + this.getSignedStr());
        }
        return sb.toString();
    }

    public String getDataTypeAndLength() {
        StringBuilder sb = new StringBuilder(this.getDataTypeDesc());
        if (this.getDataType().isLengthUsed()) {
            sb.append(this.getLengthScaleEnclosed());
        }
        sb.append(this.getIsArrayBrackets());
        return sb.toString();
    }

    public String getLengthScaleEnclosed() {
        StringBuilder sb = new StringBuilder();
        String lengthText = this.getLengthScaleText();
        if (this.dataType_.isStandardType()) {
            if (this.dataType_.isLengthUsed()) {
                sb.append("(" + lengthText + ")");
            }
        } else if (lengthText.length() > 0) {
            sb.append("(" + lengthText + ")");
        }
        return sb.toString();
    }

    public String getLengthScaleText() {
        StringBuffer sb = new StringBuffer();
        if (this.dataType_.isLengthUsed() && this.getLength() != null) {
            sb.append(this.getLengthStr());
        }
        if (this.dataType_.isScaleUsed() && this.getScale() != null) {
            sb.append(", ").append(this.getScaleStr());
        }
        return sb.toString();
    }

    public String getLengthStr() {
        if (this.getLength() != null) {
            return this.getLength().toString();
        }
        return "";
    }

    public String getScaleStr() {
        if (this.getScale() != null) {
            return this.getScale().toString();
        }
        return "";
    }

    public boolean isIntegerColumn() {
        if (this.dataType_.isIntegerLikeType()) {
            return true;
        }
        return this.isOracleNumberInteger();
    }

    private boolean isOracleNumberInteger() {
        return this.dataType_.getId() == 780 && (this.scale_ == null || this.scale_ == 0);
    }

    public String getIsArrayBrackets() {
        String str = this.getIsArray() ? ARRAY_BRACKET_DISPLAY_STR : "";
        return str;
    }

    private String getSignedStr() {
        return this.textFormatter.getSignedText();
    }

    public Integer getLength() {
        return this.length_;
    }

    public Integer getScale() {
        return this.scale_;
    }

    public String getDefault() {
        return this.default_;
    }

    public String getDefaultNm() {
        return this.defaultNm_;
    }

    public boolean getSignedFlag() {
        return this.signed_;
    }

    public String getEnumCsv() {
        return this.enumCsv_;
    }

    public String getCheck() {
        return this.check_;
    }

    public boolean getIsNullable() {
        return this.nullable_;
    }

    public String getIsNullableDesc() {
        return this.textFormatter.getIsNullText();
    }

    public boolean getAutoNumber() {
        return this.autoNumber_;
    }

    public String getAutoNumberDesc() {
        if (this.getAutoNumber()) {
            return AUTONUMBER_DESC;
        }
        return "";
    }

    public Column getRenameDup(String newName) {
        Column newCol = null;
        try {
            IDataType type = this.getDataType();
            if (!type.isStandardType()) {
                CustomType customType = (CustomType)type;
                Database lookupDb = LookupUtil.getLookupDb();
                DataTypeSvr.checkAddType(lookupDb, customType);
            }
            newCol = new Column(newName, this.getDataTypeId(), this.getLength(), this.getIsNullable(), this.getAutoNumber(), this.getDefault(), this.getScale(), this.getComment(), this.getSignedFlag(), this.getEnumCsv());
            newCol.setUnique(this.getUnique());
            newCol.setIsArray(this.getIsArray());
        }
        catch (Exception e) {
            LogUtil.logErr("Column.getRenameDup.err: " + e.getMessage());
        }
        return newCol;
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public void setTable(Table tbl) {
        this.table = tbl;
    }

    @Override
    public ITableObj getDup() {
        return this.getRenameDup(this.getName());
    }

    public int getPkColumnPos(Table table) {
        PrimaryKey pk = table.getPrimaryKey();
        int pos = -1;
        if (pk != null) {
            pos = pk.getColumnPos(this.getName());
        }
        return pos;
    }

    public boolean isPkField(Table table) {
        return this.getPkColumnPos(table) > -1;
    }

    public String getMetaDataDesc() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.dataType_.getName().toUpperCase());
        sb.append(this.getLengthScaleEnclosed());
        sb.append(" ").append(this.getIsNullableDesc());
        if (this.getAutoNumberDesc().length() > 0) {
            sb.append(" ").append(this.getAutoNumberDesc());
        }
        if (this.getDefault().length() > 0) {
            sb.append(" ").append(App.getRes("default.abbr"));
            sb.append(": ").append(this.getDefault());
        }
        return sb.toString();
    }

    @Override
    public void setName(String name) {
        this.name_ = name;
    }

    @Override
    public String getParentClassNm() {
        return Table.getClassName();
    }

    public static void isNameValid(String theName) throws IllegalArgumentException {
        if (theName.length() <= 0) {
            throw new IllegalArgumentException(Column.getMsgInvalidName());
        }
    }

    public static void isDefaultValid(String theDefault) throws IllegalArgumentException {
        if (theDefault == null) {
            throw new IllegalArgumentException(App.getRes("err.column.default.null"));
        }
    }

    public static String getMsgInvalidName() {
        return App.getRes("err.column.name.blank.msg");
    }

    @Override
    public String getInIndexDdl() {
        return this.getName();
    }

    @Override
    public String getCustomText() {
        return this.getName();
    }
}

