/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.naming;

import com.harrand.coreclasses.naming.INameBldr;
import com.harrand.dbwrench.naming.DbNameProps;
import com.harrand.dbwrench.naming.IDbNameProps;
import com.harrand.dbwrench.object.PrimaryKey;
import com.harrand.dbwrench.object.Table;
import com.harrand.util.XmlHelper;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class PkNameBldr
implements INameBldr,
IDbNameProps {
    private DbNameProps nameProps_;
    public static final String XML_NM = "PkNameBldr";

    public PkNameBldr(String prefix, String separator, String suffix, boolean useTableName, boolean useColumnNames) {
        this.nameProps_ = new DbNameProps(prefix, separator, suffix, useTableName, useColumnNames);
    }

    public PkNameBldr(IDbNameProps dbNameProps) {
        this(dbNameProps.getPrefix(), dbNameProps.getSeparator(), dbNameProps.getSuffix(), dbNameProps.getUseTableName(), dbNameProps.getUseColumnNames());
    }

    public String getFormedName(Table table) {
        String formedName = "";
        PrimaryKey pk = table.getPrimaryKey();
        ArrayList colNames = new ArrayList();
        if (pk != null) {
            colNames = pk.getKeyColumnNames();
        }
        formedName = this.nameProps_.getTableColumnsName(table, (List)colNames);
        return formedName;
    }

    public String getFormedName(String tableName, List pkColumnNames) {
        String formedName = "";
        formedName = this.nameProps_.getTableColumnsName(tableName, pkColumnNames);
        return formedName;
    }

    public static PkNameBldr fromXml(Element element) {
        Element elmNameProps = XmlHelper.getFirstElementByTagName(element, "DbNameProps");
        DbNameProps nameProps = DbNameProps.fromXml(elmNameProps);
        PkNameBldr newBldr = new PkNameBldr(nameProps.getPrefix(), nameProps.getSeparator(), nameProps.getSuffix(), nameProps.getUseTableName(), nameProps.getUseColumnNames());
        return newBldr;
    }

    @Override
    public Element asXmlElement() {
        Document doc = XmlHelper.getNewDocument();
        Element elmParent = doc.createElement(XML_NM);
        Element elmNameProps = this.nameProps_.asXmlElement();
        XmlHelper.addForeignElement(doc, elmParent, elmNameProps);
        return elmParent;
    }

    @Override
    public void setName(String newName) {
    }

    @Override
    public String getName() {
        return XML_NM;
    }

    @Override
    public String getPrefix() {
        return this.nameProps_.getPrefix();
    }

    @Override
    public String getSeparator() {
        return this.nameProps_.getSeparator();
    }

    @Override
    public String getSuffix() {
        return this.nameProps_.getSuffix();
    }

    @Override
    public boolean getUseColumnNames() {
        return this.nameProps_.getUseColumnNames();
    }

    @Override
    public boolean getUseTableName() {
        return this.nameProps_.getUseTableName();
    }

    @Override
    public void setPrefix(String prefix) {
        this.nameProps_.setPrefix(prefix);
    }

    @Override
    public void setSeparator(String separator) {
        this.nameProps_.setSeparator(separator);
    }

    @Override
    public void setSuffix(String suffix) {
        this.nameProps_.setSuffix(suffix);
    }

    @Override
    public void setUseColumnNames(boolean use) {
        this.nameProps_.setUseColumnNames(use);
    }

    @Override
    public void setUseTableName(boolean use) {
        this.nameProps_.setUseTableName(use);
    }
}

