/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.metaData.postgresql;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.dbwrench.jdbc.ConnectionFactory;
import com.harrand.dbwrench.metaData.ignore.PsqlIgnoreCtrlx;
import com.harrand.dbwrench.metaData.postgresql.PsqlColumnFunctionParser;
import com.harrand.dbwrench.metaData.postgresql.PsqlOptionTextParser;
import com.harrand.dbwrench.metaData.postgresql.PsqlSchemaFilterBldr;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Index;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.index.ColumnFunction;
import com.harrand.dbwrench.object.index.IIndexColumn;
import com.harrand.util.LogUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;

public final class PsqlIndexRevEngCtrl {
    private PsqlColumnFunctionParser columnFunctionParser = new PsqlColumnFunctionParser();
    private PsqlOptionTextParser optionTextParser = new PsqlOptionTextParser();
    private PsqlSchemaFilterBldr schemaFilterBldr;
    public static final String INDEX_DEF_QUERY = "SELECT indexdef FROM pg_indexes WHERE schemaname = '%s' AND tablename = '%s' AND indexname = '%s'";

    public PsqlIndexRevEngCtrl(PsqlIgnoreCtrlx ignoreCtrl) {
        this.schemaFilterBldr = new PsqlSchemaFilterBldr(ignoreCtrl);
    }

    public ITestResult addIndexes(Connection conn, Database db, boolean supportsv73, Map colAttNumsMap) {
        DataEntryResult result = new DataEntryResult();
        String sql = supportsv73 ? this.getIndexQuerySql73() : this.getIndexQuerySql72();
        try {
            String schNm = null;
            String tblNm = null;
            String idxNm = null;
            Statement stmt = conn.createStatement();
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                try {
                    schNm = rs.getString("schNm");
                    tblNm = rs.getString("TABLE_NAME");
                    Schema schema = db.getSchema(schNm);
                    Table table = schema.getTable(tblNm);
                    boolean clustered = rs.getBoolean("CLUSTERED");
                    idxNm = rs.getString("INDEX_NAME");
                    String colIds = rs.getString("COL_IDS");
                    int tblOid = rs.getInt("TblOid");
                    boolean unique = rs.getBoolean("UNIQUE");
                    String indexDefText = this.getIndexDef(conn, table, idxNm);
                    String optionText = this.optionTextParser.getOptionText(indexDefText);
                    ArrayList<IIndexColumn> indexColumns = new ArrayList<IIndexColumn>();
                    String[] colPosArray = colIds.split(" ");
                    for (int colPosInIndex = 0; colPosInIndex < colPosArray.length; ++colPosInIndex) {
                        String colPosInTableText = colPosArray[colPosInIndex];
                        if (this.isExpressionIndex(schNm, tblNm, idxNm, colPosInTableText)) {
                            ColumnFunction columnFunction = this.columnFunctionParser.parseColumnFunction(indexDefText, optionText, colPosInIndex);
                            indexColumns.add(columnFunction);
                            continue;
                        }
                        try {
                            String attIdDotNote = Integer.toString(tblOid) + "." + colPosInTableText;
                            String colNm = (String)colAttNumsMap.get(attIdDotNote);
                            Column column = table.getColumn(colNm);
                            indexColumns.add(column);
                            continue;
                        }
                        catch (Exception e) {
                            String msg = "PsqlMetaCtrl.index col parse err for:" + colPosInTableText + ", idxNm: " + idxNm + ">>" + e.getMessage();
                            LogUtil.logRevEngError(e, "MySqlMetaCtrl", msg);
                        }
                    }
                    Index newIndex = new Index(idxNm, indexColumns, clustered, unique);
                    newIndex.setOptionText(optionText);
                    newIndex.setTable(table);
                    table.add(newIndex);
                }
                catch (Exception e) {
                    String message = this.getNullSafe(schNm) + "." + this.getNullSafe(tblNm) + "." + this.getNullSafe(idxNm);
                    LogUtil.logRevEngError(e, "MySqlMetaCtrl", message);
                    result = new DataEntryResult(false, e.getMessage());
                }
            }
            ConnectionFactory.close(rs);
            ConnectionFactory.close(stmt);
        }
        catch (Exception e) {
            result = new DataEntryResult(false, e.getMessage());
        }
        long finish = System.currentTimeMillis();
        return result;
    }

    private String getIndexDef(Connection conn, Table table, String indexName) {
        try {
            String sql = String.format(INDEX_DEF_QUERY, table.getSchema().getName(), table.getName(), indexName);
            Statement stmt = conn.createStatement();
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            if (rs.next()) {
                String indexDef = rs.getString("indexdef");
                return indexDef;
            }
            ConnectionFactory.close(rs);
            ConnectionFactory.close(stmt);
        }
        catch (SQLException ex) {
            String message = "Could not obtain definition for: " + table.getDotNote() + "." + indexName;
            LogUtil.logRevEngError(ex, "MySqlMetaCtrl", message);
        }
        return "(columnFunctionError)";
    }

    private boolean isExpressionIndex(String schNm, String tblNm, String idxNm, String colIndexStr) {
        return colIndexStr.equals("0");
    }

    private String getNullSafe(String str) {
        return StrHelper.getNullSafeString(str);
    }

    private String getIndexQuerySql72() {
        return "SELECT ci.relname as \"INDEX_NAME\", \n'public' as \"SchNm\", \nct.relname as \"TABLE_NAME\", \nct.oid as \"TblOid\", \nind.indkey as \"COL_IDS\", \nind.indisunique as \"UNIQUE\", \nind.indisclustered as \"CLUSTERED\" \nFROM pg_index ind \n\tJOIN pg_class ci ON ind.indexrelid = ci.oid \n\tJOIN pg_class ct ON ind.indrelid = ct.oid \nWHERE not ind.indisprimary \n\tAND ci.relname !~ '^pg_' \n\tAND ct.relname !~ '^pg_'\n";
    }

    private String getIndexQuerySql73() {
        return "SELECT ci.relname as \"INDEX_NAME\", \nnsp.nspname as \"SchNm\", \nct.relname as \"TABLE_NAME\", \nct.oid as \"TblOid\", \nind.indkey as \"COL_IDS\", \nind.indisunique as \"UNIQUE\", \nind.indisclustered as \"CLUSTERED\" \nFROM pg_catalog.pg_index ind \n\tJOIN pg_catalog.pg_class ci ON ind.indexrelid = ci.oid \n\tJOIN pg_catalog.pg_class ct ON ind.indrelid = ct.oid \n\tJOIN pg_namespace as nsp on ct.relnamespace = nsp.oid \nWHERE " + this.getSchemaFilter("nsp") + "\n" + "\tAND not ind.indisprimary \n" + "\tAND ci.relname !~ '^pg_' \n" + "\tAND ct.relname !~ '^pg_'\n";
    }

    private String getSchemaFilter(String nameSpaceAlias) {
        return this.schemaFilterBldr.getSchemaFilterSql(nameSpaceAlias);
    }
}

