/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.metaData.mysql;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.dbwrench.jdbc.ConnectionFactory;
import com.harrand.dbwrench.metaData.collapser.RowIndexCollapser;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Index;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.util.LogUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public final class MySqlIndexRevEngCtrl {
    public static final String INDEX_QUERY = "SELECT * FROM INFORMATION_SCHEMA.STATISTICS WHERE TABLE_SCHEMA = '%s' AND INDEX_NAME != 'PRIMARY'";

    public ITestResult addIndexes(Connection conn, Database db) {
        DataEntryResult result = new DataEntryResult();
        Schema schema = db.getFirstSchema();
        try {
            String schNm = null;
            String tblNm = null;
            String idxNm = null;
            ArrayList<Index> rowIndexes = new ArrayList<Index>();
            String queryText = String.format(INDEX_QUERY, db.getName());
            Statement stmt = conn.createStatement();
            stmt.execute(queryText);
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                try {
                    tblNm = rs.getString("TABLE_NAME");
                    idxNm = rs.getString("INDEX_NAME");
                    String columnName = rs.getString("COLUMN_NAME");
                    String indexTypeText = rs.getString("INDEX_TYPE");
                    boolean unique = !rs.getBoolean("NON_UNIQUE");
                    boolean clustered = false;
                    boolean fullText = this.getIsFullText(indexTypeText);
                    boolean spatial = this.getIsSpatial(indexTypeText);
                    String optionText = this.getOptionText(indexTypeText);
                    Table table = schema.getTable(tblNm);
                    Column column = table.getColumn(columnName);
                    Index singleRowIndex = new Index(idxNm, column, clustered, unique);
                    singleRowIndex.setFullText(fullText);
                    singleRowIndex.setSpatial(spatial);
                    singleRowIndex.setOptionText(optionText);
                    singleRowIndex.setTable(table);
                    rowIndexes.add(singleRowIndex);
                }
                catch (Exception e) {
                    String objDesc = this.getNullSafe(schNm) + "." + this.getNullSafe(tblNm) + "." + this.getNullSafe(idxNm);
                    result = new DataEntryResult(false, e.getMessage());
                    LogUtil.logRevEngError(e, "MySqlMetaCtrl", objDesc);
                }
            }
            List<Index> collapsedIndexes = new RowIndexCollapser().getCollapsedIndexes(rowIndexes);
            for (Index collapsedIndex : collapsedIndexes) {
                collapsedIndex.getTable().add(collapsedIndex);
            }
            ConnectionFactory.close(rs);
            ConnectionFactory.close(stmt);
        }
        catch (Exception e) {
            result = new DataEntryResult(false, e.getMessage());
        }
        return result;
    }

    private String getNullSafe(String str) {
        return StrHelper.getNullSafeString(str);
    }

    private boolean getIsFullText(String indexTypeText) {
        String indexTypeTextLc = indexTypeText.toLowerCase();
        return indexTypeTextLc.contains("fulltext");
    }

    private boolean getIsSpatial(String indexTypeText) {
        String indexTypeTextLc = indexTypeText.toLowerCase();
        return indexTypeTextLc.contains("spatial");
    }

    private String getOptionText(String indexTypeText) {
        String indexTypeTextLc = indexTypeText.toLowerCase();
        if (indexTypeTextLc.contains("btree")) {
            return "USES BTREE";
        }
        if (indexTypeText.contains("hash")) {
            return "USES HASH";
        }
        return "";
    }
}

