/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.metaData.ignore;

import com.harrand.dbwrench.element.schema.SchemaIgnoreCtrl;
import java.util.ArrayList;
import java.util.List;

public class OracleIgnoreCtrl {
    private SchemaIgnoreCtrl schIgnoreCtrl = null;
    private List<String> sysSchNms = new ArrayList<String>();

    public OracleIgnoreCtrl(SchemaIgnoreCtrl schIgnoreCtrl) {
        this.schIgnoreCtrl = schIgnoreCtrl;
        this.buildSysSchNms();
        this.addIgnoreSchNms();
    }

    public String getIgnoreSchStr(String tblAbbr, String ownerColNmIn) {
        String ownerColNm = "owner";
        if (ownerColNmIn != null) {
            ownerColNm = ownerColNmIn;
        }
        StringBuilder sb = new StringBuilder();
        String abbrStr = tblAbbr == null ? "" : new String(tblAbbr + ".");
        String notEqualStr = abbrStr + ownerColNm + " != '";
        String andStr = " and \n ";
        boolean appendAndStr = false;
        for (String schNm : this.sysSchNms) {
            if (appendAndStr) {
                sb.append(andStr);
            }
            sb.append(notEqualStr).append(schNm).append("'");
            appendAndStr = true;
        }
        return sb.toString();
    }

    private void buildSysSchNms() {
        this.sysSchNms.add("ANONYMOUS");
        this.sysSchNms.add("APEX_030200");
        this.sysSchNms.add("APEX_PUBLIC_USER");
        this.sysSchNms.add("APPQOSSYS");
        this.sysSchNms.add("CTXSYS");
        this.sysSchNms.add("DBSNMP");
        this.sysSchNms.add("DMSYS");
        this.sysSchNms.add("DIP");
        this.sysSchNms.add("EXFSYS");
        this.sysSchNms.add("FLOWS_FILES");
        this.sysSchNms.add("MDDATA");
        this.sysSchNms.add("MDSYS");
        this.sysSchNms.add("MGMT_VIEW");
        this.sysSchNms.add("OLAPSYS");
        this.sysSchNms.add("ORACLE_OCM");
        this.sysSchNms.add("ORDDATA");
        this.sysSchNms.add("ORDPLUGINS");
        this.sysSchNms.add("ORDSYS");
        this.sysSchNms.add("OUTLN");
        this.sysSchNms.add("OWBSYS");
        this.sysSchNms.add("OWBSYS_AUDIT");
        this.sysSchNms.add("SCOTT");
        this.sysSchNms.add("SI_INFORMTN_SCHEMA");
        this.sysSchNms.add("SPATIAL_CSW_ADMIN_USR");
        this.sysSchNms.add("SPATIAL_WFS_ADMIN_USR");
        this.sysSchNms.add("SYS");
        this.sysSchNms.add("SYSMAN");
        this.sysSchNms.add("SYSTEM");
        this.sysSchNms.add("TSMSYS");
        this.sysSchNms.add("WMSYS");
        this.sysSchNms.add("XDB");
        this.sysSchNms.add("XS$NULL");
    }

    private void addIgnoreSchNms() {
        for (String schNm : this.schIgnoreCtrl.getIgnoreNms()) {
            this.sysSchNms.add(schNm);
        }
    }
}

