/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.metaData.helper.psql.proc;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.dbwrench.jdbc.Dbms;
import com.harrand.dbwrench.metaData.helper.psql.proc.PSqlProcArgument;
import com.harrand.dbwrench.metaData.helper.psql.proc.PsqlProcArgumentMgr;
import com.harrand.dbwrench.object.Proc;
import com.harrand.util.LogUtil;
import com.harrand.util.Validator;
import com.harrand.util.XmlHelper;
import java.util.List;

public class PsqlProcBldr {
    private PsqlProcArgumentMgr argMgr;
    private Dbms dbms = Dbms.getDbms("PostgreSql");
    private final String srcCode;
    private String schNm;
    private String procNm;
    private boolean useSchNm;
    private String retSetAbbr;
    private String resultTypeRaw;
    private String cmm;
    private String language;
    private String volatileAbbr;
    private String strictFlag;
    private String delimit;
    private String cost = null;
    private String rows = null;
    private String binInvoke;
    public static final String IMMUTABLE_ABBR = "i";
    public static final String IMMUTABLE_STR = "IMMUTABLE";
    public static final String STABLE_ABBR = "s";
    public static final String VOLATILE_ABBR = "v";
    public static final String STABLE_STR = "STABLE";
    public static final String STRICT_STR = "STRICT";
    public static final String VOLATILE_STR = "VOLATILE";
    public static final String RETURNS_STR = "RETURNS";

    public PsqlProcBldr(String srcCode, String nmsStr, String typesStr, String modesStr, String argTypesStr) {
        this.argMgr = new PsqlProcArgumentMgr(nmsStr, typesStr, modesStr, argTypesStr);
        this.srcCode = srcCode;
    }

    public Proc buildProc() {
        String fullNm = this.getFullNm();
        String textA = this.buildProcText();
        String textB = this.postProcessText(textA, fullNm);
        Proc proc = new Proc(textB, this.cmm, "defaultPsqlProcBldrName");
        return proc;
    }

    private String buildProcText() {
        String fullNm = this.getFullNm();
        String constructArgStr = this.getArgStr(this.argMgr.getConstructorArgs());
        String volatileStr = this.getVolatileStr();
        String strictStr = this.getStrictStr();
        String costStr = this.getCostStr();
        String rowsStr = this.getRowsStr();
        String procText = "CREATE OR REPLACE FUNCTION " + fullNm + "(" + constructArgStr + ") \n" + this.getReturnsPhrase() + " AS \n" + this.delimit + this.getFullSrc() + this.delimit + "\n" + "  LANGUAGE " + this.language + " " + volatileStr + " " + strictStr + costStr + rowsStr + ";";
        return procText;
    }

    private String getFullNm() {
        String usableSchNm = this.useSchNm ? this.schNm + "." : "";
        String fullNm = usableSchNm + this.procNm;
        if (this.dbms.checkDblQuotePsqlNm(fullNm)) {
            fullNm = StrHelper.encloseDblQuotesDotNote(fullNm);
        }
        return fullNm;
    }

    private String getFullSrc() {
        if (Validator.isStringValid(this.binInvoke)) {
            return "'" + this.binInvoke + "', '" + this.srcCode + "'";
        }
        return this.srcCode;
    }

    private String getArgStr(List<PSqlProcArgument> args) {
        StringBuilder sb = new StringBuilder();
        for (PSqlProcArgument arg : args) {
            sb.append(arg.getFormattedText()).append(", ");
        }
        String trimmed = sb.toString().trim();
        String str = StrHelper.removeTrailingChar(trimmed, ",");
        return str;
    }

    private String getReturnsPhrase() {
        if (this.argMgr.hasTableModeArgs()) {
            return this.getReturnsTablePhrase();
        }
        return this.getReturnsBasic();
    }

    private String getReturnsBasic() {
        String setOfStr = this.getSetOfStr();
        String resultType = this.getResultType();
        String phrase = "  RETURNS " + setOfStr + resultType;
        return phrase;
    }

    private String getReturnsTablePhrase() {
        String argsText = this.getArgStr(this.argMgr.getTableArgs());
        String phrase = "  RETURNS TABLE(" + argsText + ")";
        return phrase;
    }

    private String getSetOfStr() {
        String setOfStr = this.retSetAbbr.equalsIgnoreCase("t") ? "SETOF " : "";
        return setOfStr;
    }

    private String getResultType() {
        return this.resultTypeRaw;
    }

    private String getVolatileStr() {
        String str = VOLATILE_STR;
        if (this.volatileAbbr.equalsIgnoreCase(IMMUTABLE_ABBR)) {
            str = IMMUTABLE_STR;
        } else if (this.volatileAbbr.equalsIgnoreCase(STABLE_ABBR)) {
            str = STABLE_STR;
        }
        return str;
    }

    private String getStrictStr() {
        String strictStr = this.strictFlag.equalsIgnoreCase("t") ? STRICT_STR : "";
        return strictStr;
    }

    private String getRowsStr() {
        if (this.rows != null && this.isRowsGreaterThanZero()) {
            return "\n  ROWS " + this.trimDecimalZero(this.rows);
        }
        return "";
    }

    private boolean isRowsGreaterThanZero() {
        boolean isValid = false;
        try {
            double dbl = Double.parseDouble(this.rows);
            if (dbl > 0.0) {
                isValid = true;
            }
        }
        catch (NumberFormatException ex) {
            LogUtil.logErr("PsqlProcBldr could not parse rows: " + this.rows);
        }
        return isValid;
    }

    private String getCostStr() {
        if (this.cost != null) {
            return "\n  COST " + this.trimDecimalZero(this.cost);
        }
        return "";
    }

    private String trimDecimalZero(String str) {
        if (str.indexOf(".0") > 0) {
            return str.replaceFirst("\\.0", "");
        }
        return str;
    }

    private String postProcessText(String str, String fullNm) {
        String textOut = XmlHelper.stripNonValidXMLCharacters(str, "Procedure", fullNm);
        return textOut;
    }

    public void setComment(String cmm) {
        this.cmm = cmm;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setProcNm(String procNm) {
        this.procNm = procNm;
    }

    public void setResultTypeRaw(String resultTypeRaw) {
        this.resultTypeRaw = resultTypeRaw;
    }

    public void setRetSetAbbr(String retSetAbbr) {
        this.retSetAbbr = retSetAbbr;
    }

    public void setSchNm(String schNm) {
        this.schNm = schNm;
    }

    public void setUseSchNm(boolean useSchNm) {
        this.useSchNm = useSchNm;
    }

    public void setStrictFlag(String strictFlag) {
        this.strictFlag = strictFlag;
    }

    public void setVolatileAbbr(String volatileAbbr) {
        this.volatileAbbr = volatileAbbr;
    }

    public void setDelimit(String delimit) {
        this.delimit = delimit;
    }

    public void setCost(String cost) {
        this.cost = cost;
    }

    public void setRows(String rows) {
        this.rows = rows;
    }

    public void setBinInvoke(String binInvoke) {
        this.binInvoke = binInvoke;
    }
}

