/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.metaData.helper.psql.proc;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.dbwrench.metaData.helper.psql.proc.PSqlProcArgument;
import com.harrand.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class PsqlProcArgumentMgr {
    private List<PSqlProcArgument> args;
    private final String nmsStr;
    private final String modesStr;
    private final String typesStr;
    private final String allTypesStr;
    private String[] nmsArray = null;
    private String[] typesArray = null;
    private String[] modeArray = null;
    private String[] allTypesArray = null;

    public PsqlProcArgumentMgr(String nmsStr, String typesStr, String modesStr, String argTypesStr) {
        this.nmsStr = nmsStr;
        this.modesStr = modesStr;
        this.typesStr = typesStr;
        this.allTypesStr = argTypesStr;
        this.buildArgObjects();
    }

    public List<PSqlProcArgument> getArguments() {
        return this.args;
    }

    private void buildArgObjects() {
        this.args = new ArrayList<PSqlProcArgument>();
        if (!this.hasArguments()) {
            return;
        }
        if (this.modesStr == null) {
            this.buildConstructorOnlyArgs();
        } else {
            this.buildModeArgs();
        }
    }

    public boolean hasTableModeArgs() {
        for (PSqlProcArgument arg : this.args) {
            if (!arg.isTableMode()) continue;
            return true;
        }
        return false;
    }

    public boolean hasArguments() {
        boolean hasTypes = Validator.isStringValid(this.typesStr);
        boolean hasAllTypes = Validator.isStringValid(this.allTypesStr);
        return hasTypes || hasAllTypes;
    }

    public List<PSqlProcArgument> getConstructorArgs() {
        ArrayList<PSqlProcArgument> constructorArgs = new ArrayList<PSqlProcArgument>();
        for (PSqlProcArgument arg : this.args) {
            if (arg.isTableMode()) continue;
            constructorArgs.add(arg);
        }
        return constructorArgs;
    }

    public List<PSqlProcArgument> getTableArgs() {
        ArrayList<PSqlProcArgument> tableArgs = new ArrayList<PSqlProcArgument>();
        for (PSqlProcArgument arg : this.args) {
            if (!arg.isTableMode()) continue;
            tableArgs.add(arg);
        }
        return tableArgs;
    }

    private void buildModeArgs() {
        this.parseNms();
        this.parseAllTypes();
        this.parseModes();
        this.collateValues();
    }

    private void buildConstructorOnlyArgs() {
        this.parseNms();
        this.parseTypes();
        this.collateValues();
    }

    private void collateValues() {
        boolean hasNms = this.nmsArray != null;
        boolean hasModes = this.modeArray != null;
        boolean usesAllTypes = this.allTypesArray != null;
        int argCount = usesAllTypes ? this.allTypesArray.length : this.typesArray.length;
        for (int i = 0; i < argCount; ++i) {
            String nm = hasNms ? this.nmsArray[i] : "";
            String mode = hasModes ? this.modeArray[i] : "u";
            String type = usesAllTypes ? this.allTypesArray[i] : this.typesArray[i];
            PSqlProcArgument argument = new PSqlProcArgument(nm, type, mode);
            this.args.add(argument);
        }
    }

    private void parseNms() {
        this.nmsArray = this.nmsStr != null ? this.splitTrimStr(this.removeBraces(this.nmsStr)) : null;
    }

    private void parseTypes() {
        this.typesArray = this.splitTrimStr(this.typesStr);
    }

    private void parseAllTypes() {
        this.allTypesArray = this.splitTrimStr(this.allTypesStr);
    }

    private void parseModes() {
        this.modeArray = this.splitTrimStr(this.removeBraces(this.modesStr));
    }

    private String removeBraces(String str) {
        return StrHelper.removeEnclosingChars(str, "{", "}").trim();
    }

    private String[] splitTrimStr(String str) {
        String[] tempArray = str.split(",");
        for (int i = 0; i < tempArray.length; ++i) {
            tempArray[i] = tempArray[i].trim();
        }
        return tempArray;
    }
}

