/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.metaData.bldr;

import com.harrand.dbwrench.metaData.JdbcMetaDataCtrl;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.table.constraint.ColumnsRequiredException;
import com.harrand.dbwrench.object.table.constraint.UniqueConstraint;
import java.util.ArrayList;
import java.util.List;
import org.openide.util.Exceptions;

public class UniqueConstraintAdder {
    private JdbcMetaDataCtrl jdbcMetaDataCtrl;
    public static final int UC_SCH_NM_POS = 0;
    public static final int UC_TBL_NM_POS = 1;
    public static final int UC_COL_NM_POS = 2;
    public static final int UC_NM_POS = 3;
    public final String MILESTONE_UC_ADDED = "engineer.reverse.milestone.uc.added";

    public void addUniqueConstraints(Database db, List<String[]> strArrays) {
        Table table = null;
        ArrayList<Column> cols = new ArrayList<Column>();
        String prevUcNm = "";
        int rowCount = strArrays.size();
        int iNext = 0;
        for (String[] strArray : strArrays) {
            ++iNext;
            String schNm = strArray[0];
            String tblNm = strArray[1];
            String colNm = strArray[2];
            String ucNm = strArray[3];
            Schema schema = db.getSchema(schNm);
            table = schema.getTable(tblNm);
            Column col = table.getColumn(colNm);
            cols.add(col);
            String[] nextRow = iNext < rowCount ? strArrays.get(iNext) : null;
            String nextNm = nextRow != null ? nextRow[3] : null;
            boolean doAdd = nextNm == null || !nextNm.equalsIgnoreCase(ucNm);
            if (!doAdd) continue;
            this.addUniqueConstraint(table, cols, ucNm);
            cols = new ArrayList();
        }
    }

    public void setJdbcMetaDataCtrl(JdbcMetaDataCtrl jdbcMetaDataCtrl) {
        this.jdbcMetaDataCtrl = jdbcMetaDataCtrl;
    }

    private void addUniqueConstraint(Table table, List<Column> cols, String ucNm) {
        try {
            String tblNm = table.getName();
            UniqueConstraint uc = new UniqueConstraint(table, cols, ucNm);
            table.add(uc);
            if (this.jdbcMetaDataCtrl != null) {
                this.jdbcMetaDataCtrl.notifyObserversDisp("engineer.reverse.milestone.uc.added", tblNm + "." + ucNm);
            }
        }
        catch (ColumnsRequiredException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

