/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.metaData;

import com.harrand.coreclasses.element.Version;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.dbwrench.jdbc.ConnectionFactory;
import com.harrand.dbwrench.jdbc.CustomTypeIdCtrl;
import com.harrand.dbwrench.jdbc.DataType;
import com.harrand.dbwrench.jdbc.DataTypeSvr;
import com.harrand.dbwrench.jdbc.Dbms;
import com.harrand.dbwrench.jdbc.IDataType;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.metaData.JdbcMetaDataCtrl;
import com.harrand.dbwrench.metaData.helper.psql.proc.PsqlNativeTypeOID_Mapper;
import com.harrand.dbwrench.metaData.helper.psql.proc.PsqlProcBldr;
import com.harrand.dbwrench.metaData.ignore.PsqlIgnoreCtrlx;
import com.harrand.dbwrench.metaData.postgresql.PsqlIndexRevEngCtrl;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.CustomType;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Proc;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Sequence;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.Trigger;
import com.harrand.dbwrench.object.View;
import com.harrand.dbwrench.script.compare.formatter.PsqlViewFormatter;
import com.harrand.dbwrench.script.converter.IDataTypeConverter;
import com.harrand.dbwrench.script.converter.PostgreSqlDataTypeConverter;
import com.harrand.util.FileHelper;
import com.harrand.util.LogUtil;
import com.harrand.util.Validator;
import com.harrand.util.XmlHelper;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class PostgreSqlMetaDataCtrlFIX
extends JdbcMetaDataCtrl {
    private static final String NEXTVAL_EVALUTION_STR = "nextval(";
    private IDataTypeConverter dataTypeConverter_;
    private Dbms dbms_ = Dbms.getDbms("PostgreSql");
    private PsqlNativeTypeOID_Mapper psqlNativeTypeOID_Mapper = new PsqlNativeTypeOID_Mapper();
    private PsqlIgnoreCtrlx ignoreCtrl;
    private Map tblComments_ = new HashMap();
    private Map colComments_ = new HashMap();
    private Map fkComments_ = new HashMap();
    private Map procComments_ = new HashMap();
    private Map schComments_ = new HashMap();
    private Map hasOidsMap_ = new HashMap();
    private Map inheritsMap_ = new HashMap();
    private Map colAttNumsMap_ = new HashMap();
    public static final String NOT_LIKE_PG_STR = "NOT LIKE 'pgE_%' ESCAPE 'E'\n";
    private static final String NOT_LIKE_SQL_STR = "NOT LIKE 'sqlE_%' ESCAPE 'E'\n";
    public static final Version VER_PG_CATALOG = new Version("7.3.0");
    public static final Version VER_PG_COL_SCHEMA = new Version("7.4.1");
    public static final Version VER_PROC_COST = new Version("8.3.0");
    private static final Version DEFAULT_VERSION = new Version("8.0.0");
    private static final Version VER_TG_CONSTRAINT_ID = new Version("8.3.0");
    public static final int DEC_LENGTH_MAX = 1000;
    public static final int DEC_SCALE_MAX = 1000;
    private static final String META_CTRL_NM = "PSqlMetaCtrl";
    private static final String COLUMN_QUERY = "SELECT DISTINCT ON (nsp.nspname, c.relname, a.attnum) \n\tnsp.nspname, c.relname, \n\ta.attname, a.attnum, \n\tformat_type(a.atttypid, a.atttypmod), \n\ta.attnotnull, d.adsrc \nFROM pg_class as c \n\tJOIN pg_attribute as a on c.oid = a.attrelid \n\tJOIN pg_type as t on a.atttypid = t.oid \n\tJOIN pg_namespace as nsp on c.relnamespace = nsp.oid\n\tJOIN pg_tables as tb on tb.tablename = c.relname \n\tleft JOIN pg_attrdef as d \n\ton a.attrelid = d.adrelid AND a.attnum = d.adnum\nWHERE a.attnum > 0 \n\tAND nsp.nspname NOT LIKE 'pgE_%' ESCAPE 'E'\n\tAND nsp.nspname NOT LIKE 'sqlE_%' ESCAPE 'E'\n\tAND nsp.nspname not like 'information_schema%'\norder by nsp.nspname, c.relname, a.attnum;";

    public PostgreSqlMetaDataCtrlFIX(JdbcConfig config) {
        super(config);
        this.dataTypeConverter_ = config.getDataTypeConverter();
        this.ignoreCtrl = new PsqlIgnoreCtrlx(this.getConfig().getSchemaIgnoreCtrl());
    }

    @Override
    public Database reverseEngineer() throws Exception {
        this.conn_ = ConnectionFactory.getConnection(this.getConfig());
        this.getConfig().setVersion(this.getDbmsVersion());
        this.setComments();
        this.setColAttNums();
        Database newDb = super.reverseEngineer();
        newDb.getNotifyMgr().setEnabled(false);
        this.setHasOidsMap();
        this.setInheritsMap();
        this.setTableOptionsDisp(newDb);
        if (this.isProcRevEngEnabled()) {
            this.addProcs(newDb);
        }
        if (this.isSeqRevEngEnabled()) {
            this.addSequences(newDb);
        }
        if (this.isTriggerRevEngEnabled()) {
            this.addTriggersDisp(newDb);
        }
        super.doPostRevEngTasks();
        this.conn_.close();
        newDb.getNotifyMgr().setEnabled(true);
        return newDb;
    }

    @Override
    public Database revEngForSync() throws Exception {
        this.conn_ = ConnectionFactory.getConnection(this.getConfig());
        Database svrDb = new Database(this.getConfig().getObjectInstanceName());
        this.removeDefaultSchema(svrDb);
        this.addSchemas(svrDb);
        this.addSequences(svrDb);
        return svrDb;
    }

    @Override
    public Version getDbmsVersion() throws Exception {
        Version version = DEFAULT_VERSION;
        String rawText = "";
        String sql = "SELECT version()";
        Connection cxn = ConnectionFactory.getConnection(this.getConfig());
        try {
            ResultSet rs = ConnectionFactory.doSql(cxn, sql);
            if (rs.next()) {
                rawText = rs.getString("version").toLowerCase();
                version = this.parseVersion(rawText);
            }
        }
        catch (Exception e) {
            String msg = e.getMessage() + "; rawText: " + rawText;
            this.logError(msg, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", msg);
        }
        ConnectionFactory.close(cxn);
        return version;
    }

    public Version parseVersion(String rawText) throws Exception {
        int startIdx = rawText.indexOf(" ");
        StringBuffer sb = new StringBuffer();
        int i = startIdx + 1;
        boolean isDigit = true;
        boolean isPeriod = true;
        boolean validChar = true;
        while (validChar) {
            char ch = rawText.charAt(i);
            isDigit = Character.isDigit(ch);
            isPeriod = ch == '.';
            boolean bl = validChar = isDigit || isPeriod;
            if (validChar) {
                sb.append(ch);
            }
            ++i;
        }
        String dotNotation = sb.toString();
        Version version = sb.length() > 0 ? new Version(dotNotation) : DEFAULT_VERSION;
        return version;
    }

    @Override
    protected void addSchemas(Database newDb) {
        this.notifyObserversDisp("engineer.reverse.status.schemas");
        this.removeDefaultSchema(newDb);
        String sql = "SELECT nspname \nFROM pg_namespace \nWHERE " + this.getSchemaFilter(null);
        try {
            ResultSet rs = ConnectionFactory.doSql(this.conn_, sql);
            while (rs.next()) {
                try {
                    String schNm = rs.getString("nspname");
                    Schema schema = new Schema(schNm);
                    newDb.add(schema);
                    Object objCmm = this.schComments_.get(schNm);
                    if (objCmm instanceof String) {
                        schema.setComment((String)objCmm);
                    }
                    this.notifyObserversDisp("engineer.reverse.milestone.schema.added", schNm);
                }
                catch (Exception e) {
                    this.logError(e, META_CTRL_NM);
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                }
            }
            ConnectionFactory.close(rs);
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
    }

    @Override
    protected void addTables(DatabaseMetaData dbmd, Database db) {
        this.notifyObserversDisp("engineer.reverse.status.tables");
        long start = System.currentTimeMillis();
        String sql = "SELECT schemaname, tablename \nFROM pg_tables \nWHERE " + this.getSchemaFilter(null, "schemaname");
        try {
            ResultSet rs = ConnectionFactory.doSql(this.conn_, sql);
            while (rs.next()) {
                try {
                    String schNm = rs.getString("schemaname");
                    String tblNm = rs.getString("tablename");
                    if (!this.isUserTable(tblNm)) continue;
                    Schema schema = db.getSchema(schNm);
                    Table table = new Table(tblNm);
                    String dotNote = schNm + "." + tblNm;
                    table.setUseManualSort(true);
                    Object cmmObj = this.tblComments_.get(dotNote);
                    if (cmmObj != null) {
                        table.setComment((String)cmmObj);
                    }
                    this.tableNms_.add(dotNote);
                    schema.add(table);
                    this.notifyObserversDisp("engineer.reverse.milestone.table.added", tblNm);
                }
                catch (Exception e) {
                    this.logError(e, META_CTRL_NM);
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                }
            }
            ConnectionFactory.close(rs);
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
        long finish = System.currentTimeMillis();
    }

    @Override
    protected void addColumns(Database db) {
        String sql = COLUMN_QUERY;
        try {
            String dotNote = "";
            String colNm = null;
            String tblDotNote = null;
            Statement stmt = this.conn_.createStatement();
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                try {
                    Object commentObj;
                    String schNm = rs.getString("nspname");
                    String tblNm = rs.getString("relname");
                    tblDotNote = schNm + "." + tblNm;
                    if (!this.tableNms_.contains(tblDotNote)) continue;
                    Schema schema = db.getSchema(schNm);
                    Table table = schema.getTable(tblNm);
                    colNm = rs.getString("attname");
                    dotNote = tblNm + "." + colNm;
                    String formatType = rs.getString("format_type");
                    boolean isArray = formatType.contains("[]");
                    String dataTypeStr = formatType.split("\\(")[0];
                    dataTypeStr = dataTypeStr.split("\\[")[0];
                    String dataTypeDesc = this.getDataTypeDesc(db, dataTypeStr, schema);
                    IDataType dataType = this.dataTypeConverter_.getDataType(db, schema, dataTypeDesc);
                    String defaultRaw = rs.getString("adsrc");
                    String isNotNullStr = rs.getString("attnotnull");
                    boolean isNullable = isNotNullStr.equalsIgnoreCase("f");
                    boolean autoNumber = this.parseAutoNumber(defaultRaw);
                    Integer length = null;
                    if (dataType.isLengthUsed()) {
                        length = StrHelper.extractLength(formatType);
                    }
                    Integer scale = null;
                    if (dataType.isScaleUsed()) {
                        scale = StrHelper.extractScale(formatType);
                    }
                    String comment = (commentObj = this.colComments_.get(dotNote)) != null ? commentObj.toString() : "";
                    String defaultValue = this.parseDefault(dataType, defaultRaw);
                    Column newCol = new Column(colNm, dataType, length, isNullable, autoNumber, defaultValue, scale, comment, true, "");
                    newCol.setIsArray(isArray);
                    ITestResult result = table.add(newCol);
                    this.checkResult(result);
                }
                catch (Exception e) {
                    String objDesc = this.getNullSafe(tblDotNote) + "." + this.getNullSafe(colNm);
                    this.logError(e, META_CTRL_NM, objDesc);
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                }
            }
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
    }

    private String getDataTypeDesc(Database db, String dataTypeStr, Schema tblSch) {
        String dataTypeDesc = dataTypeStr;
        PostgreSqlDataTypeConverter psqlConv = (PostgreSqlDataTypeConverter)this.dataTypeConverter_;
        boolean isInexactMatch = psqlConv.getInexactTypeId(dataTypeStr) != null;
        boolean contains = DataTypeSvr.contains(db, dataTypeStr);
        if (!isInexactMatch && !contains) {
            Schema dtSch = tblSch;
            if ((dataTypeDesc = StrHelper.removeDblQuotes(dataTypeDesc)).indexOf(".") >= 0) {
                String[] strs = StrHelper.splitDotNote(dataTypeDesc);
                String dtSchNm = strs[0];
                dataTypeDesc = strs[1];
                if (db.contains(Schema.getClassName(), dtSchNm)) {
                    dtSch = db.getSchema(dtSchNm);
                } else {
                    String msg = super.getCustomTypeSchemaNotFoundMsg(dataTypeDesc, dtSchNm);
                    this.notifyObserversDisp("engineer.reverse.milestone.warn", msg);
                    return dataTypeDesc;
                }
            }
            CustomType type = CustomTypeIdCtrl.instance().createCustomType(db, dataTypeDesc, "");
            dtSch.add(type);
        }
        return dataTypeDesc;
    }

    private void setColAttNums() {
        this.colAttNumsMap_ = new HashMap();
        String sql = "SELECT cl.oid as \"tblOid\", \ncl.relname, \natt.attname, \natt.attnum \nFROM pg_class as cl \n\tJOIN pg_attribute as att on cl.oid = att.attrelid \nWHERE cl.relkind = 'r' \n\tAND cl.relname NOT LIKE 'pgE_%' ESCAPE 'E'\n\tAND cl.relname NOT LIKE 'sqlE_%' ESCAPE 'E'\n\tAND att.attnum > -1";
        try {
            Statement stmt = this.conn_.createStatement();
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                try {
                    String tblNm = rs.getString("relname");
                    int tblOid = rs.getInt("tblOid");
                    String colNm = rs.getString("attname");
                    int attNum = rs.getInt("attnum");
                    String colIdDotNot = Integer.toString(tblOid) + "." + Integer.toString(attNum);
                    this.colAttNumsMap_.put(colIdDotNot, colNm);
                }
                catch (Exception e) {
                    this.logError(e, META_CTRL_NM);
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                }
            }
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
    }

    public Map getColumnLength74() {
        String sql = "SELECT c.relname, \natt.attname, \natt.atttypmod \nFROM pg_attribute as att \n\tJOIN pg_class as c on att.attrelid = c.oid \nWHERE c.relname NOT LIKE 'pgE_%' ESCAPE 'E'\n\tAND c.relname NOT LIKE 'sqlE_%' ESCAPE 'E'\n\tAND c.relkind = 'r' \n\tAND att.atttypmod > -1 \n\tAND att.attname != 'ctid' \n\tAND att.attname != 'oid' \n\tAND att.attname != 'xmin' \n\tAND att.attname != 'xmax' \n\tAND att.attname != 'cmin' \n\tAND att.attname != 'cmax' \n\tAND att.attname != 'tableoid'";
        HashMap<String, Integer> lengthsMap = new HashMap<String, Integer>();
        try {
            Statement stmt = this.conn_.createStatement();
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                try {
                    String tblNm = rs.getString("relname");
                    String colNm = rs.getString("attname");
                    int rawLength = rs.getInt("atttypmod");
                    int length = rawLength - 4;
                    if (length < 0) {
                        length = 1;
                    }
                    String dotNote = tblNm + "." + colNm;
                    lengthsMap.put(dotNote, new Integer(length));
                }
                catch (Exception e) {
                    this.logError(e, META_CTRL_NM);
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                }
            }
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
        return lengthsMap;
    }

    private Integer[] verifyLengthScaleLimits(Integer[] lengthScaleArray, DataType dataType) {
        int dataTypeId = dataType.getId();
        if (dataTypeId == 2 || dataTypeId == 3) {
            if (lengthScaleArray[0] > 1000) {
                lengthScaleArray[0] = new Integer(1000);
            }
            if (lengthScaleArray[1] > 1000) {
                lengthScaleArray[1] = new Integer(1000);
            }
        }
        return lengthScaleArray;
    }

    public String parseDefault(IDataType dataType, String defaultRaw) throws Exception {
        String defaultStr = "";
        if (Validator.isStringValid(defaultRaw)) {
            try {
                if (StrHelper.isNumeric(defaultRaw)) {
                    defaultStr = defaultRaw;
                } else if (dataType.isNumberLikeType() && !this.isNextVal(defaultRaw)) {
                    String tempA = defaultRaw.replaceAll("\\(", "");
                    defaultStr = tempA.replaceAll("\\)", "");
                } else if (defaultRaw.substring(0, 1).equals("'")) {
                    String[] parts = defaultRaw.split("'");
                    defaultStr = parts[1];
                } else {
                    defaultStr = !(defaultRaw.indexOf("(") < 0 && defaultRaw.indexOf(")") < 0 || this.isNextVal(defaultStr)) ? defaultRaw : defaultRaw;
                }
            }
            catch (Exception e) {
                this.logError(e, META_CTRL_NM);
                throw new Exception(FileHelper.getRes("err.parse.failed.for") + defaultRaw);
            }
        }
        return defaultStr;
    }

    private boolean isNextVal(String defaultStr) {
        return defaultStr.indexOf("nextval") >= 0;
    }

    protected void checkAutoIncrementColumns(List tables) {
    }

    @Override
    protected void addPks(Database db) {
        long start = System.currentTimeMillis();
        String sql = "SELECT \nnsp.nspname as \"SchNm\", \ncl.relname, \ncl.oid as \"tblOid\", \nconname, \nconkey \nFROM pg_constraint as co \n\tJOIN pg_class as cl on co.conrelid = cl.oid \n\tJOIN pg_namespace as nsp on cl.relnamespace = nsp.oid \nWHERE " + this.getSchemaFilter("nsp") + "\n" + "\tAND contype = 'p'";
        ArrayList<String[]> strArrays = new ArrayList<String[]>();
        try {
            Statement stmt = this.conn_.createStatement();
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                try {
                    String schNm = rs.getString("SchNm");
                    String tblNm = rs.getString("relname");
                    int tblOid = rs.getInt("tblOid");
                    String pkNm = rs.getString("conname");
                    String colIds = rs.getString("conkey");
                    List attIds = this.parseConstraintAttId(colIds);
                    for (int i = 0; i < attIds.size(); ++i) {
                        String attId = (String)attIds.get(i);
                        String keyId = Integer.toString(tblOid) + "." + attId;
                        String colNm = (String)this.colAttNumsMap_.get(keyId);
                        String[] strArray = new String[]{schNm, tblNm, colNm, Integer.toString(i), pkNm};
                        strArrays.add(strArray);
                    }
                }
                catch (Exception e) {
                    super.logError(e, META_CTRL_NM);
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                }
            }
            ConnectionFactory.close(rs);
        }
        catch (Exception e) {
            super.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
        this.itemBldr_.addPks(db, strArrays);
        long finish = System.currentTimeMillis();
    }

    @Override
    protected void addUniqueConstraints(Database db) {
        String sql = "SELECT \nco.oid, \nnsp.nspname as \"SchNm\",  \ncl.relname,  \ncl.oid as \"tblOid\", \nconname,  \nconkey, \nci.relname as \"dep_idx_nm\" \nFROM pg_constraint as co \n\tJOIN pg_class as cl on co.conrelid = cl.oid  \n\tJOIN pg_namespace as nsp on cl.relnamespace = nsp.oid  \n\tJOIN pg_depend as dep on co.oid = dep.refobjid \n\tJOIN pg_index as idx on dep.objid = idx.indexrelid \n\tJOIN pg_catalog.pg_class ci ON idx.indexrelid = ci.oid  \nWHERE " + this.getSchemaFilter("nsp") + "\n" + "\tAND contype = 'u'";
        ArrayList<String[]> strArrays = new ArrayList<String[]>();
        try {
            Statement stmt = this.conn_.createStatement();
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                try {
                    String schNm = rs.getString("SchNm");
                    String tblNm = rs.getString("relname");
                    int tblOid = rs.getInt("tblOid");
                    String conNm = rs.getString("conname");
                    String colIds = rs.getString("conkey");
                    String depIndNm = rs.getString("dep_idx_nm");
                    List attIds = this.parseConstraintAttId(colIds);
                    for (int i = 0; i < attIds.size(); ++i) {
                        String attId = (String)attIds.get(i);
                        String keyId = Integer.toString(tblOid) + "." + attId;
                        String colNm = (String)this.colAttNumsMap_.get(keyId);
                        String[] strArray = new String[]{schNm, tblNm, colNm, conNm, Integer.toString(i)};
                        strArrays.add(strArray);
                    }
                    this.removeConstaintIndex(db, schNm, tblNm, depIndNm);
                }
                catch (Exception e) {
                    super.logError(e, META_CTRL_NM);
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                }
            }
            ConnectionFactory.close(rs);
        }
        catch (Exception e) {
            super.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
        this.itemBldr_.addUniqueConstraints(db, strArrays);
    }

    private void removeConstaintIndex(Database db, String schNm, String tblNm, String idxNm) {
        Schema sch = db.getSchema(schNm);
        Table tbl = sch.getTable(tblNm);
        tbl.remove("Index", idxNm);
    }

    @Override
    protected void addIndexes(Database db) {
        this.notifyObserversDisp("engineer.reverse.status.index");
        PsqlIndexRevEngCtrl indexRevEngCtrl = new PsqlIndexRevEngCtrl(this.ignoreCtrl);
        boolean supportsCatalog = this.supports(VER_PG_CATALOG);
        ITestResult result = indexRevEngCtrl.addIndexes(this.conn_, db, supportsCatalog, this.colAttNumsMap_);
        if (!result.getPassed()) {
            this.notifyObserversDisp("engineer.reverse.milestone.err", result.getDetail());
        }
    }

    private boolean isExpressionIndex(String schNm, String tblNm, String idxNm, String colIndexStr) {
        if (colIndexStr.equals("0")) {
            String[] strs = new String[]{schNm, tblNm, idxNm};
            String dotNote = StrHelper.getNullSafeDotNote(strs);
            LogUtil.logMsg("Note: Index " + dotNote + " is a expression " + "based index. These indexes are not " + "supported by DbWrench at this time.");
            return true;
        }
        return false;
    }

    @Override
    protected void addForeignKeys(DatabaseMetaData dbmd, Database db) {
        this.notifyObserversDisp("engineer.reverse.status.fks");
        long start = System.currentTimeMillis();
        String sql = "SELECT \nco.conname, \nclp.relname as \"parTblNm\", \nclc.relname as \"chdTblNm\", \nclp.oid as \"parTblOid\", \nclc.oid as \"chdTblOid\", \nnsp.nspname as \"parSchNm\", \nnsc.nspname as \"chdSchNm\", \nco.confkey as \"parColIds\", \nco.conkey as \"chdColIds\", \nco.confupdtype, \nco.confdeltype \nFROM pg_constraint as co \n\tJOIN pg_class as clp on co.confrelid = clp.oid \n\tJOIN pg_class as clc on co.conrelid = clc.oid \n\tJOIN pg_namespace as nsp on clp.relnamespace = nsp.oid \n\tJOIN pg_namespace as nsc on clc.relnamespace = nsc.oid \nWHERE " + this.getSchemaFilter("nsp") + "\n" + "\tAND " + this.getSchemaFilter("nsc") + "\n" + "ORDER BY conname";
        ArrayList<String[]> strArrays = new ArrayList<String[]>();
        HashMap<String, Integer> fkDelActionMap = new HashMap<String, Integer>();
        HashMap<String, Integer> fkUpdActionMap = new HashMap<String, Integer>();
        try {
            Statement stmt = this.conn_.createStatement();
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                try {
                    String fkNm = rs.getString("conname");
                    String parSchNm = rs.getString("parSchNm");
                    String chdSchNm = rs.getString("chdSchNm");
                    String parTblNm = rs.getString("parTblNm");
                    String chdTblNm = rs.getString("chdTblNm");
                    String parColIds = rs.getString("parColIds");
                    String chdColIds = rs.getString("chdColIds");
                    int parTblOid = rs.getInt("parTblOid");
                    int chdTblOid = rs.getInt("chdTblOid");
                    List parAttIds = this.parseConstraintAttId(parColIds);
                    List chdAttIds = this.parseConstraintAttId(chdColIds);
                    for (int i = 0; i < parAttIds.size(); ++i) {
                        String parAttId = (String)parAttIds.get(i);
                        String chdAttId = (String)chdAttIds.get(i);
                        String parKeyId = Integer.toString(parTblOid) + "." + parAttId;
                        String chdKeyId = Integer.toString(chdTblOid) + "." + chdAttId;
                        String parColNm = (String)this.colAttNumsMap_.get(parKeyId);
                        String chdColNm = (String)this.colAttNumsMap_.get(chdKeyId);
                        String[] strArray = new String[]{fkNm, parSchNm, chdSchNm, parTblNm, chdTblNm, parColNm, chdColNm};
                        strArrays.add(strArray);
                    }
                    String delActionAbbr = rs.getString("confdeltype");
                    Integer delActionId = this.getActionId(delActionAbbr);
                    String updActionAbbr = rs.getString("confupdtype");
                    Integer updActionId = this.getActionId(updActionAbbr);
                    fkDelActionMap.put(fkNm, delActionId);
                    fkUpdActionMap.put(fkNm, updActionId);
                }
                catch (Exception e) {
                    this.logError(e, META_CTRL_NM);
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                }
            }
            this.itemBldr_.setFkCommentMap(this.getFkComments());
            this.itemBldr_.setFkDelActionMap(fkDelActionMap);
            this.itemBldr_.setFkUpdActionMap(fkUpdActionMap);
            this.itemBldr_.addFks(db, strArrays);
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
        long finish = System.currentTimeMillis();
    }

    private Integer getActionId(String actionAbbr) {
        int id = 3;
        if (actionAbbr.equals("a")) {
            id = 3;
        } else if (actionAbbr.equals("c")) {
            id = 0;
        } else if (actionAbbr.equals("r")) {
            id = 1;
        } else if (actionAbbr.equals("n")) {
            id = 2;
        } else if (actionAbbr.equals("d")) {
            id = 4;
        }
        Integer idObj = new Integer(id);
        return idObj;
    }

    private boolean getFkColumnRowIsValid(int parAttrId, int chdAttrId, String parTblColIdStr, String chdTblColIdStr, int currentPairPos) {
        boolean rowIsValid = false;
        String parTblColIdStrTrim = parTblColIdStr.substring(1, parTblColIdStr.length() - 1);
        String chdTblColIdStrTrim = chdTblColIdStr.substring(1, chdTblColIdStr.length() - 1);
        String[] parTblColIdStrs = parTblColIdStrTrim.split(",");
        String[] chdTblColIdStrs = chdTblColIdStrTrim.split(",");
        try {
            int parCurrentId = Integer.parseInt(parTblColIdStrs[currentPairPos]);
            int chdCurrentId = Integer.parseInt(chdTblColIdStrs[currentPairPos]);
            rowIsValid = parCurrentId == parAttrId && chdCurrentId == chdAttrId;
        }
        catch (Exception e) {
            String msg = "PsqlMeta.getFkColumnRowIsValid.err: , msg: " + e.getMessage();
            this.logError(msg, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", msg);
        }
        return rowIsValid;
    }

    private int getPositionInKey(String colIdStr, String colId) {
        int pos = 0;
        String colIdStrTrim = colIdStr.substring(1, colIdStr.length() - 1);
        String[] colIdStrs = colIdStr.split(",");
        for (int i = 0; i < colIdStrs.length; ++i) {
            if (!colIdStr.equals(colIdStrs[i])) continue;
            return i;
        }
        return pos;
    }

    private List parseConstraintCols(Table table, String colIdStr) {
        String secondStr = colIdStr.substring(1, colIdStr.length() - 1);
        String mapNm = Column.getClassName();
        String[] idStrs = secondStr.split(",");
        ArrayList<String> colNms = new ArrayList<String>();
        for (int i = 0; i < idStrs.length; ++i) {
            try {
                int pos = Integer.parseInt(idStrs[i]) - 1;
                String colNm = (String)table.getItemNames(mapNm).get(pos);
                colNms.add(colNm);
                continue;
            }
            catch (Exception e) {
                LogUtil.printStackTrace(e);
                String msg = "PsqlMeta.parseConstraint.err on : " + idStrs[i] + ", msg: " + e.getMessage();
                this.notifyObserversDisp("engineer.reverse.milestone.err", msg);
            }
        }
        return colNms;
    }

    private List parseConstraintAttId(String colIdStr) {
        String secondStr = colIdStr.substring(1, colIdStr.length() - 1);
        String[] idStrs = secondStr.split(",");
        ArrayList<String> attIds = new ArrayList<String>();
        for (int i = 0; i < idStrs.length; ++i) {
            String attId = idStrs[i];
            attIds.add(attId);
        }
        return attIds;
    }

    private void addTriggersDisp(Database db) {
        String tg_constraint_text = this.getTgConstraintText();
        String sql = "SELECT nspt.nspname as \"trgSchNm\", \nrelname, tgname, tgtype, \nnspp.nspname as \"procSchNm\", \nproname \nFROM pg_trigger as tr \n\tJOIN pg_class as cl on tr.tgrelid = cl.oid \n\tJOIN pg_proc as pr on tr.tgfoid = pr.oid \n\tJOIN pg_namespace as nspt on cl.relnamespace = nspt.oid \n\tJOIN pg_namespace as nspp on pr.pronamespace = nspp.oid \nWHERE " + this.getSchemaFilter("nspt") + "\n" + "\tAND " + tg_constraint_text + " \n" + "\tAND cl.relname != 'pg_shadow' \n" + "\tAND cl.relname != 'pg_authid' \n" + "\tAND cl.relname != 'pg_auth_members' \n" + "\tAND cl.relname != 'pg_database' \n" + "\tAND cl.relname != 'pg_group'  ;";
        try {
            Statement stmt = this.conn_.createStatement();
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            this.addTriggers(rs, db);
        }
        catch (Exception e) {
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
            this.logError(e, META_CTRL_NM);
        }
    }

    private String getTgConstraintText() {
        if (this.supports(VER_TG_CONSTRAINT_ID)) {
            return "tr.tgconstraint = 0";
        }
        return "tr.tgisconstraint = 'f'";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addTriggers(ResultSet triggerRs, Database db) {
        this.notifyObserversDisp("engineer.reverse.status.triggers");
        try {
            while (triggerRs.next()) {
                try {
                    String calledProc;
                    String schNm = triggerRs.getString("trgSchNm");
                    String tableName = triggerRs.getString("relname");
                    String trgName = triggerRs.getString("tgname");
                    String procSchNm = triggerRs.getString("procSchNm");
                    String procNmRaw = triggerRs.getString("proname");
                    int tgType = triggerRs.getInt("tgtype");
                    if (procNmRaw.indexOf(")") < 0) {
                        procNmRaw = procNmRaw + "()";
                    }
                    String procDotNote = procSchNm + "." + procNmRaw;
                    String string = calledProc = db.getHasManySchemas() ? procDotNote : procNmRaw;
                    if (this.dbms_.checkDblQuotePsqlNm(calledProc)) {
                        calledProc = StrHelper.getDblEnquotedBracketNm(calledProc);
                    }
                    boolean forEachRow = (tgType & 1) > 0;
                    boolean execBefore = (tgType & 2) > 0;
                    boolean onDelete = (tgType & 8) > 0;
                    boolean onInsert = (tgType & 4) > 0;
                    boolean onUpdate = (tgType & 0x10) > 0;
                    Trigger trigger = new Trigger(trgName, onDelete, onInsert, onUpdate, calledProc, execBefore, forEachRow);
                    Schema schema = db.getSchema(schNm);
                    Table table = schema.getTable(tableName);
                    ITestResult result = table.add(trigger);
                    this.checkResult(result);
                    if (!result.getPassed()) continue;
                    this.notifyObserversDisp("engineer.reverse.milestone.trigger.added", trgName);
                }
                catch (Exception e) {
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                    this.logError(e, META_CTRL_NM);
                }
            }
            return;
        }
        catch (Exception e) {
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
            this.logError(e, META_CTRL_NM);
        }
    }

    @Override
    protected void addViews(DatabaseMetaData dbmd, Database db) {
        this.notifyObserversDisp("engineer.reverse.status.views");
        long start = System.currentTimeMillis();
        String sql = "SELECT schemaname, viewname \nFROM pg_views \nWHERE " + this.getSchemaFilter(null, "schemaname") + " \n" + "\tAND viewname != 'pg_logdir_ls';";
        try {
            ResultSet rs = ConnectionFactory.doSql(this.conn_, sql);
            while (rs.next()) {
                try {
                    String schNm = rs.getString("schemaname");
                    String vwNm = rs.getString("viewname");
                    String vwSql = this.getViewSql(schNm, vwNm);
                    View view = new View(vwNm, vwSql);
                    Schema schema = db.getSchema(schNm);
                    schema.add(view);
                    this.notifyObserversDisp("engineer.reverse.milestone.view.added", view.getName());
                }
                catch (Exception e) {
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                    this.logError(e, META_CTRL_NM);
                }
            }
        }
        catch (Exception e) {
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
            this.logError(e, META_CTRL_NM);
        }
        long finish = System.currentTimeMillis();
    }

    private String getViewSql(String schNm, String vwNm) {
        String vwSql = "";
        String formattedDotNote = this.dbms_.getFormattedName(schNm) + "." + this.dbms_.getFormattedName(vwNm);
        try {
            String sendSql = "SELECT pg_get_viewdef('" + formattedDotNote + "', true)";
            ResultSet rs = ConnectionFactory.doSql(this.conn_, sendSql);
            while (rs.next()) {
                vwSql = rs.getString("pg_get_viewdef");
                vwSql = vwSql.replaceAll("\\;", "");
                vwSql = XmlHelper.stripNonValidXMLCharacters(vwSql, "View", vwNm);
                View vwTemp = new View("psqlMetaTmpVw", vwSql);
                PsqlViewFormatter formatter = new PsqlViewFormatter(vwTemp);
                vwSql = formatter.getFormattedSql();
            }
        }
        catch (Exception e) {
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
            this.logError(e, META_CTRL_NM);
        }
        return vwSql;
    }

    private void addProcs(Database db) {
        this.notifyObserversDisp("engineer.reverse.status.procs");
        long start = System.currentTimeMillis();
        String delimit = "'";
        String sql = this.getProcQuerySql72();
        if (this.supports(VER_PG_CATALOG)) {
            if (this.getConfig().supportsPgProcArgNms()) {
                sql = this.getProcQuerySql();
                delimit = "$$";
            } else {
                sql = this.getProcQuerySql73();
            }
        }
        boolean useSchNm = db.getSchemaCount() > 1;
        try {
            Statement stmt = this.conn_.createStatement();
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                try {
                    String schNm = rs.getString("SchNm");
                    String procNm = rs.getString("Name");
                    String argTypes = rs.getString("Argument data types");
                    String argNms = rs.getString("ArgNms");
                    String src = rs.getString("Source Code");
                    String argModes = rs.getString("ArgModes");
                    String argAllTypes = this.processAllDataTypesText(rs.getString("All data types"));
                    PsqlProcBldr bldr = new PsqlProcBldr(src, argNms, argTypes, argModes, argAllTypes);
                    bldr.setSchNm(schNm);
                    bldr.setProcNm(procNm);
                    bldr.setUseSchNm(useSchNm);
                    bldr.setDelimit(delimit);
                    bldr.setRetSetAbbr(rs.getString("RetSet"));
                    bldr.setResultTypeRaw(rs.getString("Result data type"));
                    bldr.setComment(rs.getString("Description"));
                    bldr.setLanguage(rs.getString("Language"));
                    bldr.setVolatileAbbr(rs.getString("Volatile"));
                    bldr.setStrictFlag(rs.getString("Strict"));
                    bldr.setBinInvoke(rs.getString("BinInvoke"));
                    if (this.supports(VER_PROC_COST)) {
                        bldr.setCost(rs.getString("Cost"));
                    }
                    if (this.supports(VER_PROC_COST)) {
                        bldr.setRows(rs.getString("Rows"));
                    }
                    Proc proc = bldr.buildProc();
                    Schema schema = db.getSchema(schNm);
                    if (schema != null) {
                        ITestResult result = schema.add(proc);
                        this.checkResult(result);
                        if (!result.getPassed()) continue;
                        this.notifyObserversDisp("engineer.reverse.milestone.proc.added", procNm);
                        continue;
                    }
                    LogUtil.logErr("PSqlMetaCtrl.Error adding proc to schema. ---------");
                    LogUtil.logErr("PSqlMetaCtrl.procNm: " + this.getNullSafe(procNm));
                    LogUtil.logErr("PSqlMetaCtrl.schemaNm: " + this.getNullSafe(schNm));
                    LogUtil.logErr("PSqlMetaCtrl --------------------------------------");
                    this.notifyObserversDisp("engineer.reverse.milestone.err", "Adding proc: " + this.getNullSafe(procNm));
                }
                catch (Exception e) {
                    this.logError(e, META_CTRL_NM);
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                }
            }
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
        long finish = System.currentTimeMillis();
    }

    private String getNullSafe(String str) {
        return StrHelper.getNullSafeString(str);
    }

    private String processAllDataTypesText(String oidArrayStr) {
        if (this.supports(VER_PROC_COST)) {
            return oidArrayStr;
        }
        return this.psqlNativeTypeOID_Mapper.getTypeNamesFromOIDs(oidArrayStr);
    }

    private void addSequences(Database db) {
        this.notifyObserversDisp("engineer.reverse.status.seqs");
        long start = System.currentTimeMillis();
        String sql = this.supports(VER_PG_CATALOG) ? this.getSequenceQuerySql73() : this.getSequenceQuerySql72();
        try {
            Statement stmt = this.conn_.createStatement();
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                try {
                    String schNm = rs.getString("SchNm");
                    String seqNm = rs.getString("Name");
                    String commentRaw = rs.getString("Description");
                    String comment = commentRaw != null ? commentRaw : "";
                    int increment = this.supports(VER_PG_CATALOG) ? this.getSequenceIncrement(schNm, seqNm) : 1;
                    if (increment <= -1) continue;
                    Sequence seq = new Sequence(seqNm, increment, comment);
                    Schema schema = db.getSchema(schNm);
                    ITestResult result = schema.add(seq);
                    this.checkResult(result);
                    if (result.getPassed()) {
                        this.notifyObserversDisp("engineer.reverse.milestone.seq.added", seqNm);
                        continue;
                    }
                    this.notifyObserversDisp("engineer.reverse.milestone.err", result.getDetail());
                }
                catch (Exception e) {
                    this.logError(e, META_CTRL_NM);
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                }
            }
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
        long finish = System.currentTimeMillis();
    }

    private int getSequenceIncrement(String schNm, String seqNm) {
        long start = System.currentTimeMillis();
        String sql = "SELECT sequence_name, increment_by FROM " + this.dbms_.getFormattedName(schNm) + "." + this.dbms_.getFormattedName(seqNm);
        int increment = -1;
        try {
            Statement stmt = this.conn_.createStatement();
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            if (rs.next()) {
                increment = rs.getInt("increment_by");
            }
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
        long finish = System.currentTimeMillis();
        return increment;
    }

    private void setComments() {
        this.setFirstLevelComments();
        this.setSecondLevelComments();
    }

    private void setFirstLevelComments() {
        long start = System.currentTimeMillis();
        this.tblComments_ = new HashMap();
        this.fkComments_ = new HashMap();
        this.procComments_ = new HashMap();
        String sql = "SELECT c.relname, 't', nsp.nspname as \"schNm\", \nde.description \nFROM pg_description as de \n\tJOIN pg_class as c on de.objoid = c.oid \n\tJOIN pg_namespace as nsp on c.relnamespace = nsp.oid \nWHERE de.objsubid = 0 \nunion \nSELECT con.conname, 'f', nsp.nspname || '.' || pcl.relName as \"schNm\",\nde.description \nFROM pg_description as de \n\tJOIN pg_constraint as con on de.objoid = con.oid \n\tJOIN pg_namespace as nsp on con.connamespace = nsp.oid \n\tJOIN pg_class as pcl on con.conrelid = pcl.oid \nunion \nSELECT ns.nspname, 'sch', ns.nspname as \"schNm\",\nde.description \nFROM pg_description as de \n\tJOIN pg_namespace as ns on de.objoid = ns.oid \nunion \nSELECT p.proname, 'p', '' as \"schNm\",\nde.description \nFROM pg_description as de \n\tJOIN pg_proc as p on de.objoid = p.oid \n\tLEFT JOIN pg_catalog.pg_namespace n ON n.oid = p.pronamespace \nWHERE " + this.getProcFilter();
        try {
            Statement stmt = this.conn_.createStatement();
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                try {
                    String objNm = rs.getString(1);
                    String type = rs.getString(2);
                    String schNm = rs.getString("schNm");
                    String cmm = rs.getString("description");
                    String dotNote = schNm + "." + objNm;
                    if (type.equals("p")) {
                        this.procComments_.put(dotNote, cmm);
                        continue;
                    }
                    if (type.equals("f")) {
                        this.fkComments_.put(dotNote, cmm);
                        continue;
                    }
                    if (type.equals("t")) {
                        this.tblComments_.put(dotNote, cmm);
                        continue;
                    }
                    if (!type.equals("sch")) continue;
                    this.schComments_.put(objNm, cmm);
                }
                catch (Exception e) {
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                    this.logError(e, META_CTRL_NM);
                }
            }
        }
        catch (Exception e) {
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
            this.logError(e, META_CTRL_NM);
        }
        long finish = System.currentTimeMillis();
    }

    private void setSecondLevelComments() {
        long start = System.currentTimeMillis();
        this.colComments_ = new HashMap();
        String sql = "SELECT c.relname, att.attname, \nde.description  \nFROM pg_description as de \n\tJOIN pg_class as c on de.objoid = c.oid \n\tJOIN pg_attribute as att on de.objoid = att.attrelid \n\tAND de.objsubid = att.attnum \nWHERE de.objsubid > 0";
        try {
            String dotNote = "";
            Statement stmt = this.conn_.createStatement();
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                try {
                    String tblNm = rs.getString("relname");
                    String colNm = rs.getString("attname");
                    String cmm = rs.getString("description");
                    dotNote = tblNm + "." + colNm;
                    this.colComments_.put(dotNote, cmm);
                }
                catch (Exception e) {
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                    this.logError(e, META_CTRL_NM);
                }
            }
        }
        catch (Exception e) {
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
            LogUtil.printStackTrace(e);
        }
        long finish = System.currentTimeMillis();
    }

    @Override
    protected Map getFkComments() {
        return this.fkComments_;
    }

    private void setHasOidsMap() {
        this.hasOidsMap_ = new HashMap();
        String sql = "SELECT relname, relkind, relhasoids FROM pg_class \nWHERE relkind = 'r'\n\tAND relname NOT LIKE 'pgE_%' ESCAPE 'E'\n\tAND relname NOT LIKE 'sqlE_%' ESCAPE 'E'\n";
        try {
            Statement stmt = this.conn_.createStatement();
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                try {
                    String tableName = rs.getString("relname");
                    Boolean hasOids = new Boolean(rs.getBoolean("relhasoids"));
                    this.hasOidsMap_.put(tableName, hasOids);
                }
                catch (Exception e) {
                    this.logError(e, META_CTRL_NM);
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                }
            }
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
    }

    private void setInheritsMap() {
        this.inheritsMap_ = new HashMap();
        String sql = "SELECT ca.relname as \"child\", \ncb.relname as \"parent\", \nih.inhseqno \nFROM pg_inherits ih \n\tJOIN pg_class ca on ih.inhrelid = ca.oid \n\tJOIN pg_class cb on ih.inhparent= cb.oid \norder by ca.relname, ih.inhseqno";
        try {
            Statement stmt = this.conn_.createStatement();
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                try {
                    String child = rs.getString("child");
                    String parent = rs.getString("parent");
                    StringBuffer csv = new StringBuffer();
                    if (this.inheritsMap_.containsKey(child)) {
                        String current = (String)this.inheritsMap_.get(child);
                        csv.append(current.substring(0, current.length() - 1) + ",");
                    } else {
                        csv.append("INHERITS (");
                    }
                    csv.append(parent + ")");
                    this.inheritsMap_.put(child, csv.toString());
                }
                catch (Exception e) {
                    this.logError(e, META_CTRL_NM);
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                }
            }
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
    }

    private void setTableOptionsDisp(Database db) {
        for (Schema schema : db.values(Schema.getClassName())) {
            for (Table table : schema.values(Table.getClassName())) {
                this.setTableOptions(table);
            }
        }
    }

    private void setTableOptions(Table table) {
        String tableName = table.getName();
        StringBuffer sb = new StringBuffer();
        if (this.inheritsMap_.containsKey(tableName)) {
            String csv = (String)this.inheritsMap_.get(tableName);
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(csv);
        }
        if (this.hasOidsMap_.containsKey(tableName)) {
            String oidStr;
            boolean hasOids = (Boolean)this.hasOidsMap_.get(tableName);
            String string = oidStr = hasOids ? "WITH OIDS" : "WITHOUT OIDS";
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(oidStr);
        }
        if (sb.length() > 0) {
            String optStr = sb.toString();
            table.setTableOptions(optStr);
        }
    }

    private boolean supports(Version minVer) {
        if (this.dbmsVersion_ == null) {
            return true;
        }
        return this.dbmsVersion_.compareTo(minVer) >= 0;
    }

    public String getProcQuerySql72() {
        return "SELECT 'public' as \"SchNm\", \nformat_type(p.prorettype, NULL) as \"Result data type\", \np.proname as \"Name\", \np.oid as \"oid\", \n'{}'as \"ArgNms\", \noidvectortypes(p.proargtypes) as \"Argument data types\", \np.prosrc as \"Source code\", \np.proretset as \"RetSet\",\nobj_description(p.oid, 'pg_proc') as \"Description\", \nu.usename as \"Owner\", \nl.lanname as \"Language\", \np.provolatile as \"Volatile\", \np.proisstrict as \"Strict\" \nFROM pg_proc p \n\tLEFT JOIN pg_language l ON l.oid = p.prolang \n\tLEFT JOIN pg_user u ON u.usesysid = p.proowner \nWHERE p.proname != 'plpgsql_call_handler' \n\tAND p.oid > 20000";
    }

    private String getProcQuerySql73() {
        String sql = "SELECT n.nspname as \"SchNm\",\npg_catalog.format_type(p.prorettype, NULL) as \"Result data type\",\np.proname as \"Name\",\n'{}'as \"ArgNms\", \npg_catalog.oidvectortypes(p.proargtypes) as \"Argument data types\",\np.prosrc as \"Source code\",\np.proretset as \"RetSet\",\npg_catalog.obj_description(p.oid, 'pg_proc') as \"Description\",\nu.usename as \"Owner\",\nl.lanname as \"Language\", \np.provolatile as \"Volatile\", \np.proisstrict as \"Strict\" \nFROM pg_catalog.pg_proc p\n    LEFT JOIN pg_catalog.pg_namespace n ON n.oid = p.pronamespace\n    LEFT JOIN pg_catalog.pg_language l ON l.oid = p.prolang\n    LEFT JOIN pg_catalog.pg_user u ON u.usesysid = p.proowner\nWHERE " + this.getProcFilter();
        return sql;
    }

    private String getProcQuerySql() {
        String rowsCostSql = "";
        String allDataTypesSql = "p.proallargtypes as \"All data types\",\n";
        if (this.supports(VER_PROC_COST)) {
            rowsCostSql = "p.procost as \"Cost\",\np.prorows as \"Rows\",\n";
            allDataTypesSql = "pg_catalog.oidvectortypes((array_to_string(p.proallargtypes, ' ')::oidvector)) as \"All data types\",\n";
        }
        String sql = "SELECT n.nspname as \"SchNm\",\npg_catalog.format_type(p.prorettype, NULL) as \"Result data type\",\np.proname as \"Name\",\np.proargnames as \"ArgNms\", \npg_catalog.oidvectortypes(p.proargtypes) as \"Argument data types\",\n" + allDataTypesSql + "p.proargmodes as \"ArgModes\", \n" + "p.prosrc as \"Source code\",\n" + "p.probin as \"BinInvoke\",\n" + "p.proretset as \"RetSet\",\n" + "pg_catalog.obj_description(p.oid, 'pg_proc') as \"Description\",\n" + "u.usename as \"Owner\",\n" + "l.lanname as \"Language\",\n" + "p.provolatile as \"Volatile\", \n" + rowsCostSql + "p.proisstrict as \"Strict\" \n" + "FROM pg_catalog.pg_proc p\n" + "    LEFT JOIN pg_catalog.pg_namespace n ON n.oid = p.pronamespace\n" + "    LEFT JOIN pg_catalog.pg_language l ON l.oid = p.prolang\n" + "    LEFT JOIN pg_catalog.pg_user u ON u.usesysid = p.proowner\n" + "WHERE " + this.getProcFilter();
        return sql;
    }

    public String getSequenceQuerySql72() {
        return "SELECT 'public' as \"SchNm\", \n    c.relname as \"Name\", \n    u.usename as \"Owner\", \n   obj_description(c.oid, 'pg_class') as \"Description\" \nFROM pg_class c \n\tJOIN pg_user u on c.relowner = u.usesysid \nWHERE c.relkind = 'S'";
    }

    private String getSequenceQuerySql73() {
        return "SELECT n.nspname as \"SchNm\", \nc.relname as \"Name\", \npg_catalog.obj_description(c.oid, 'pg_class') as \"Description\"\nFROM pg_catalog.pg_class c\n\tJOIN pg_catalog.pg_namespace n ON n.oid = c.relnamespace\nWHERE " + this.getSchemaFilter("n") + "\n" + "\tAND c.relkind = 'S'\n" + "ORDER BY \"SchNm\", \"Name\"";
    }

    private String getIndexQuerySql72() {
        return "SELECT ci.relname as \"INDEX_NAME\", \n'public' as \"SchNm\", \nct.relname as \"TABLE_NAME\", \nct.oid as \"TblOid\", \nind.indkey as \"COL_IDS\", \nind.indisunique as \"UNIQUE\", \nind.indisclustered as \"CLUSTERED\" \nFROM pg_index ind \n\tJOIN pg_class ci ON ind.indexrelid = ci.oid \n\tJOIN pg_class ct ON ind.indrelid = ct.oid \nWHERE not ind.indisprimary \n\tAND ci.relname !~ '^pg_' \n\tAND ct.relname !~ '^pg_'\n";
    }

    private String getIndexQuerySql73() {
        return "SELECT ci.relname as \"INDEX_NAME\", \nnsp.nspname as \"SchNm\", \nct.relname as \"TABLE_NAME\", \nct.oid as \"TblOid\", \nind.indkey as \"COL_IDS\", \nind.indisunique as \"UNIQUE\", \nind.indisclustered as \"CLUSTERED\" \nFROM pg_catalog.pg_index ind \n\tJOIN pg_catalog.pg_class ci ON ind.indexrelid = ci.oid \n\tJOIN pg_catalog.pg_class ct ON ind.indrelid = ct.oid \n\tJOIN pg_namespace as nsp on ct.relnamespace = nsp.oid \nWHERE " + this.getSchemaFilter("nsp") + "\n" + "\tAND not ind.indisprimary \n" + "\tAND ci.relname !~ '^pg_' \n" + "\tAND ct.relname !~ '^pg_'\n";
    }

    private String getProcFilter() {
        String filterStr = this.getSchemaFilter("n") + "    AND pg_catalog.format_type(p.prorettype, NULL) != 'language_handler' \n" + "    AND p.proname NOT LIKE  'pg_%' \n" + "    AND p.proname NOT LIKE  'database_size%' \n" + "    AND p.proname NOT LIKE  'plpgsql_validator%' \n" + "    AND p.proname NOT LIKE  'relation_size%'";
        return filterStr;
    }

    private String getSchemaFilter(String nameSpaceAlias) {
        return this.getSchemaFilter(nameSpaceAlias, "nspname");
    }

    private String getSchemaFilter(String nameSpaceAlias, String schFieldNm) {
        String schFullAlias = nameSpaceAlias != null ? nameSpaceAlias + "." + schFieldNm + " " : schFieldNm + " ";
        String commonStr = "" + schFullAlias + NOT_LIKE_PG_STR + "\tAND " + schFullAlias + "!= 'information_schema'\n";
        String ignoreStr = this.ignoreCtrl.getIgnoreSchStr(schFullAlias);
        String fullStr = commonStr + ignoreStr;
        return fullStr;
    }

    private boolean parseAutoNumber(String defaultRaw) {
        if (defaultRaw == null) {
            return false;
        }
        String defaultLc = defaultRaw.toLowerCase();
        boolean isAutonumber = defaultLc.contains(NEXTVAL_EVALUTION_STR);
        return isAutonumber;
    }
}

