/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.metaData;

import com.harrand.coreclasses.element.Cardinality;
import com.harrand.coreclasses.element.StringPair;
import com.harrand.coreclasses.element.Version;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.dbwrench.jdbc.ConnectionFactory;
import com.harrand.dbwrench.jdbc.IDataType;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.metaData.IMetaDataCtrl;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.script.converter.IDataTypeConverter;
import com.harrand.dbwrench.security.App;
import com.harrand.util.LogUtil;
import com.harrand.util.Validator;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;

public final class OdbcAccessMetaDataCtrl
implements IMetaDataCtrl,
IObservable {
    private BasicObservable observable_ = new BasicObservable();
    private IDataTypeConverter dataTypeConverter_;
    private JdbcConfig config_;
    private String catalog_;
    private String mileStoneDesc_;
    private String statusDesc_;
    private Connection conn_;

    public OdbcAccessMetaDataCtrl(JdbcConfig config) {
        this.config_ = config;
        this.catalog_ = config.getDsn();
        this.dataTypeConverter_ = config.getDataTypeConverter();
        this.setStatusDesc("engineer.reverse.status.not.started.desc");
        this.setMilestoneDesc("engineer.reverse.milestone.none", "");
    }

    @Override
    public Database reverseEngineer() throws Exception {
        this.checkConfig();
        this.notifyObserversDisp("engineer.reverse.status.started", "engineer.reverse.milestone.none", this.catalog_);
        this.conn_ = ConnectionFactory.getConnection(this.config_);
        Database newDb = new Database(this.catalog_);
        this.notifyObserversDisp("engineer.reverse.status.started", "engineer.reverse.milestone.db.created", this.catalog_);
        this.addTables(newDb);
        this.addForeignKeys(newDb);
        ConnectionFactory.close(this.conn_);
        this.notifyObserversDisp("engineer.reverse.status.completed", "engineer.reverse.milestone.db.completed", this.catalog_);
        return newDb;
    }

    @Override
    public Database revEngForSync() throws Exception {
        return null;
    }

    private void addTables(Database db) {
        String sql = "SELECT name FROM MsysObjects WHERE type = 1 AND Flags = 0";
        Schema schema = db.getSchema("schemaA");
        try {
            ResultSet rs = ConnectionFactory.doSql(this.conn_, sql);
            while (rs.next()) {
                Table table = new Table(rs.getString("name"));
                table.setUseManualSort(true);
                this.addColumns(table);
                ITestResult result = schema.add(table);
                this.checkResult(result);
                if (!result.getPassed()) continue;
                this.notifyObserversDisp("engineer.reverse.status.started", "engineer.reverse.milestone.table.added", table.getName());
            }
            ConnectionFactory.close(rs);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
            this.notifyObserversDisp("engineer.reverse.status.started", "engineer.reverse.milestone.err", e.getMessage());
        }
    }

    private void addColumns(Table table) {
        String sql = "SELECT TOP 1 * FROM [" + table.getName() + "]";
        Schema sch = table.getSchema();
        Database db = sch.getDb();
        try {
            ResultSet rs = ConnectionFactory.doSql(this.conn_, sql);
            ResultSetMetaData rsmd = rs.getMetaData();
            int cols = rsmd.getColumnCount();
            for (int i = 1; i <= cols; ++i) {
                String name = rsmd.getColumnName(i);
                String dataTypeDesc = rsmd.getColumnTypeName(i);
                IDataType dataType = this.dataTypeConverter_.getDataType(db, sch, dataTypeDesc);
                Integer length = dataType.isLengthUsed() ? new Integer(rsmd.getPrecision(i)) : null;
                Integer scale = dataType.isScaleUsed() ? new Integer(rsmd.getScale(i)) : null;
                boolean isNullable = rsmd.isNullable(i) == 1;
                boolean isAutoNumber = dataType.getId() == 704;
                ITestResult result = table.add(new Column(name, dataType, length, isNullable, isAutoNumber, "", scale, "", true, ""));
                this.checkResult(result);
            }
            ConnectionFactory.close(rs);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
            this.notifyObserversDisp("engineer.reverse.status.started", "engineer.reverse.milestone.err", e.getMessage());
        }
    }

    private void addPrimaryKey(Table table) {
    }

    private void addForeignKeys(Database db) {
        String sql = "SELECT * FROM MSysRelationships ";
        String className = ForeignKey.getClassName();
        String prevFkName = "";
        ArrayList<StringPair> columns = new ArrayList<StringPair>();
        Cardinality childCardi = null;
        Cardinality parentCardi = null;
        String parentLinkColNm = null;
        int delActionId = 3;
        int updActionId = 3;
        Schema schema = db.getSchema("schemaA");
        try {
            ResultSet fkRs = ConnectionFactory.doSql(this.conn_, sql);
            while (fkRs.next()) {
                String fkName = fkRs.getString("szRelationship");
                String parentTableName = fkRs.getString("szReferencedObject");
                String childTableName = fkRs.getString("szObject");
                Table parTbl = schema.getTable(parentTableName);
                Table chdTbl = schema.getTable(childTableName);
                String parentColumnName = fkRs.getString("szReferencedColumn");
                String childColumnName = fkRs.getString("szColumn");
                if (!fkName.equalsIgnoreCase(prevFkName)) {
                    columns = new ArrayList();
                    parentLinkColNm = parentColumnName;
                    childCardi = ForeignKey.getDefaultCardinality(1);
                    parentCardi = ForeignKey.getDefaultCardinality(0);
                }
                String comment = "";
                columns.add(new StringPair(parentColumnName, childColumnName));
                ForeignKey fk = new ForeignKey(fkName, parTbl, chdTbl, columns, delActionId, updActionId, comment, childCardi, parentLinkColNm);
                ForeignKey fkOld = null;
                if (chdTbl.getKeys(ForeignKey.getClassName()).contains(fkName)) {
                    fkOld = chdTbl.getForeignKey(fkName);
                }
                ITestResult result = fkOld == null ? chdTbl.add(fk) : chdTbl.updateItem(fkOld, fk);
                if (!fkName.equalsIgnoreCase(prevFkName)) {
                    this.notifyObserversDisp("engineer.reverse.status.started", "engineer.reverse.milestone.fk.added", fk.getName());
                }
                prevFkName = fkName;
            }
            ConnectionFactory.close(fkRs);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
            this.notifyObserversDisp("engineer.reverse.status.started", "engineer.reverse.milestone.err", e.getMessage());
        }
    }

    private void checkConfig() throws Exception {
        if (!Validator.isStringValid(this.catalog_)) {
            throw new Exception("Error - A dsn(catalog) name must be specified in (odbc) JdbcConfig, before reverse engineering.");
        }
    }

    private final void notifyObserversDisp(String statusName, String mileStoneName, String mileStoneItem) {
        this.setStatusDesc(statusName);
        this.setMilestoneDesc(mileStoneName, mileStoneItem);
        this.notifyObservers(null);
    }

    private final void setMilestoneDesc(String mileStoneName, String itemName) {
        this.mileStoneDesc_ = App.getResource(mileStoneName) + itemName;
    }

    private final void setStatusDesc(String statusName) {
        this.statusDesc_ = App.getResource(statusName);
    }

    @Override
    public final String getMilestoneDesc() {
        return this.mileStoneDesc_;
    }

    @Override
    public final String getStatusDesc() {
        return this.statusDesc_;
    }

    @Override
    public final int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public final void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public final void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public final void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public final void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }

    @Override
    public Version getDbmsVersion() throws Exception {
        return null;
    }

    public void checkResult(ITestResult result) {
        if (!result.getPassed()) {
            this.notifyObserversDisp("engineer.reverse.status.started", "engineer.reverse.milestone.err", result.getDetail());
        }
    }

    @Override
    public boolean getWasError() {
        return false;
    }
}

