/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.metaData;

import com.harrand.coreclasses.element.Version;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.INamed;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.dbwrench.jdbc.ConnectionFactory;
import com.harrand.dbwrench.jdbc.DataTypeSvr;
import com.harrand.dbwrench.jdbc.IDataType;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.metaData.JdbcMetaDataCtrl;
import com.harrand.dbwrench.metaData.mysql.MySqlIndexRevEngCtrl;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Proc;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.View;
import com.harrand.dbwrench.script.compare.formatter.MySqlViewFormatter;
import com.harrand.dbwrench.script.converter.IDataTypeConverter;
import com.harrand.util.LogUtil;
import com.harrand.util.Validator;
import com.harrand.util.XmlHelper;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MySqlMetaDataCtrl
extends JdbcMetaDataCtrl {
    private final IDataTypeConverter dataTypeConverter_;
    protected Version dbmsVersion_ = null;
    protected String dbmsVersionStr_ = "";
    private static final String START_BRACKET = "(";
    private static final String END_BRACKET = ")";
    public static final String META_CTRL_NM = "MySqlMetaCtrl";

    public MySqlMetaDataCtrl(JdbcConfig config) {
        super(config);
        this.dataTypeConverter_ = config.getDataTypeConverter();
    }

    @Override
    public Database reverseEngineer() throws Exception {
        this.conn_ = ConnectionFactory.getConnection(this.getConfig());
        this.dbmsVersion_ = null;
        this.loadVersion();
        Database newDb = super.reverseEngineer();
        newDb.getNotifyMgr().setEnabled(false);
        this.dbmsVersion_ = this.getDbmsVersion();
        this.setTableComments(newDb);
        this.setTableOptionsByShowCreateTable(newDb);
        if (this.isProcRevEngEnabled()) {
            this.addProcs(newDb);
        }
        super.doPostRevEngTasks();
        ConnectionFactory.close(this.conn_);
        newDb.getNotifyMgr().setEnabled(true);
        return newDb;
    }

    @Override
    public Database revEngForSync() throws Exception {
        return this.reverseEngineer();
    }

    @Override
    protected void addColumns(Database db) {
        for (Schema schema : db.values(Schema.getClassName())) {
            for (Table tbl : schema.values(Table.getClassName())) {
                this.addColumns(tbl);
            }
        }
    }

    protected void addColumns(Table table) {
        Map commentsMap = this.getColumnComments(table);
        Schema sch = table.getSchema();
        Database db = sch.getDb();
        String name = "";
        INamed dataType = null;
        String dataTypeRaw = "";
        String sql = "describe " + table.getName();
        try {
            Statement stmt = this.conn_.createStatement();
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                try {
                    name = rs.getString("Field");
                    dataTypeRaw = rs.getString("Type");
                    String keyStr = rs.getString("Key");
                    int dataTypeId = this.parseDataTypeId(db, sch, dataTypeRaw);
                    dataType = DataTypeSvr.getDataType(dataTypeId);
                    if (!(dataType instanceof IDataType)) {
                        LogUtil.logMsg("MySqlMetaDataCtrl: col: " + name + ", raw: " + dataTypeRaw);
                    }
                    Integer length = null;
                    Integer scale = null;
                    if (dataType.isLengthUsed()) {
                        String lengthScaleStr = this.parseLengthScaleText(dataTypeRaw);
                        length = this.parseLength(lengthScaleStr);
                        if (dataType.isScaleUsed()) {
                            scale = this.parseScale(lengthScaleStr);
                        }
                    }
                    String defaultValue = this.parseDefault(rs.getString("Default"));
                    String nullStr = rs.getString("Null");
                    boolean isNullable = nullStr.equalsIgnoreCase("YES");
                    Object commentObj = commentsMap.get(name);
                    String comment = commentObj != null ? commentObj.toString() : "";
                    String enumValues = "";
                    if (dataType.getId() == 706 || dataType.getId() == 740) {
                        enumValues = this.parseEnumValues(dataTypeRaw);
                    }
                    boolean signed = this.getSigned(dataTypeRaw);
                    boolean unique = keyStr.equalsIgnoreCase("UNI");
                    String strAuto = rs.getString("Extra");
                    boolean autoNumber = strAuto.indexOf("auto_increment") > -1;
                    Column newColumn = new Column(name, dataTypeId, length, isNullable, autoNumber, defaultValue, scale, comment, signed, enumValues);
                    newColumn.setUnique(unique);
                    ITestResult result = table.add(newColumn);
                    this.checkResult(result);
                }
                catch (Exception e) {
                    LogUtil.logErr("MySqlMetaCtrl.getCols: " + table.getName() + "." + name + ", dt=" + dataType.getName() + ", dtRaw=" + dataTypeRaw + ", err: " + e.getMessage());
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                    this.logError(e, META_CTRL_NM);
                }
            }
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
    }

    @Override
    protected void addIndexes(Database db) {
        this.notifyObserversDisp("engineer.reverse.status.index");
        MySqlIndexRevEngCtrl mySqlIndexMetaDataCtrl = new MySqlIndexRevEngCtrl();
        ITestResult result = mySqlIndexMetaDataCtrl.addIndexes(this.conn_, db);
        if (!result.getPassed()) {
            this.notifyObserversDisp("engineer.reverse.milestone.err", result.getDetail());
        }
    }

    private Schema getDefaultSch(Database db) {
        return db.getSchema("schemaA");
    }

    @Override
    protected void addViews(DatabaseMetaData dbmd, Database db) {
        if (!this.getConfig().isMySql5()) {
            return;
        }
        this.notifyObserversDisp("engineer.reverse.status.views");
        String sql = "SELECT TABLE_NAME, VIEW_DEFINITION  \nFROM information_schema.views \nwhere TABLE_SCHEMA = '" + db.getName() + "'";
        MySqlViewFormatter formatter = new MySqlViewFormatter();
        Schema schema = this.getDefaultSch(db);
        try {
            ResultSet rs = ConnectionFactory.doSql(this.conn_, sql);
            while (rs.next()) {
                try {
                    String viewName = rs.getString("TABLE_NAME");
                    String sqlRaw = rs.getString("VIEW_DEFINITION");
                    String vwSql = formatter.getFormattedSql(sqlRaw);
                    vwSql = XmlHelper.stripNonValidXMLCharacters(vwSql, "View", viewName);
                    View view = new View(viewName, vwSql);
                    schema.add(view);
                    this.notifyObserversDisp("engineer.reverse.milestone.view.added", view.getName());
                }
                catch (Exception e) {
                    this.logError(e, META_CTRL_NM);
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                }
            }
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
    }

    public int parseDataTypeId(Database db, Schema sch, String dataTypeRaw) {
        String[] parts = dataTypeRaw.split("\\(");
        String dataTypeDesc = parts[0];
        if (dataTypeRaw.indexOf("binary") > 0) {
            dataTypeDesc = dataTypeDesc + " binary";
        }
        dataTypeDesc = dataTypeDesc.replaceFirst("unsigned", "").trim();
        int dataTypeId = this.dataTypeConverter_.getDataType(db, sch, dataTypeDesc).getId();
        return dataTypeId;
    }

    private void addProcs(Database db) {
        this.notifyObserversDisp("engineer.reverse.status.procs");
        String sql = "SELECT db, name, type \nFROM mysql.proc \nWHERE lower(db) = \"" + db.getName().toLowerCase() + "\"";
        Schema sch = this.getDefaultSch(db);
        try {
            Statement stmt = this.conn_.createStatement();
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                try {
                    String procNm = rs.getString("name");
                    String routineType = rs.getString("type");
                    String src = this.getProcSrc(procNm, routineType);
                    Proc proc = new Proc(src, "", "defaultRevEng");
                    sch.add(proc);
                }
                catch (Exception e) {
                    this.logError(e, META_CTRL_NM);
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                }
            }
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
    }

    private String getProcSrc(String procNm, String routineType) {
        String sql = "SHOW CREATE " + routineType + " " + procNm;
        String src = "(error getting routine code)";
        try {
            Statement stmt = this.conn_.createStatement();
            stmt.execute(sql);
            ResultSet rs = stmt.getResultSet();
            while (rs.next()) {
                try {
                    String headerNm = "Create " + routineType;
                    src = rs.getString(headerNm);
                }
                catch (Exception e) {
                    this.logError(e, META_CTRL_NM);
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                }
            }
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
        return src;
    }

    private String parseLengthScaleText(String dataTypeRaw) {
        String subString = "";
        if (dataTypeRaw.indexOf(START_BRACKET) > 0) {
            String[] parts = dataTypeRaw.split("\\(");
            subString = parts[1].split("\\)")[0];
        }
        return subString;
    }

    public Integer parseLength(String subString) {
        String lengthStr = subString.indexOf(",") > 0 ? subString.split(",")[0] : new String(subString);
        Integer length = null;
        try {
            length = new Integer(lengthStr);
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
        }
        return length;
    }

    public Integer parseScale(String subString) {
        Integer scale = null;
        try {
            String scaleStr = subString.split(",")[1];
            scale = new Integer(scaleStr);
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
        }
        return scale;
    }

    private String parseDefault(String defaultRaw) {
        String defaultStr = Validator.isStringValid(defaultRaw) ? (StrHelper.isNumeric(defaultRaw) ? defaultRaw : defaultRaw) : "";
        return defaultStr;
    }

    private String parseEnumValues(String dataTypeRaw) {
        String csv = "";
        String keyWord = "enum(";
        String lc = dataTypeRaw.toLowerCase();
        int startPos = lc.indexOf(keyWord) + keyWord.length();
        if (startPos > 0) {
            int endPos = lc.indexOf(END_BRACKET, startPos);
            csv = dataTypeRaw.substring(startPos, endPos);
        }
        return csv;
    }

    private boolean getSigned(String dataTypeRaw) {
        String lc = dataTypeRaw.toLowerCase();
        return !lc.contains("unsigned");
    }

    protected void checkAutoIncrementColumns(List tables) {
    }

    private void setTableComments(Database newDb) {
        Schema schema = newDb.getAllSchemas().get(0);
        String sql = "SELECT table_name, table_comment FROM INFORMATION_SCHEMA.TABLES where TABLE_TYPE='BASE TABLE' and table_schema = '" + newDb.getName() + "'";
        try {
            ResultSet rs = ConnectionFactory.doSql(this.conn_, sql);
            while (rs.next()) {
                try {
                    String tableName = rs.getString("TABLE_NAME");
                    String comment = rs.getString("TABLE_COMMENT");
                    Table table = schema.getTable(tableName);
                    if (table == null) continue;
                    table.setComment(comment);
                }
                catch (Exception e) {
                    this.logError(e, META_CTRL_NM);
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                }
            }
            ConnectionFactory.close(rs);
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
    }

    private void setTableOptionsByShowCreateTable(Database newDb) {
        for (Table table : newDb.getAllTablesGen()) {
            String sql = "show create table " + table.getName();
            try {
                ResultSet rs = ConnectionFactory.doSql(this.conn_, sql);
                if (rs.next()) {
                    try {
                        String createTableText = rs.getString("Create Table");
                        int tableOptionsStart = createTableText.indexOf("ENGINE=");
                        String tableOptionsText = createTableText.substring(tableOptionsStart);
                        table.setTableOptions(tableOptionsText);
                    }
                    catch (Exception e) {
                        this.logError(e, META_CTRL_NM);
                        this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                    }
                }
                ConnectionFactory.close(rs);
            }
            catch (Exception e) {
                this.logError(e, META_CTRL_NM);
                this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
            }
        }
    }

    private Map getColumnComments(Table table) {
        HashMap<String, String> commentMap = new HashMap<String, String>();
        String sql = "SHOW FULL COLUMNS FROM " + table.getName();
        try {
            ResultSet rs = ConnectionFactory.doSql(this.conn_, sql);
            if (this.hasCommentColumn(rs)) {
                while (rs.next()) {
                    try {
                        String name = rs.getString("Field");
                        String comment = rs.getString("Comment");
                        commentMap.put(name, comment);
                    }
                    catch (Exception e) {
                        this.logError(e, META_CTRL_NM);
                        this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                    }
                }
            }
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
        return commentMap;
    }

    private boolean hasCommentColumn(ResultSet rs) {
        if (this.getConfig().isMySql5()) {
            return true;
        }
        boolean hasComments = false;
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                String fieldName = rsmd.getColumnName(i);
                if (!fieldName.equalsIgnoreCase("Comment")) continue;
                hasComments = true;
            }
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
        return hasComments;
    }

    private void loadVersion() {
        this.dbmsVersion_ = new Version("5.0");
        this.getConfig().setVersion(this.dbmsVersion_);
        ArrayList<Integer> levels = new ArrayList<Integer>();
        String sql = "show variables like 'version'";
        boolean lettersFound = false;
        try {
            Connection cxn = ConnectionFactory.getConnection(this.getConfig());
            ResultSet rs = ConnectionFactory.doSql(cxn, sql);
            if (rs.next()) {
                String rawText = rs.getString("Value");
                String[] strs = rawText.split("\\.");
                for (int i = 0; i < strs.length && !lettersFound; ++i) {
                    String str = strs[i];
                    if (StrHelper.isInteger(str)) {
                        levels.add(new Integer(str));
                        continue;
                    }
                    StringBuffer sbLastStr = new StringBuffer();
                    for (int k = 0; k < str.length() && !lettersFound; ++k) {
                        String strDigit = str.substring(k, k + 1);
                        if (StrHelper.isInteger(strDigit)) {
                            sbLastStr.append(strDigit);
                            continue;
                        }
                        lettersFound = true;
                    }
                    if (sbLastStr.length() <= 0) continue;
                    levels.add(new Integer(sbLastStr.toString()));
                }
                if (!levels.isEmpty()) {
                    this.dbmsVersion_ = new Version(levels);
                    this.getConfig().setVersion(this.dbmsVersion_);
                }
                ConnectionFactory.close(cxn);
            }
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM);
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
    }

    private String getNullSafe(String str) {
        return StrHelper.getNullSafeString(str);
    }

    @Override
    public Version getDbmsVersion() throws Exception {
        if (this.dbmsVersion_ == null) {
            this.loadVersion();
        }
        return this.dbmsVersion_;
    }
}

