/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.metaData;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.element.Version;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.naming.INameBldrSvr;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.dbwrench.element.schema.SchemaIgnoreCtrl;
import com.harrand.dbwrench.jdbc.ConnectionFactory;
import com.harrand.dbwrench.jdbc.DataTypeSvr;
import com.harrand.dbwrench.jdbc.IDataType;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.metaData.DbwrItemBldr;
import com.harrand.dbwrench.metaData.IMetaDataCtrl;
import com.harrand.dbwrench.metaData.enabled.RevEngEnabledCtrl;
import com.harrand.dbwrench.naming.DbwNameBldrSvr;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Index;
import com.harrand.dbwrench.object.PrimaryKey;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.index.IIndexColumn;
import com.harrand.dbwrench.security.App;
import com.harrand.util.LogUtil;
import com.harrand.util.Validator;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JdbcMetaDataCtrl
implements IMetaDataCtrl,
IObservable {
    private final BasicObservable observable_ = new BasicObservable();
    private final RevEngEnabledCtrl revEngEnabledCtrl = new RevEngEnabledCtrl();
    private DatabaseMetaData dbmd_;
    private final JdbcConfig config_;
    private final int dbmsId_;
    protected Connection conn_;
    private final INameBldrSvr nameBldSvr_ = DbwNameBldrSvr.instance();
    protected DbwrItemBldr itemBldr_;
    protected List tableNms_ = new ArrayList();
    private final String catalog_;
    private String mileStoneDesc_;
    private String statusDesc_;
    private boolean wasError_;
    protected Version dbmsVersion_ = null;
    private List mysqlViewNms_ = null;
    private static final String META_CTRL_NM = "JdbcMetaCtrl";

    public JdbcMetaDataCtrl(JdbcConfig config) {
        this.config_ = config;
        this.catalog_ = this.getCatalogNmClean(config.getObjectInstanceName());
        this.dbmsId_ = this.config_.getDbmsId();
        this.setStatusDesc("engineer.reverse.status.not.started.desc");
        this.setMilestoneDesc("engineer.reverse.milestone.none", "");
        this.itemBldr_ = new DbwrItemBldr(this);
    }

    @Override
    public Database reverseEngineer() throws Exception {
        String className;
        this.doPreRevEngTasks();
        this.dbmd_ = this.getDatabaseMetaData();
        Database newDb = this.createNewDb();
        this.initMySqlViewNms();
        this.addSchemas(newDb);
        this.addTables(this.dbmd_, newDb);
        this.addColumns(newDb);
        this.addPks(newDb);
        if (this.isIndexRevEngEnabled()) {
            this.addIndexes(newDb);
        }
        if (this.isUC_RevEngEnabled()) {
            this.addUniqueConstraints(newDb);
        }
        this.checkAutoIncrementColumns(newDb);
        if (this.isViewRevEngEnabled()) {
            this.addViews(this.dbmd_, newDb);
        }
        if (this.isFkRevEngEnabled()) {
            this.addForeignKeys(this.dbmd_, newDb);
        }
        if ((className = this.getClass().getName()).indexOf("JdbcMetaDataCtrl") >= 0) {
            this.notifyObserversDisp("engineer.reverse.status.completed", "engineer.reverse.milestone.db.completed", this.catalog_);
        }
        newDb.getNotifyMgr().setEnabled(true);
        return newDb;
    }

    protected void doPreRevEngTasks() throws Exception {
        this.checkConfig();
        this.itemBldr_.reset();
        this.notifyObserversDisp("engineer.reverse.status.started", "engineer.reverse.milestone.started", this.catalog_);
    }

    protected void doPostRevEngTasks() throws Exception {
        this.noteIgnoredSchemas();
        this.notifyObserversDisp("engineer.reverse.status.completed", "engineer.reverse.milestone.db.completed", this.getCatalog());
    }

    protected Database createNewDb() throws Exception {
        Database newDb = new Database(this.catalog_);
        newDb.getNotifyMgr().setEnabled(false);
        this.notifyObserversDisp("engineer.reverse.status.started", "engineer.reverse.milestone.db.created", this.catalog_);
        this.dbmsVersion_ = this.getDbmsVersion();
        return newDb;
    }

    private void noteIgnoredSchemas() {
        SchemaIgnoreCtrl schemaIgnoreCtrl = this.getSchemaIgnoreCtrl();
        if (schemaIgnoreCtrl.hasIgnoreSchemas()) {
            String csvSchNms = " " + StrHelper.getCsvList(schemaIgnoreCtrl.getIgnoreNms());
            this.notifyObserversDisp("engineer.reverse.status.started", "engineer.reverse.milestone.schemas.ignored", csvSchNms);
        }
    }

    private SchemaIgnoreCtrl getSchemaIgnoreCtrl() {
        return this.config_.getSchemaIgnoreCtrl();
    }

    @Override
    public Database revEngForSync() throws Exception {
        return null;
    }

    public void notifyObserversDisp(String statusNm) {
        this.notifyObserversDisp(statusNm, null, null);
    }

    public void notifyObserversDisp(String mileStoneNm, String mileStoneItem) {
        this.notifyObserversDisp(null, mileStoneNm, mileStoneItem);
    }

    public void notifyObserversDisp(String statusNm, String mileStoneNm, String mileStoneItem) {
        boolean isDebugging = false;
        if (statusNm != null) {
            this.setStatusDesc(statusNm);
        }
        if (mileStoneNm == null) {
            this.setMilestoneDesc(null, null);
        } else {
            this.wasError_ = this.isError(mileStoneNm);
            if (this.wasError_ && isDebugging) {
                StrHelper.throwProgExcept("Meta Data Error: " + mileStoneItem);
            }
            this.setMilestoneDesc(mileStoneNm, mileStoneItem);
        }
        this.notifyObservers(null);
    }

    private boolean isError(String mileStoneName) {
        return mileStoneName.equals("engineer.reverse.milestone.err");
    }

    protected void logError(Exception e, String metaCtrlNm) {
        this.logError(e.getMessage(), metaCtrlNm, "");
    }

    protected void logError(Exception e, String metaCtrlNm, String objDesc) {
        this.logError(e.getMessage(), metaCtrlNm, objDesc);
    }

    protected void logError(String msg, String metaCtrlNm) {
        this.logError(msg, metaCtrlNm, "");
    }

    protected void logError(String msg, String metaCtrlNm, String objDesc) {
        StrHelper.throwProgExcept("");
        LogUtil.logErr(metaCtrlNm + " - Reverse Engineer Error - " + objDesc + ": " + msg);
    }

    private void setMilestoneDesc(String mileStoneName, String itemName) {
        this.mileStoneDesc_ = mileStoneName == null ? null : App.getResource(mileStoneName) + itemName;
    }

    private void setStatusDesc(String statusName) {
        this.statusDesc_ = App.getResource(statusName);
    }

    private String getCatalogNmClean(String dbNmStr) {
        String cleanStr = dbNmStr;
        if (dbNmStr.indexOf("?") > 0) {
            cleanStr = dbNmStr.split("\\?")[0];
        }
        return cleanStr;
    }

    @Override
    public final String getMilestoneDesc() {
        return this.mileStoneDesc_;
    }

    @Override
    public final String getStatusDesc() {
        return this.statusDesc_;
    }

    protected final JdbcConfig getConfig() {
        return this.config_;
    }

    protected final String getCatalog() {
        return this.catalog_;
    }

    protected final DatabaseMetaData getDbmd() {
        return this.dbmd_;
    }

    @Override
    public boolean getWasError() {
        return this.wasError_;
    }

    protected void checkConfig() throws Exception {
        if (this.config_.isOdbcDriver()) {
            throw new Exception("Error - Attempting to use JdbcMetaData or a subclass of it, \nwith an Odbc driver.");
        }
        if (!Validator.isStringValid(this.catalog_)) {
            throw new Exception("Error - A database(catalog) name must be specified in JdbcConfig, before reverse engineering.");
        }
    }

    protected DatabaseMetaData getDatabaseMetaData() {
        DatabaseMetaData dbmd = null;
        try {
            dbmd = this.conn_.getMetaData();
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM, "Database Meta");
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
        return dbmd;
    }

    protected void addSchemas(Database newDb) {
    }

    public void removeDefaultSchema(Database newDb) {
        String schemaClz = Schema.getClassName();
        if (newDb.contains(schemaClz, "schemaA")) {
            newDb.remove(schemaClz, "schemaA");
        }
    }

    protected void addTables(DatabaseMetaData dbmd, Database db) {
        this.notifyObserversDisp("engineer.reverse.status.tables");
        long start = System.currentTimeMillis();
        String[] tableTypes = new String[]{"TABLE"};
        this.tableNms_ = new ArrayList();
        boolean i = false;
        try {
            ResultSet tableRs = dbmd.getTables(this.catalog_, null, null, tableTypes);
            while (tableRs.next()) {
                try {
                    String tableNm = tableRs.getString("TABLE_NAME");
                    String schNm = tableRs.getString("TABLE_SCHEM");
                    if (!this.isUserTable(tableNm)) continue;
                    Table table = new Table(tableNm);
                    String remark = tableRs.getString("REMARKS");
                    if (remark != null) {
                        table.setComment(remark);
                    }
                    table.setUseManualSort(true);
                    if (schNm == null) {
                        schNm = "schemaA";
                    }
                    this.tableNms_.add(schNm + "." + tableNm);
                    Schema schema = db.getSchema(schNm);
                    schema.add(table);
                    this.notifyObserversDisp("engineer.reverse.milestone.table.added", tableNm);
                }
                catch (Exception e) {
                    this.logError(e, META_CTRL_NM, "Tables");
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                }
            }
            ConnectionFactory.close(tableRs);
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM, "Tables");
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
        long finish = System.currentTimeMillis();
    }

    protected void addViews(DatabaseMetaData dbmd, Database db) {
    }

    protected final boolean isUserTable(String tableName) {
        if (tableName.indexOf("sql_") == 0 || tableName.equalsIgnoreCase("sysdiagrams") || tableName.equalsIgnoreCase("dtproperties") || tableName.indexOf("MSys") >= 0) {
            return false;
        }
        return !this.mysqlViewNms_.contains(tableName);
    }

    private void initMySqlViewNms() {
        int majorVersionNum;
        this.mysqlViewNms_ = new ArrayList();
        if (this.config_.getDbms().isMySql() && this.dbmsVersion_ != null && (majorVersionNum = this.dbmsVersion_.getLevel1().intValue()) >= 5) {
            String sql = "select TABLE_NAME from INFORMATION_SCHEMA.VIEWS WHERE table_schema = '" + this.catalog_ + "'";
            try {
                Statement stmt = this.conn_.createStatement();
                stmt.execute(sql);
                ResultSet rs = stmt.getResultSet();
                while (rs.next()) {
                    try {
                        String name = rs.getString("TABLE_NAME");
                        this.mysqlViewNms_.add(name);
                    }
                    catch (Exception e) {
                        this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                    }
                }
                ConnectionFactory.close(rs);
            }
            catch (Exception e) {
                this.logError(e, META_CTRL_NM, "ViewNms");
                this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
            }
        }
    }

    protected void addColumns(Database db) {
    }

    protected void addColumns(DatabaseMetaData dbmd, Table table) {
        try {
            ResultSet columnSet = dbmd.getColumns(this.catalog_, null, table.getName(), null);
            while (columnSet.next()) {
                try {
                    boolean isNullable;
                    String name = columnSet.getString("COLUMN_NAME");
                    int dataTypeId = columnSet.getInt("DATA_TYPE");
                    String dataTypeDesc = columnSet.getString("TYPE_NAME");
                    IDataType dataType = DataTypeSvr.getDataType(dataTypeId);
                    Integer length = dataType.isLengthUsed() ? new Integer(columnSet.getString("COLUMN_SIZE")) : null;
                    Integer scale = dataType.isScaleUsed() ? new Integer(columnSet.getString("DECIMAL_DIGITS")) : null;
                    String defaultValue = columnSet.getString("COLUMN_DEF");
                    String nullableStr = columnSet.getString("IS_NULLABLE");
                    boolean bl = isNullable = nullableStr.equalsIgnoreCase("yes");
                    if (defaultValue == null) {
                        defaultValue = "";
                    }
                    String remark = columnSet.getString("REMARKS");
                    String comment = "";
                    if (remark != null) {
                        comment = remark;
                    }
                    table.add(new Column(name, dataTypeId, length, isNullable, false, defaultValue, scale, comment));
                }
                catch (Exception e) {
                    this.logError(e, META_CTRL_NM, "Columns A");
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                }
            }
            ConnectionFactory.close(columnSet);
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM, "Columns B");
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
    }

    public Map getColumnComments(DatabaseMetaData dbmd, Table table) {
        HashMap<String, String> commentMap = new HashMap<String, String>();
        try {
            ResultSet columnSet = dbmd.getColumns(this.catalog_, null, table.getName(), null);
            while (columnSet.next()) {
                try {
                    String name = columnSet.getString("COLUMN_NAME");
                    String comment = columnSet.getString("REMARKS");
                    if (!Validator.isStringValid(comment)) continue;
                    commentMap.put(name, comment);
                }
                catch (Exception e) {
                    this.logError(e, META_CTRL_NM, "Column Comments A");
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                }
            }
            ConnectionFactory.close(columnSet);
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM, "Column Comments B");
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
        return commentMap;
    }

    public Map getProcComments(DatabaseMetaData dbmd) {
        HashMap<String, String> commentMap = new HashMap<String, String>();
        try {
            ResultSet rs = dbmd.getProcedures(this.catalog_, null, null);
            while (rs.next()) {
                try {
                    String name = rs.getString("PROCEDURE_NAME");
                    String comment = rs.getString("REMARKS");
                    String schema = rs.getString("PROCEDURE_SCHEM");
                    if (schema.equals("pg_catalog") || !Validator.isStringValid(comment)) continue;
                    commentMap.put(name, comment);
                }
                catch (Exception e) {
                    this.logError(e, META_CTRL_NM, "Proc Comments A");
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                }
            }
            ConnectionFactory.close(rs);
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM, "Proc Commnets B");
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
        return commentMap;
    }

    protected Map getFkComments(Table table) {
        return null;
    }

    protected void checkAutoIncrementColumns(Database db) {
        long start = System.currentTimeMillis();
        try {
            if (this.config_.isMySql() || this.config_.isMsAccess()) {
                for (Schema schema : db.values(Schema.getClassName())) {
                    Iterator itTbl = schema.values(Table.getClassName()).iterator();
                    while (itTbl.hasNext()) {
                        try {
                            Table table = (Table)itTbl.next();
                            String sql = this.getConfig().getDbms().getLimitOneSql(table.getName());
                            ResultSet rs = ConnectionFactory.doSql(this.conn_, sql);
                            ResultSetMetaData rsmd = rs.getMetaData();
                            int colCount = rsmd.getColumnCount();
                            for (int i = 1; i <= colCount; ++i) {
                                if (!rsmd.isAutoIncrement(i)) continue;
                                this.updateColumnAsAutoIncrement(table, rsmd.getColumnName(i));
                            }
                            ConnectionFactory.close(rs);
                        }
                        catch (Exception e) {
                            this.logError(e, META_CTRL_NM, "AutoIncrment Columns A");
                            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM, "AutoIncrement Columns B");
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
        long finish = System.currentTimeMillis();
    }

    private String getLimitOneGroupedSql(List tables) {
        StringBuffer sb = new StringBuffer();
        for (Table table : tables) {
            String sql = this.getConfig().getDbms().getLimitOneSql(table.getName());
            sb.append(sql + ";\n");
        }
        return sb.toString();
    }

    protected final void updateColumnAsAutoIncrement(Table table, String columnName) {
        String mapName = Column.getClassName();
        Column old = (Column)table.get(mapName, columnName);
        try {
            Column newColumn = new Column(columnName, old.getDataTypeId(), old.getLength(), old.getIsNullable(), true, old.getDefault(), old.getScale(), old.getComment(), old.getSignedFlag(), old.getEnumCsv());
            ITestResult iTestResult = table.updateItem(old, newColumn);
        }
        catch (Exception e) {
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
    }

    protected void addPks(Database db) {
        ArrayList<String[]> strArrays = new ArrayList<String[]>();
        for (String dotNote : this.tableNms_) {
            Schema schema = db.getSchemaFromDotNote(dotNote);
            Table tbl = db.getTableFromDotNote(dotNote);
            try {
                ResultSet rs = this.dbmd_.getPrimaryKeys(this.catalog_, null, tbl.getName());
                while (rs.next()) {
                    try {
                        String[] strArray = new String[]{schema.getName(), rs.getString("TABLE_NAME"), rs.getString("COLUMN_NAME"), rs.getString("KEY_SEQ"), rs.getString("PK_NAME")};
                        strArrays.add(strArray);
                    }
                    catch (Exception e) {
                        this.logError(e, META_CTRL_NM, "PKs A");
                        this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                    }
                }
            }
            catch (Exception e) {
                this.logError(e, META_CTRL_NM, "PKs B");
                this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
            }
        }
        this.itemBldr_.addPks(db, strArrays);
    }

    protected void addUniqueConstraints(Database db) {
    }

    protected void addIndexes(Database db) {
        this.notifyObserversDisp("engineer.reverse.status.index");
        ArrayList<Object[]> objArrays = new ArrayList<Object[]>();
        for (String tblNmDotNote : this.tableNms_) {
            Schema schema = db.getSchemaFromDotNote(tblNmDotNote);
            Table table = db.getTableFromDotNote(tblNmDotNote);
            try {
                ResultSet rs = this.dbmd_.getIndexInfo(this.catalog_, null, table.getName(), false, true);
                while (rs.next()) {
                    try {
                        String idxNm = rs.getString("INDEX_NAME");
                        LogUtil.logMsg(this, table.getName() + "." + idxNm + "--------------");
                        LogUtil.logMsg(this, "type: " + rs.getShort("TYPE "));
                        Object[] objArray = new Object[]{schema.getName(), rs.getString("TABLE_NAME"), idxNm, rs.getString("COLUMN_NAME"), new Boolean(!rs.getBoolean("NON_UNIQUE")), new Integer(rs.getShort("TYPE"))};
                        objArrays.add(objArray);
                    }
                    catch (Exception e) {
                        this.logError(e, META_CTRL_NM, "Indexes A");
                        this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                    }
                }
            }
            catch (Exception e) {
                this.logError(e, META_CTRL_NM, "Indexes B");
                this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
            }
        }
        this.itemBldr_.addIndexes(db, objArrays);
    }

    protected void addIndexes(DatabaseMetaData dbmd, Table table) {
        this.notifyObserversDisp("engineer.reverse.status.index");
        String prevIndexName = "";
        String className = Index.getClassName();
        PrimaryKey pk = table.getPrimaryKey();
        String pkName = pk != null ? pk.getName() : "";
        long start = System.currentTimeMillis();
        try {
            ResultSet indexRs = dbmd.getIndexInfo(this.catalog_, null, table.getName(), false, true);
            while (indexRs.next()) {
                try {
                    boolean clustered;
                    String indexName = indexRs.getString("INDEX_NAME");
                    if (indexName.equals(pkName)) continue;
                    String indexTableName = indexRs.getString("TABLE_NAME");
                    boolean bl = clustered = indexRs.getShort("TYPE") == 1;
                    boolean unique = this.dbmsId_ != 0 ? !indexRs.getBoolean("NON_UNIQUE") : indexRs.getBoolean("NON_UNIQUE");
                    String columnName = indexRs.getString("COLUMN_NAME");
                    if (!indexName.equalsIgnoreCase("PRIMARY") && indexTableName.equalsIgnoreCase(table.getName())) {
                        Index oldIndex = null;
                        ArrayList<IIndexColumn> columnNames = new ArrayList<String>();
                        if (table.getKeys(className).contains(indexName)) {
                            oldIndex = table.getIndex(indexName);
                            columnNames = oldIndex.getColumns();
                        }
                        columnNames.add((IIndexColumn)((Object)columnName));
                        Index index = new Index(indexName, columnNames, clustered, unique);
                        ITestResult result = new DataEntryResult(true);
                        if (oldIndex == null) {
                            result = table.add(index);
                        } else {
                            table.updateItem(oldIndex, index);
                        }
                        this.checkResult(result);
                        if (result.getPassed() && !indexName.equalsIgnoreCase(prevIndexName)) {
                            this.notifyObserversDisp("engineer.reverse.milestone.index.added", indexName);
                        }
                    }
                    prevIndexName = indexName;
                }
                catch (Exception e) {
                    this.logError(e, META_CTRL_NM, "Add Indexes (old) A");
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                }
            }
            ConnectionFactory.close(indexRs);
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM, "Add Indexes (Old) B");
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
        long finish = System.currentTimeMillis();
    }

    protected void addForeignKeys(DatabaseMetaData dbmd, Database db) {
        for (Schema schema : db.values(Schema.getClassName())) {
            for (Table table : schema.values(Table.getClassName())) {
                this.addForeignKeysForTable(dbmd, db, table);
            }
        }
    }

    private final void addForeignKeysForTable(DatabaseMetaData dbmd, Database db, Table childTable) {
        this.notifyObserversDisp("engineer.reverse.status.fks");
        String childTableName = childTable.getName();
        HashMap<String, Integer> fkDelActionMap = new HashMap<String, Integer>();
        HashMap<String, Integer> fkUpdActionMap = new HashMap<String, Integer>();
        Map fkComments = this.getFkComments(childTable);
        this.itemBldr_.setFkCommentMap(fkComments);
        long start = System.currentTimeMillis();
        try {
            ArrayList<String[]> strArrays = new ArrayList<String[]>();
            ResultSet rs = dbmd.getImportedKeys(this.catalog_, null, childTableName);
            while (rs.next()) {
                try {
                    String chdSchNm;
                    String fkNm = rs.getString("FK_NAME");
                    String parSchNm = rs.getString("PKTABLE_SCHEM");
                    if (parSchNm == null) {
                        parSchNm = "schemaA";
                    }
                    if ((chdSchNm = rs.getString("FKTABLE_SCHEM")) == null) {
                        chdSchNm = "schemaA";
                    }
                    String[] strArray = new String[]{fkNm, parSchNm, chdSchNm, rs.getString("PKTABLE_NAME"), childTableName, rs.getString("PKCOLUMN_NAME"), rs.getString("FKCOLUMN_NAME")};
                    strArrays.add(strArray);
                    short delActionDbmd = rs.getShort("DELETE_RULE");
                    Integer delActionId = this.getActionId(delActionDbmd);
                    short updActionDbmd = rs.getShort("UPDATE_RULE");
                    Integer updActionId = this.getActionId(updActionDbmd);
                    fkDelActionMap.put(fkNm, delActionId);
                    fkUpdActionMap.put(fkNm, updActionId);
                }
                catch (Exception e) {
                    this.logError(e, META_CTRL_NM, "FKs For Table A");
                    this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
                }
            }
            ConnectionFactory.close(rs);
            Map commentsMap = this.getFkComments();
            this.itemBldr_.setFkCommentMap(commentsMap);
            this.itemBldr_.setFkDelActionMap(fkDelActionMap);
            this.itemBldr_.setFkUpdActionMap(fkUpdActionMap);
            this.itemBldr_.addFks(db, strArrays);
        }
        catch (Exception e) {
            this.logError(e, META_CTRL_NM, "FKs For Table B");
            this.notifyObserversDisp("engineer.reverse.milestone.err", e.getMessage());
        }
        long finish = System.currentTimeMillis();
    }

    private Integer getActionId(int dbmdId) {
        int id = 3;
        if (dbmdId == 3) {
            id = 3;
        } else if (dbmdId == 0) {
            id = 0;
        } else if (dbmdId == 1) {
            id = 1;
        } else if (dbmdId == 2) {
            id = 2;
        } else if (dbmdId == 4) {
            id = 4;
        }
        Integer idObj = new Integer(id);
        return idObj;
    }

    protected String getCustomTypeSchemaNotFoundMsg(String customTypeNm, String schNm) {
        return "Custom data type: " + customTypeNm + " requires schema: " + schNm + " which was not found.";
    }

    protected Map getFkComments() {
        return new HashMap();
    }

    @Override
    public final int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public final void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public final void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public final void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public final void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }

    @Override
    public Version getDbmsVersion() throws Exception {
        return null;
    }

    public void checkResult(ITestResult result) {
        if (!result.getPassed()) {
            this.notifyObserversDisp("engineer.reverse.milestone.none", result.getDetail());
        }
    }

    protected boolean isFkRevEngEnabled() {
        return this.revEngEnabledCtrl.isFkRevEngEnabled();
    }

    protected boolean isIndexRevEngEnabled() {
        return this.revEngEnabledCtrl.isIndexRevEngEnabled();
    }

    protected boolean isProcRevEngEnabled() {
        return this.revEngEnabledCtrl.isProcRevEngEnabled();
    }

    protected boolean isSeqRevEngEnabled() {
        return this.revEngEnabledCtrl.isSeqRevEngEnabled();
    }

    protected boolean isTriggerRevEngEnabled() {
        return this.revEngEnabledCtrl.isTriggerRevEngEnabled();
    }

    protected boolean isUC_RevEngEnabled() {
        return this.revEngEnabledCtrl.isUC_RevEngEnabled();
    }

    protected boolean isViewRevEngEnabled() {
        return this.revEngEnabledCtrl.isViewRevEngEnabled();
    }

    protected boolean isSchemaRevEngEnabled() {
        return this.revEngEnabledCtrl.isSchemaRevEngEnabled();
    }
}

