/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.metaData;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.element.Cardinality;
import com.harrand.coreclasses.element.StringPair;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.naming.INameBldrSvr;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.metaData.JdbcMetaDataCtrl;
import com.harrand.dbwrench.metaData.bldr.UniqueConstraintAdder;
import com.harrand.dbwrench.naming.DbwNameBldrSvr;
import com.harrand.dbwrench.naming.PkNameBldr;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Index;
import com.harrand.dbwrench.object.PrimaryKey;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.index.IIndexColumn;
import com.harrand.util.LogUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DbwrItemBldr {
    private JdbcMetaDataCtrl jdbcMetaDataCtrl_;
    private INameBldrSvr nameBldSvr_ = DbwNameBldrSvr.instance();
    private Map fkDelActionMap_ = null;
    private Map fkUpdActionMap_ = null;
    private Map fkCommentMap_ = null;
    private PkNameBldr pkNameBldr_ = (PkNameBldr)this.nameBldSvr_.getNameBldr("PkNameBldr");
    private JdbcConfig config_;
    public static final String PK_ERR_NM = "pkNameError";
    public static final int IDX_SCH_NM_POS = 0;
    public static final int IDX_TBL_NM_POS = 1;
    public static final int IDX_NM_POS = 2;
    public static final int IDX_COL_NM_POS = 3;
    public static final int IDX_UNQ_POS = 4;
    public static final int IDX_TYPE_POS = 5;
    public static final int PK_SCH_NM_POS = 0;
    public static final int PK_TBL_NM_POS = 1;
    public static final int PK_COL_NM_POS = 2;
    public static final int PK_KEY_SEQ_POS = 3;
    public static final int PK_NM_POS = 4;
    public static final int FK_NM_POS = 0;
    public static final int FK_PAR_SCH_NM_POS = 1;
    public static final int FK_CHD_SCH_NM_POS = 2;
    public static final int FK_PAR_TBL_NM_POS = 3;
    public static final int FK_CHD_TBL_NM_POS = 4;
    public static final int FK_PAR_COL_NM_POS = 5;
    public static final int FK_CHD_COL_NM_POS = 6;
    public final String MILESTONE_NONE = "engineer.reverse.milestone.none";
    public final String MILESTONE_ERR = "engineer.reverse.milestone.err";
    public final String MILESTONE_INDEX_ADDED = "engineer.reverse.milestone.index.added";
    public final String MILESTONE_FK_ADDED = "engineer.reverse.milestone.fk.added";
    public final String MILESTONE_TRIGGER_ADDED = "engineer.reverse.milestone.trigger.added";
    public final String MILESTONE_VIEW_ADDED = "engineer.reverse.milestone.view.added";
    public final String MILESTONE_PROC_ADDED = "engineer.reverse.milestone.proc.added";
    public final String MILESTONE_SEQ_ADDED = "engineer.reverse.milestone.seq.added";
    public final String STATUS_STARTED = "engineer.reverse.status.started";

    public DbwrItemBldr(JdbcMetaDataCtrl jdbcMetaDataCtrl) {
        this.jdbcMetaDataCtrl_ = jdbcMetaDataCtrl;
        this.config_ = this.jdbcMetaDataCtrl_.getConfig();
    }

    public void reset() {
        this.fkDelActionMap_ = new HashMap();
        this.fkUpdActionMap_ = new HashMap();
        this.fkCommentMap_ = new HashMap();
    }

    public void addPks(Database db, List strArrays) {
        String prevTblNm = "";
        ArrayList<Object> colNms = new ArrayList();
        TreeMap<Short, String> colSortMap = new TreeMap<Short, String>();
        String schNm = null;
        String tblNm = null;
        for (String[] strArray : strArrays) {
            try {
                schNm = strArray[0];
                tblNm = strArray[1];
                String colNm = strArray[2];
                String keySeq = strArray[3];
                String pkNm = strArray[4];
                if (!tblNm.equals(prevTblNm)) {
                    colSortMap = new TreeMap();
                }
                colSortMap.put(new Short(keySeq), colNm);
                colNms = new ArrayList(colSortMap.values());
                Schema schema = db.getSchema(schNm);
                Table table = schema.getTable(tblNm);
                if (pkNm.equalsIgnoreCase("primary")) {
                    pkNm = this.pkNameBldr_.getFormedName(tblNm, colNms);
                }
                if (!colNms.isEmpty()) {
                    try {
                        table.setPrimaryKey(new PrimaryKey(pkNm, colNms));
                    }
                    catch (Exception e) {
                        LogUtil.logErr("DbwrItemBldr.pkBuildErr: " + e.getMessage());
                    }
                }
                prevTblNm = tblNm;
            }
            catch (Exception e) {
                String msg = "Error adding PK for table: " + this.getNullSafe(schNm) + "." + this.getNullSafe(tblNm) + ", err: " + e.getMessage();
                this.jdbcMetaDataCtrl_.notifyObserversDisp("engineer.reverse.milestone.err", msg);
            }
        }
    }

    public void addUniqueConstraints(Database db, List strArrays) {
        UniqueConstraintAdder adder = new UniqueConstraintAdder();
        adder.setJdbcMetaDataCtrl(this.jdbcMetaDataCtrl_);
        adder.addUniqueConstraints(db, strArrays);
    }

    public void addIndexes(Database db, List objArrays) {
        String className = Index.getClassName();
        String prevIdxNm = "";
        ArrayList<IIndexColumn> cols = new ArrayList<Column>();
        Schema schema = null;
        Table table = null;
        for (Object[] objArray : objArrays) {
            String schNm = (String)objArray[0];
            String tblNm = (String)objArray[1];
            String idxNm = (String)objArray[2];
            String colNm = (String)objArray[3];
            boolean unique = (Boolean)objArray[4];
            int idxTypeId = (Integer)objArray[5];
            try {
                String pkNm;
                schema = db.getSchema(schNm);
                table = schema.getTable(tblNm);
                PrimaryKey pk = table.getPrimaryKey();
                String string = pkNm = pk != null ? pk.getName() : "";
                if (idxNm != null && !idxNm.equals(pkNm)) {
                    boolean clustered;
                    boolean bl = clustered = idxTypeId == 1;
                    if (!idxNm.equalsIgnoreCase("PRIMARY")) {
                        Index oldIndex = null;
                        cols = new ArrayList();
                        if (table.getKeys(className).contains(idxNm)) {
                            oldIndex = table.getIndex(idxNm);
                            cols = oldIndex.getIndexColumns();
                        }
                        try {
                            Column column = table.getColumn(colNm);
                            cols.add(column);
                            Index index = new Index(idxNm, cols, clustered, unique);
                            ITestResult result = new DataEntryResult(true);
                            result = oldIndex == null ? table.add(index) : table.updateItem(oldIndex, index);
                            this.checkResult(result);
                            if (result.getPassed() && !idxNm.equalsIgnoreCase(prevIdxNm)) {
                                this.jdbcMetaDataCtrl_.notifyObserversDisp("engineer.reverse.milestone.index.added", tblNm + "." + idxNm);
                            }
                        }
                        catch (Exception e) {
                            this.logIndexErr(schNm, tblNm, idxNm, e);
                        }
                    }
                }
                prevIdxNm = idxNm;
            }
            catch (Exception e) {
                this.logIndexErr(schNm, tblNm, idxNm, e);
            }
        }
    }

    private void logIndexErr(String schNm, String tblNm, String idxNm, Exception e) {
        String msg = "Error adding index from table: " + this.getNullSafe(schNm) + "." + this.getNullSafe(tblNm) + ", idxNm: " + this.getNullSafe(idxNm) + ", err: " + e.getMessage();
        this.jdbcMetaDataCtrl_.notifyObserversDisp("engineer.reverse.milestone.err", msg);
    }

    public void setFkDelActionMap(Map fkDelActionMap) {
        this.fkDelActionMap_ = fkDelActionMap;
    }

    public void setFkUpdActionMap(Map fkUpdActionMap) {
        this.fkUpdActionMap_ = fkUpdActionMap;
    }

    public void setFkCommentMap(Map fkCommentMap) {
        this.fkCommentMap_ = fkCommentMap;
    }

    private String getNullSafe(String str) {
        return StrHelper.getNullSafeString(str);
    }

    public Map getFkCommentsMap() {
        return this.fkCommentMap_;
    }

    public Map getFkDelActionMap() {
        return this.fkDelActionMap_;
    }

    public Map getFkUpdActionMap() {
        return this.fkUpdActionMap_;
    }

    public void addFks(Database db, List strArrays) {
        String prevFkName = "";
        String prevChdTblNm = "";
        ArrayList<StringPair> columns = new ArrayList<StringPair>();
        Cardinality parentCardi = null;
        Cardinality childCardi = null;
        String parentLinkColNm = null;
        Table chdTbl = null;
        String fkNm = null;
        String chdTblNm = null;
        String chdSchNm = null;
        boolean iTest = false;
        long start = System.currentTimeMillis();
        for (String[] strArray : strArrays) {
            try {
                StringPair colPair;
                String cmmDotNote;
                fkNm = strArray[0];
                String parSchNm = strArray[1];
                chdSchNm = strArray[2];
                String parTblNm = strArray[3];
                chdTblNm = strArray[4];
                Schema parSchema = db.getSchema(parSchNm);
                Schema chdSchema = db.getSchema(chdSchNm);
                Table parTbl = parSchema.getTable(parTblNm);
                chdTbl = chdSchema.getTable(chdTblNm);
                String parentColumnName = strArray[5];
                String childColumnName = strArray[6];
                String dotNote = chdTbl.getDotNote() + "." + fkNm;
                boolean isSameFk = this.isSameFk(prevChdTblNm, prevFkName, chdTblNm, fkNm);
                int delActionId = 3;
                Object delActionObj = this.fkDelActionMap_.get(fkNm);
                if (delActionObj != null) {
                    delActionId = (Integer)delActionObj;
                }
                int updActionId = 3;
                Object updActionObj = this.fkUpdActionMap_.get(fkNm);
                if (updActionObj != null) {
                    updActionId = (Integer)updActionObj;
                }
                if (!isSameFk) {
                    columns = new ArrayList();
                    parentLinkColNm = parentColumnName;
                    childCardi = new Cardinality(true, true, true);
                    Column colChild = chdTbl.getColumn(childColumnName);
                    parentCardi = colChild.getIsNullable() ? new Cardinality(true, true, false) : new Cardinality(false, true, false);
                }
                String comment = "";
                String string = cmmDotNote = this.config_.isSqlSvr() ? chdSchNm + "." + fkNm : dotNote;
                if (this.fkCommentMap_ != null && this.fkCommentMap_.containsKey(cmmDotNote)) {
                    comment = (String)this.fkCommentMap_.get(cmmDotNote);
                }
                if (!columns.contains(colPair = new StringPair(parentColumnName, childColumnName))) {
                    columns.add(colPair);
                }
                ForeignKey fk = new ForeignKey(fkNm, parTbl, chdTbl, columns, delActionId, updActionId, comment, childCardi, parentLinkColNm);
                ForeignKey fkOld = null;
                if (chdTbl.getKeys(ForeignKey.getClassName()).contains(fkNm)) {
                    fkOld = chdTbl.getForeignKey(fkNm);
                }
                ITestResult result = fkOld == null ? chdTbl.add(fk) : chdTbl.updateItem(fkOld, fk);
                if (!isSameFk) {
                    this.jdbcMetaDataCtrl_.notifyObserversDisp("engineer.reverse.milestone.fk.added", fkNm);
                }
                prevFkName = fkNm;
                prevChdTblNm = chdTblNm;
            }
            catch (Exception e) {
                String msg = "Error adding FK for table: " + this.getNullSafe(chdSchNm) + "." + this.getNullSafe(chdTblNm) + ", fkNm: " + this.getNullSafe(fkNm) + ", err: " + e.getMessage();
                this.jdbcMetaDataCtrl_.notifyObserversDisp("engineer.reverse.milestone.err", msg);
            }
        }
    }

    public void checkResult(ITestResult result) {
        if (!result.getPassed()) {
            this.jdbcMetaDataCtrl_.notifyObserversDisp("engineer.reverse.milestone.none", result.getDetail());
        }
    }

    private boolean isSameFk(String prevChdTblNm, String prevFkNm, String currentChdTblNm, String currentFkNm) {
        boolean caseSens = this.config_.supportsMixedCase();
        boolean isSame = StrHelper.isSame(prevChdTblNm, currentChdTblNm, caseSens) && StrHelper.isSame(prevFkNm, currentFkNm, caseSens);
        return isSame;
    }
}

