/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.jdbc.validators;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.dataEntry.validate.IInputTextValidator;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.dbwrench.jdbc.IDataType;
import com.harrand.dbwrench.security.App;
import com.harrand.util.Validator;

public class DataTypeScaleValidator
implements IInputTextValidator {
    private IDataType dataType;

    public void setDataType(IDataType dataType) {
        this.dataType = dataType;
    }

    @Override
    public ITestResult isInputValid(String inStr) {
        return this.isScaleValid(inStr, this.dataType);
    }

    public ITestResult isScaleValid(String scaleStr, IDataType dataType) {
        if (Validator.isStringValid(scaleStr)) {
            if (StrHelper.isInteger(scaleStr)) {
                return this.isScaleValidInt(new Integer(scaleStr), dataType);
            }
            return new DataEntryResult(false, DataTypeScaleValidator.getMsgInvalidScale());
        }
        return this.isScaleValidInt(null, dataType);
    }

    public ITestResult isScaleValidInt(Integer scaleInt, IDataType dataType) {
        DataEntryResult passRslt = new DataEntryResult();
        if (!dataType.isStandardType()) {
            return passRslt;
        }
        if (dataType.isScaleUsed()) {
            if (scaleInt != null) {
                if (scaleInt < 0) {
                    return new DataEntryResult(false, DataTypeScaleValidator.getMsgInvalidScale());
                }
            } else {
                return this.checkScaleRequired(dataType);
            }
        }
        return passRslt;
    }

    private ITestResult checkScaleRequired(IDataType dataType) throws IllegalArgumentException {
        if (dataType.isScaleRequired()) {
            return new DataEntryResult(false, App.getRes("err.column.length.null.msg"));
        }
        return new DataEntryResult();
    }

    private static String getMsgInvalidScale() {
        return App.getRes("err.column.scale.invalid.msg");
    }
}

