/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.jdbc.validators;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.dataEntry.validate.IInputTextValidator;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.dbwrench.jdbc.IDataType;
import com.harrand.dbwrench.security.App;
import com.harrand.util.Validator;

public class DataTypeLengthValidator
implements IInputTextValidator {
    private IDataType dataType;

    public void setDataType(IDataType dataType) {
        this.dataType = dataType;
    }

    @Override
    public ITestResult isInputValid(String inStr) {
        return this.isLengthValid(inStr, this.dataType);
    }

    public ITestResult isLengthValid(String lengthStr, IDataType inDataType) {
        this.setDataType(inDataType);
        if (Validator.isStringValid(lengthStr)) {
            if (StrHelper.isInteger(lengthStr)) {
                return this.isLengthValidInt(new Integer(lengthStr), this.dataType);
            }
            return new DataEntryResult(false, DataTypeLengthValidator.getMsgInvalidLength());
        }
        return this.isLengthValidInt(null, this.dataType);
    }

    public ITestResult isLengthValidInt(Integer theLength, IDataType inDataType) {
        this.setDataType(inDataType);
        DataEntryResult passRslt = new DataEntryResult();
        if (!this.dataType.isStandardType()) {
            return passRslt;
        }
        if (this.dataType.isLengthUsed()) {
            if (theLength != null) {
                if (theLength < 0) {
                    return new DataEntryResult(false, DataTypeLengthValidator.getMsgInvalidLength());
                }
            } else {
                return this.checkLengthRequired();
            }
        }
        return passRslt;
    }

    private ITestResult checkLengthRequired() {
        if (this.dataType.isLengthRequired()) {
            return new DataEntryResult(false, App.getRes("err.column.length.null.msg"));
        }
        return new DataEntryResult();
    }

    public static String getMsgInvalidLength() {
        return App.getRes("err.column.length.invalid.msg");
    }
}

