/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.jdbc;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.IIconable;
import com.harrand.coreclasses.interfaces.INamed;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coreclasses.text.escape.IStrEscapeCtrl;
import com.harrand.coreclasses.xml.abstractions.IXmlable;
import com.harrand.coregui.Icons;
import com.harrand.dbwrench.db.IDbValue;
import com.harrand.dbwrench.jdbc.IDataType;
import com.harrand.dbwrench.jdbc.IDbmsFunctionality;
import com.harrand.dbwrench.jdbc.reserved.IReservedWords;
import com.harrand.dbwrench.jdbc.reserved.ReservedWordsFactory;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.script.converter.MsAccessDataTypeConverter;
import com.harrand.dbwrench.script.converter.MsSqlServerDataTypeConverter;
import com.harrand.dbwrench.script.converter.MySqlDataTypeConverter;
import com.harrand.dbwrench.script.converter.PostgreSqlDataTypeConverter;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.dbwrench.text.escape.ctrl.MySqlStrEscapeCtrl;
import com.harrand.dbwrench.text.escape.ctrl.OracleStrEscapeCtrl;
import com.harrand.dbwrench.text.escape.ctrl.PsqlStrEscapeCtrl;
import com.harrand.dbwrench.text.escape.ctrl.SqlSvrStrEscapeCtrl;
import com.harrand.dbwrenchgui.db.dataEdit.WidgetOverrideCtrl;
import com.harrand.util.XmlHelper;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class Dbms
implements IDbmsFunctionality,
Identifiable,
IIconable,
IXmlable {
    private String name_;
    private int id_;
    private String iconName_;
    private DbUser user_ = null;
    private IOptionMgr psqlOptMgr_;
    private IStrEscapeCtrl strEscapeCtrl;
    private WidgetOverrideCtrl widgetOverrideCtrl = new WidgetOverrideCtrl();
    private static Map dbmsMap__ = null;
    public static final String HD_NAME = "Name";
    public static final String HD_ICON_PATH = "IconPath";
    public static final String MYSQL = "MySql";
    public static final String POSTGRESQL = "PostgreSql";
    public static final String MS_ACCESS = "MS Access";
    public static final String MS_SQL_SERVER = "MS SQL Server";
    public static final String ORACLE = "Oracle";
    public static final String MYSQL_DRV_NM = "com.mysql.jdbc.Driver";
    public static final String ORACLE_DRV_NM = "oracle.jdbc.OracleDriver";
    public static final String PSQL_DRV_NM = "org.postgresql.Driver";
    public static final String SQL_SVR_DRV_NM = "net.sourceforge.jtds.jdbc.Driver";
    public static final int MYSQL_ID = 0;
    public static final int POSTGRESQL_ID = 1;
    public static final int MS_ACCESS_ID = 2;
    public static final int MS_SQL_SERVER_ID = 3;
    public static final int ORACLE_ID = 4;
    public List psqlNonReservedWords_;

    private Dbms(String name) {
        this.name_ = name;
        this.id_ = Dbms.getIdForName(this.name_);
        this.loadIconPath();
        this.init();
        this.psqlNonReservedWords_ = new ArrayList();
        this.psqlNonReservedWords_.add("comment");
        this.psqlNonReservedWords_.add("statement");
        this.psqlNonReservedWords_.add("assignment");
        this.psqlNonReservedWords_.add("cursor");
        this.psqlNonReservedWords_.add("increment");
        this.psqlNonReservedWords_.add("index");
        this.psqlNonReservedWords_.add("insert");
        this.psqlNonReservedWords_.add("login");
        this.psqlNonReservedWords_.add("lock");
        this.psqlNonReservedWords_.add("match");
        this.psqlNonReservedWords_.add("maxvalue");
        this.psqlNonReservedWords_.add("privileges");
        this.psqlNonReservedWords_.add("precision");
        this.psqlNonReservedWords_.add("procedure");
        this.psqlNonReservedWords_.add("references");
        this.psqlNonReservedWords_.add("restrict");
        this.psqlNonReservedWords_.add("returns");
        this.psqlNonReservedWords_.add("schema");
        this.psqlNonReservedWords_.add("sequence");
        this.psqlNonReservedWords_.add("sequence");
        this.psqlNonReservedWords_.add("text");
        this.psqlNonReservedWords_.add("type");
        this.psqlNonReservedWords_.add("view");
        this.psqlNonReservedWords_.add("year");
    }

    private String escapeStr(String name) {
        return this.strEscapeCtrl.escapeStr(name);
    }

    private void init() {
        switch (this.id_) {
            case 0: {
                this.strEscapeCtrl = new MySqlStrEscapeCtrl();
                break;
            }
            case 1: {
                this.strEscapeCtrl = new PsqlStrEscapeCtrl();
                break;
            }
            case 2: {
                this.strEscapeCtrl = new SqlSvrStrEscapeCtrl();
                break;
            }
            case 3: {
                this.strEscapeCtrl = new SqlSvrStrEscapeCtrl();
                break;
            }
            case 4: {
                this.strEscapeCtrl = new OracleStrEscapeCtrl();
                break;
            }
            default: {
                StrHelper.throwProgExcept("Could not match Dbms id");
            }
        }
    }

    public static final Dbms getDbms(String dbmsName) {
        Dbms.ensureDbmsMapInit();
        Dbms dbms = (Dbms)dbmsMap__.get(dbmsName);
        if (dbms == null) {
            StrHelper.throwProgExcept("Could not match dbmsName: " + dbmsName);
        }
        return dbms;
    }

    public static List getDbmsList() {
        Dbms.ensureDbmsMapInit();
        return new ArrayList(dbmsMap__.values());
    }

    public static int getIdForName(String name) {
        int value = -1;
        if (name.equals(MYSQL)) {
            value = 0;
        } else if (name.equals(POSTGRESQL)) {
            value = 1;
        } else if (name.equals(MS_ACCESS)) {
            value = 2;
        } else if (name.equals(MS_SQL_SERVER)) {
            value = 3;
        } else if (name.equals(ORACLE)) {
            value = 4;
        }
        return value;
    }

    public static String getNameForId(int id) {
        String name = null;
        switch (id) {
            case 0: {
                name = MYSQL;
                break;
            }
            case 1: {
                name = POSTGRESQL;
                break;
            }
            case 2: {
                name = MS_ACCESS;
                break;
            }
            case 3: {
                name = MS_SQL_SERVER;
                break;
            }
            case 4: {
                name = ORACLE;
                break;
            }
            default: {
                StrHelper.throwProgExcept("Could not match Dbms id");
            }
        }
        return name;
    }

    public IStrEscapeCtrl getStrEscapeCtrl() {
        return this.strEscapeCtrl;
    }

    public String escapeSpecialChars(String raw) {
        String escaped = this.isPsql() ? raw.replace("'", "\\'") : (this.isSqlSvr() ? raw.replace("'", "''") : (this.isMySql() ? raw.replace("'", "\\'") : raw));
        return escaped;
    }

    boolean supportsCustomTypes() {
        return this.isSqlSvr() || this.isPsql();
    }

    private void loadIconPath() {
        this.iconName_ = "ConnEc16.gif";
    }

    public static Dbms fromXml(Element element) {
        String lname = XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(element, HD_NAME));
        return new Dbms(lname);
    }

    @Override
    public Element asXmlElement() {
        Document doc = XmlHelper.getNewDocument();
        Element element = doc.createElement(this.getMapName());
        XmlHelper.addElementSimple(doc, element, HD_NAME, this.name_);
        return element;
    }

    public int getId() {
        return this.id_;
    }

    @Override
    public String getMapName() {
        return Dbms.clazz();
    }

    @Override
    public void setName(String newName) {
    }

    public static String clazz() {
        return "Dbms";
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public String getDisplayClzNm() {
        return this.getMapName();
    }

    @Override
    public String getDisplayClzPlural() {
        return this.getDisplayClzNm() + "s";
    }

    @Override
    public URL getIconUrl() {
        URL url = Icons.getUrl(this.iconName_);
        return url;
    }

    public String toString() {
        return this.getName();
    }

    public static String[] getStringArray() {
        int count = 5;
        String[] array = new String[count];
        array[0] = MS_ACCESS;
        array[1] = MS_SQL_SERVER;
        array[2] = MYSQL;
        array[3] = POSTGRESQL;
        array[4] = ORACLE;
        return array;
    }

    public boolean isSqlSvr() {
        return this.id_ == 3;
    }

    public boolean isPsql() {
        return this.id_ == 1;
    }

    public boolean isMySql() {
        return this.id_ == 0;
    }

    public boolean isOracle() {
        return this.id_ == 4;
    }

    public boolean isMsAccess() {
        return this.id_ == 2;
    }

    public String getDefaultDriverName() {
        String driver = "";
        driver = this.id_ == 0 ? MYSQL_DRV_NM : (this.id_ == 3 ? SQL_SVR_DRV_NM : (this.id_ == 2 ? "sun.jdbc.odbc.JdbcOdbcDriver" : (this.id_ == 1 ? PSQL_DRV_NM : (this.id_ == 4 ? ORACLE_DRV_NM : "error - No default driver available."))));
        return driver;
    }

    public String getTableListSql() {
        String sql = "";
        sql = this.id_ == 0 ? "show tables" : (this.id_ == 2 ? "SELECT name FROM MsysObjects WHERE Type=1 AND Flags=0" : (this.id_ == 3 ? "SELECT name FROM SysObjects WHERE Type=/'U/'" : (this.id_ == 1 ? "SELECT tablename FROM pg_tables WHERE schemaname = /'public/'" : "error - No default getTableList SQL available for this Dbms")));
        return sql;
    }

    public String getUseDatabaseSql(String dbName) {
        String sql = "";
        switch (this.id_) {
            case 1: {
                sql = "USE DATABASE " + dbName;
                break;
            }
            case 0: {
                sql = "USE " + dbName;
                break;
            }
            case 2: {
                sql = "";
                break;
            }
            case 3: {
                sql = "USE " + dbName;
            }
        }
        return sql;
    }

    public String getProcWord() {
        String str = "PROCEDURE";
        switch (this.id_) {
            case 1: {
                str = "FUNCTION";
            }
        }
        return str;
    }

    @Override
    public boolean supportsMixedCase() {
        if (this.id_ == 1) {
            return this.getDblEnquoteOn();
        }
        return !this.isOracle();
    }

    @Override
    public boolean supportsMixedCasePkName() {
        return this.supportsMixedCase() && this.id_ != 0;
    }

    @Override
    public boolean supportsMixedCaseTableName() {
        return this.supportsMixedCase() && this.id_ != 0;
    }

    @Override
    public boolean supportsClusteredIndex() {
        return this.id_ == 3;
    }

    @Override
    public boolean supportsUseDatabase() {
        return this.id_ != 1 && this.id_ != 2;
    }

    @Override
    public boolean supportsSchemas() {
        return this.isPsql() || this.isSqlSvr() || this.isOracle();
    }

    @Override
    public boolean supportsSequences() {
        return this.isPsql() || this.isOracle();
    }

    @Override
    public String getAutoNumberSql(Column column, int seed, int increment) {
        switch (this.id_) {
            case 1: {
                return "";
            }
            case 0: {
                return "AUTO_INCREMENT PRIMARY KEY";
            }
            case 2: {
                return "COUNTER";
            }
            case 3: {
                if (column.getDataType().getId() == 704) {
                    return "ROWGUIDCOL";
                }
                return "IDENTITY (" + seed + ", " + increment + ")";
            }
            case 4: {
                return "";
            }
        }
        return "";
    }

    public String getFormattedValue(IDbValue dbValue) {
        String formatted = StrHelper.NULL_STR;
        Object valueObj = dbValue.getValueObject();
        if (valueObj != null) {
            String raw = valueObj.toString();
            Column column = dbValue.getColumn();
            IDataType dataType = column.getDataType();
            boolean usedDefaultTextWidget = this.widgetOverrideCtrl.useDefaultTextWidget(column);
            formatted = raw;
            if (StrHelper.isHexStr(raw)) {
                formatted = raw;
            } else if (dataType.isStringLikeType() || usedDefaultTextWidget || dataType.getId() == 706 || dataType.getId() == 740 || dataType.getId() == 765 || dataType.getId() == 773 || dataType.getId() == 772 || dataType.getId() == 726 || dataType.getId() == 725 || dataType.getId() == 799 || dataType.getId() == 728 || dataType.isBlobLikeType() || dataType.isInternetType() || dataType.isGeometricType()) {
                String escaped = this.escapeSpecialChars(raw);
                formatted = "'" + escaped + "'";
            } else if (valueObj instanceof Date) {
                formatted = this.getFormattedDate(dataType, (Date)valueObj);
            } else if (dataType.isBooleanLikeType() && (this.getId() == 0 || this.getId() == 3)) {
                formatted = raw.equals("true") ? "1" : "0";
            } else if (dataType.getId() == -7 && this.getId() == 1) {
                formatted = raw.equals("true") ? "B'1'" : "B'0'";
            } else if (dataType.isBooleanLikeType() && this.getId() == 1) {
                formatted = raw.equals("true") ? "TRUE" : "FALSE";
            } else if (dataType.getId() == 704 && this.isSqlSvr()) {
                formatted = "'" + raw + "'";
            }
        }
        return formatted;
    }

    private String getFormattedDate(IDataType dataType, Date date) {
        SimpleDateFormat formatter;
        int dataTypeId = dataType.getId();
        switch (dataTypeId) {
            case 91: {
                formatter = new SimpleDateFormat("yyyy-MM-dd");
                break;
            }
            case 700: {
                formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                break;
            }
            case 93: {
                formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                break;
            }
            case 92: {
                formatter = new SimpleDateFormat("HH:mm:ss");
                break;
            }
            default: {
                formatter = new SimpleDateFormat("yyyy-MM-dd");
            }
        }
        String str = "'" + formatter.format((Object)date) + "'";
        return str;
    }

    public String getFormattedCsv(List names) {
        ArrayList<String> newNames = new ArrayList<String>();
        for (String name : names) {
            newNames.add(this.getFormattedName(name));
        }
        return StrHelper.getCsvList(newNames);
    }

    public String getFormattedName(INamed named) {
        return this.getFormattedName(named.getName());
    }

    public String getFormattedName(String name) {
        String formattedName = name;
        String nameUc = name.toUpperCase();
        boolean doEscape = false;
        IReservedWords reservedWordSource = ReservedWordsFactory.getReservedWordsSource(this);
        List<String> reservedWords = reservedWordSource.getReservedWords();
        if (this.getId() == 0) {
            reservedWords.addAll(Arrays.asList(MySqlDataTypeConverter.RESERVED_WORDS));
            if (reservedWords.contains(nameUc)) {
                doEscape = true;
            }
        }
        if (this.getId() == 2) {
            reservedWords.addAll(Arrays.asList(MsAccessDataTypeConverter.RESERVED_WORDS));
            if (reservedWords.contains(nameUc)) {
                doEscape = true;
            }
        }
        if (this.getId() == 3) {
            reservedWords.addAll(Arrays.asList(MsSqlServerDataTypeConverter.RESERVED_WORDS));
            if (reservedWords.contains(nameUc)) {
                doEscape = true;
            }
            if (nameUc.contains("-")) {
                doEscape = true;
            }
            if (nameUc.contains(" ")) {
                doEscape = true;
            }
        }
        if (this.getId() == 1) {
            this.checkPsqlOptMgrLoaded();
            boolean doDblQuotes = this.checkDblQuotePsqlNm(name);
            if (this.psqlNonReservedWords_.contains(nameUc) && !doDblQuotes) {
                return formattedName;
            }
            reservedWords.addAll(Arrays.asList(PostgreSqlDataTypeConverter.RESERVED_WORDS));
            if (reservedWords.contains(nameUc) || doDblQuotes) {
                doEscape = true;
            }
        }
        if (this.isOracle() && reservedWords.contains(nameUc)) {
            doEscape = true;
        }
        if (doEscape) {
            formattedName = this.escapeStr(name);
        }
        return formattedName;
    }

    public boolean checkDblQuotePsqlNm(String nm) {
        if (nm.indexOf("-") >= 0) {
            return true;
        }
        boolean optionOn = this.getDblEnquoteOn();
        return optionOn && StrHelper.containsUpperCase(nm);
    }

    public boolean getDblEnquoteOn() {
        boolean optionOn;
        this.checkPsqlOptMgrLoaded();
        boolean isOn = false;
        if (this.isPsql() && (optionOn = this.psqlOptMgr_.getBoolValue("psql.enclose.quotes"))) {
            isOn = true;
        }
        return isOn;
    }

    private String doubleQuote(String str) {
        return StrHelper.encloseDblQuotes(str);
    }

    private void checkPsqlOptMgrLoaded() {
        if (this.psqlOptMgr_ == null) {
            if (this.user_ == null) {
                this.user_ = App.getUser();
            }
            this.psqlOptMgr_ = this.user_.getOptionMgr("psql.opt.mgr");
        }
    }

    public String getNowStr() {
        String str = "NOW()";
        if (this.getId() == 3) {
            str = "GETDATE()";
        } else if (this.isOracle()) {
            str = "SYSDATE";
        }
        return str;
    }

    @Override
    public boolean supportsForeignKey() {
        return true;
    }

    @Override
    public boolean supportsStoredProcedure() {
        return this.isSqlSvr() || this.isPsql() || this.isMySql() || this.isOracle();
    }

    public boolean supportsUniqueConstraint() {
        return this.isSqlSvr() || this.isPsql();
    }

    @Override
    public boolean supportsTransaction() {
        return !this.isMsAccess();
    }

    @Override
    public boolean supportsTrigger() {
        return this.isSqlSvr() || this.isPsql() || this.isOracle();
    }

    @Override
    public boolean supportsView() {
        return this.isSqlSvr() || this.isPsql() || this.isOracle();
    }

    public String getReplaceStr() {
        String str = "CREATE OR REPLACE";
        if (this.isSqlSvr()) {
            str = "ALTER";
        }
        return str;
    }

    @Override
    public String getLimitOneSql(String tableName) {
        String formattedName = this.getFormattedName(tableName);
        if (this.id_ == 3 || this.id_ == 2) {
            return "SELECT TOP 1 * FROM " + formattedName;
        }
        return "SELECT * FROM " + formattedName + " LIMIT 1";
    }

    public String getRenameTableSql(String oldForEngNm, String newName) {
        String formattedName = oldForEngNm;
        String sql = this.id_ == 3 ? StrHelper.EXEC_STR + " sp_rename '" + formattedName + "', '" + newName + "'" : "ALTER TABLE " + formattedName + " RENAME TO " + newName;
        return sql;
    }

    @Override
    public int getDbmsId() {
        return this.getId();
    }

    private static void ensureDbmsMapInit() {
        if (dbmsMap__ == null) {
            Dbms.initDbmsMap();
        }
    }

    private static void initDbmsMap() {
        dbmsMap__ = new TreeMap();
        dbmsMap__.put(MS_ACCESS, new Dbms(MS_ACCESS));
        dbmsMap__.put(MS_SQL_SERVER, new Dbms(MS_SQL_SERVER));
        dbmsMap__.put(MYSQL, new Dbms(MYSQL));
        dbmsMap__.put(POSTGRESQL, new Dbms(POSTGRESQL));
        dbmsMap__.put(ORACLE, new Dbms(ORACLE));
    }
}

