/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.jdbc;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.dbwrench.jdbc.BasicTypesSvr;
import com.harrand.dbwrench.jdbc.CustomTypeIdCtrl;
import com.harrand.dbwrench.jdbc.DataType;
import com.harrand.dbwrench.jdbc.IDataType;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.CustomType;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.util.LogUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DataTypeSvr {
    private IOptionMgr optMgr_;
    private static Database db__;

    public DataTypeSvr(IOptionMgr dtOptMgr) {
        this.optMgr_ = dtOptMgr;
    }

    public static void setDb(Database db) {
        db__ = db;
    }

    public List getEnabledTypes() {
        ArrayList<IDataType> types = new ArrayList<IDataType>();
        types.addAll(this.getBasicEnabledTypes());
        types.addAll(DataTypeSvr.getCustomTypes());
        Collections.sort(types);
        return types;
    }

    public static IDataType getDataType(int id) {
        Database db = DataTypeSvr.getDefaultDb();
        for (IDataType type : DataTypeSvr.getAllTypes(db)) {
            int typeId = type.getId();
            if (id != typeId) continue;
            return type;
        }
        LogUtil.logErr("DataTypeSvr.Data Type not found for id: " + id);
        return null;
    }

    public static IDataType getDataType(String dtNm) {
        return DataTypeSvr.getDataTypeByNm(DataTypeSvr.getDefaultDb(), dtNm);
    }

    private static Database getDefaultDb() {
        if (db__ != null) {
            return db__;
        }
        return LookupUtil.getLookupDb();
    }

    private static IDataType getDataTypeByNm(Database db, String dtNm) {
        IDataType dataType = null;
        for (IDataType type : DataTypeSvr.getAllTypes(db)) {
            String typeNm = type.getName();
            if (!dtNm.equalsIgnoreCase(typeNm)) continue;
            dataType = type;
        }
        return dataType;
    }

    public static IDataType getDataType(Database localDb, Schema schCurrent, String nm) {
        IDataType dataType = DataTypeSvr.getDataTypeByNm(localDb, nm);
        if (dataType == null) {
            CustomType newType = CustomTypeIdCtrl.instance().createCustomType(localDb, nm, "");
            dataType = newType;
            schCurrent.add(newType);
        }
        return dataType;
    }

    public static boolean contains(Database localDb, String nm) {
        for (IDataType type : DataTypeSvr.getAllTypes(localDb)) {
            String typeNm = type.getName();
            if (!nm.equalsIgnoreCase(typeNm)) continue;
            return true;
        }
        return false;
    }

    public static void checkAddType(Database localDb, CustomType type) {
        String typeNm = type.getName();
        if (!DataTypeSvr.contains(localDb, typeNm)) {
            String schNm = type.getSchema().getName();
            if (localDb.contains(Schema.getClassName(), schNm)) {
                Schema schLocal = localDb.getSchema(schNm);
                schLocal.add(type);
            } else {
                LogUtil.logErr("DataTypeSvr could not add Custom Type '" + typeNm + "' because schema '" + schNm + "' doesn not " + "exist in db '" + localDb.getName() + "'");
            }
        }
    }

    public static List<CustomType> getCustomTypes() {
        return DataTypeSvr.getCustomTypes(DataTypeSvr.getDefaultDb());
    }

    public static List<CustomType> getCustomTypes(Database db) {
        ArrayList<CustomType> customTypes = new ArrayList<CustomType>();
        if (db == null) {
            return customTypes;
        }
        for (Schema sch : db.getAllSchemas()) {
            customTypes.addAll(sch.values(CustomType.getClassName()));
        }
        return customTypes;
    }

    private List<IDataType> getBasicEnabledTypes() {
        ArrayList<IDataType> enabledTypes = new ArrayList<IDataType>();
        for (DataType dataType : BasicTypesSvr.instance().getList()) {
            this.addDataTypeIfEnabled(enabledTypes, dataType);
        }
        return enabledTypes;
    }

    private static List<IDataType> getAllTypes(Database db) {
        ArrayList<IDataType> allTypes = new ArrayList<IDataType>();
        allTypes.addAll(BasicTypesSvr.instance().getList());
        allTypes.addAll(DataTypeSvr.getCustomTypes(db));
        return allTypes;
    }

    private void addDataTypeIfEnabled(List enabledTypes, DataType dataType) {
        String idStr = Integer.toString(dataType.getId());
        boolean enabled = this.optMgr_.getBoolValue(idStr);
        if (enabled) {
            enabledTypes.add(dataType);
        }
    }

    public ITestResult autoEnableDbType(Database db) {
        StringBuffer msgSb = new StringBuffer("Auto-enabled ");
        int enabledCount = 0;
        for (DataType dt : BasicTypesSvr.instance().getList()) {
            ITestResult result;
            String idStr = Integer.toString(dt.getId());
            if (this.optMgr_.getBoolValue(idStr) || !(result = DataTypeSvr.getIsDataTypeUsed(db, dt, false)).getPassed()) continue;
            this.optMgr_.setBoolValue(idStr, true);
            msgSb.append("\n" + result.getDetail());
            ++enabledCount;
        }
        DataEntryResult result = enabledCount > 0 ? new DataEntryResult(true, "Auto-Enabled Data Types", msgSb.toString()) : new DataEntryResult(false, "Did Not Auto-Enable Data Types", "Did Not Auto-Enable Data Types");
        return result;
    }

    public static ITestResult getIsDataTypeUsed(Database db, IDataType dataType, boolean multipleExamples) {
        String dtDesc = dataType.getName();
        int dtId = dataType.getId();
        StringBuffer msgSb = new StringBuffer("Data Type '" + dtDesc + "' is used in: ");
        DataEntryResult result = new DataEntryResult(false, "Data Type Not Used", dtDesc + " is not used in db.");
        int foundCount = 0;
        boolean exit = false;
        Iterator itTbl = db.getAllTables().iterator();
        while (itTbl.hasNext() && !exit) {
            Table tbl = (Table)itTbl.next();
            for (Column col : tbl.values(Column.getClassName())) {
                int colDtId = col.getDataType().getId();
                if (dtId != colDtId) continue;
                boolean bl = exit = !multipleExamples && ++foundCount >= 2;
                if (exit) {
                    msgSb.append(", ...");
                    continue;
                }
                msgSb.append("\n    " + db.getName() + "." + tbl.getSchema().getName() + "." + tbl.getName() + "." + col.getName());
            }
        }
        if (foundCount > 0) {
            String msg = StrHelper.getTruncated(msgSb.toString(), 450);
            result = new DataEntryResult(true, "Data Type Is Used", msg);
        }
        return result;
    }
}

