/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.jdbc;

import com.harrand.dbwrench.jdbc.BasicTypesSvr;
import com.harrand.dbwrench.jdbc.IDataType;
import com.harrand.dbwrench.security.App;
import java.text.DateFormat;

public final class DataType
implements IDataType {
    private int id_;
    private String desc_;
    public static final String CLZ = "DataType";
    public static final String CLZ_DISPLAY_PL = "Data Types";

    public DataType(int typeId, String desc) {
        this.id_ = typeId;
        this.desc_ = desc;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataType)) {
            return false;
        }
        DataType other = (DataType)o;
        return other.getId() == this.getId();
    }

    @Override
    public boolean isLengthUsed() {
        boolean used = false;
        if (this.id_ == -2 || this.id_ == -7 || this.id_ == 1 || this.id_ == 3 || this.id_ == 2 || this.id_ == 780 || this.id_ == -3 || this.id_ == 12 || this.id_ == 781 || this.id_ == 782 || this.id_ == 785 || this.id_ == 722 || this.id_ == 724) {
            used = true;
        }
        return used;
    }

    @Override
    public boolean isLengthRequired() {
        boolean required = false;
        if (this.id_ == -7 || this.id_ == 1 || this.id_ == 722 || this.id_ == 724) {
            required = true;
        }
        return required;
    }

    @Override
    public boolean isScaleUsed() {
        boolean used = false;
        if (this.id_ == 3 || this.id_ == 2 || this.id_ == 780) {
            used = true;
        }
        return used;
    }

    @Override
    public boolean isScaleRequired() {
        return false;
    }

    @Override
    public DateFormat getFormmatter() {
        DateFormat formatter = null;
        switch (this.id_) {
            case 91: {
                formatter = DateFormat.getDateInstance();
                break;
            }
            case 700: {
                formatter = DateFormat.getDateTimeInstance();
                break;
            }
            case 93: {
                formatter = DateFormat.getDateTimeInstance();
                break;
            }
            case 772: {
                formatter = DateFormat.getDateTimeInstance();
                break;
            }
            case 92: {
                formatter = DateFormat.getTimeInstance();
                break;
            }
            case 773: {
                formatter = DateFormat.getTimeInstance();
            }
        }
        return formatter;
    }

    @Override
    public String getLengthUnitsDesc() {
        String key = "length.desc.not.applicable";
        switch (this.id_) {
            case -2: {
                key = "length.desc.bits";
                break;
            }
            case -7: {
                key = "length.desc.bits";
                break;
            }
            case 1: {
                key = "length.desc.chars";
                break;
            }
            case 722: {
                key = "length.desc.chars";
                break;
            }
            case 3: {
                key = "length.desc.precision";
                break;
            }
            case 2: {
                key = "length.desc.precision";
                break;
            }
            case -3: {
                key = "length.desc.bits";
                break;
            }
            case 12: {
                key = "length.desc.chars";
                break;
            }
            case 724: {
                key = "length.desc.chars";
            }
        }
        return App.getRes(key);
    }

    @Override
    public String getScaleUnitsDesc() {
        String key = "scale.desc.not.applicable";
        switch (this.id_) {
            case 3: {
                key = "scale.desc";
                break;
            }
            case 2: {
                key = "scale.desc";
            }
        }
        return App.getRes(key);
    }

    @Override
    public int getId() {
        return this.id_;
    }

    public String getIdStr() {
        return Integer.toString(this.id_);
    }

    public String toString() {
        return this.getDesc();
    }

    public String getDesc() {
        return this.desc_;
    }

    @Override
    public Integer getDefaultLength() {
        Integer defLength = null;
        switch (this.getId()) {
            case -7: {
                defLength = BasicTypesSvr.BIT_DEFAULT_LENGTH;
                break;
            }
            case -2: {
                defLength = BasicTypesSvr.BINARY_DEFAULT_LENGTH;
                break;
            }
            case 1: {
                defLength = BasicTypesSvr.CHAR_DEFAULT_LENGTH;
                break;
            }
            case 2: {
                defLength = BasicTypesSvr.NUMERIC_DEFAULT_LENGTH;
                break;
            }
            case 3: {
                defLength = BasicTypesSvr.DECIMAL_DEFAULT_LENGTH;
            }
        }
        return defLength;
    }

    @Override
    public Integer getDefaultScale() {
        Integer defLength = null;
        switch (this.getId()) {
            case 2: {
                defLength = BasicTypesSvr.NUMERIC_DEFAULT_SCALE;
                break;
            }
            case 3: {
                defLength = BasicTypesSvr.DECIMAL_DEFAULT_SCALE;
            }
        }
        return defLength;
    }

    @Override
    public boolean isIntegerLikeType() {
        boolean isInherentInteger = this.id_ == 4 || this.id_ == -6 || this.id_ == 5 || this.id_ == 702 || this.id_ == -5;
        return isInherentInteger;
    }

    @Override
    public boolean isNumberLikeType() {
        return this.isIntegerLikeType() || this.id_ == 2 || this.id_ == 3 || this.id_ == 6 || this.id_ == 7 || this.id_ == 8 || this.id_ == 701 || this.id_ == 780;
    }

    @Override
    public boolean isDateLikeType() {
        return this.id_ == 91 || this.id_ == 700 || this.id_ == 92 || this.id_ == 93;
    }

    @Override
    public boolean isStringLikeType() {
        return this.id_ == 1 || this.id_ == 12 || this.id_ == 703 || this.id_ == 710 || this.id_ == 711 || this.id_ == 712 || this.id_ == 722 || this.id_ == 724 || this.id_ == 723 || this.id_ == 781 || this.id_ == 782 || this.id_ == 731 || this.id_ == 729;
    }

    @Override
    public boolean isBooleanLikeType() {
        return this.id_ == -7 || this.id_ == 16;
    }

    @Override
    public boolean isBlobLikeType() {
        return this.id_ == 2004 || this.id_ == 760 || this.id_ == 707 || this.id_ == 708 || this.id_ == 721 || this.id_ == 709 || this.id_ == 783 || this.id_ == 784 || this.id_ == 785;
    }

    @Override
    public boolean isGeometricType() {
        return this.id_ == 770 || this.id_ == 766 || this.id_ == 767 || this.id_ == 761 || this.id_ == 769 || this.id_ == 771 || this.id_ == 762;
    }

    @Override
    public boolean isInternetType() {
        return this.id_ == 763 || this.id_ == 764 || this.id_ == 768;
    }

    @Override
    public boolean isStandardType() {
        return true;
    }

    public int compareTo(Object obj) {
        return DataType.compareTo(this, obj);
    }

    @Override
    public String getName() {
        return this.getDesc();
    }

    @Override
    public void setName(String newName) {
    }

    public static int compareTo(IDataType thisType, Object obj) {
        if (obj == null) {
            return 0;
        }
        if (!(obj instanceof IDataType)) {
            return 0;
        }
        IDataType other = (IDataType)obj;
        String thisNm = thisType.getName().toLowerCase();
        String otherNm = other.getName().toLowerCase();
        thisNm = thisNm.replace('(', '~');
        otherNm = otherNm.replace('(', '~');
        return thisNm.compareTo(otherNm.toLowerCase());
    }

    @Override
    public String getMapName() {
        return CLZ;
    }

    @Override
    public String getDisplayClzNm() {
        return CLZ;
    }

    @Override
    public String getDisplayClzPlural() {
        return CLZ_DISPLAY_PL;
    }
}

