/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.jdbc;

import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.util.MathUtil;

public class ConnMgr {
    private static final ConnMgr instance__ = new ConnMgr();
    private JdbcConfig currentCfg_ = null;
    private final IObservable observable_ = new BasicObservable();

    private ConnMgr() {
    }

    public static ConnMgr getInstance() {
        return instance__;
    }

    public void setAddedConfig(JdbcConfig config) {
        this.setCurrentCfg(config);
    }

    public JdbcConfig getCurrentCfg() {
        if (this.currentCfg_ == null) {
            this.setCurrentCfg(JdbcConfig.getGenericConfig("PostgreSql"));
        }
        return this.currentCfg_;
    }

    public void setCurrentCfg(JdbcConfig cfg) {
        boolean hasChanged = !MathUtil.isEquivalent(this.currentCfg_, cfg);
        this.currentCfg_ = cfg;
        if (hasChanged) {
            this.notifyObservers(new UpdateChain(cfg));
        }
    }

    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }

    public void notifyObservers(UpdateChain chain) {
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }
}

