/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.element;

import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class FkUtil {
    private Database db_;
    private static final String fkClz_ = ForeignKey.getClassName();

    public FkUtil(Database db) {
        this.db_ = db;
    }

    public List getAllFks() {
        ArrayList fks = new ArrayList();
        for (Schema schema : this.db_.values(Schema.getClassName())) {
            for (Table tbl : schema.values(Table.getClassName())) {
                fks.addAll(tbl.values(fkClz_));
            }
        }
        return fks;
    }

    public ForeignKey getFkFromDotNote(String dotNote) {
        String[] parts = dotNote.split("\\.");
        Schema schema = this.db_.getSchema(parts[0]);
        Table table = schema.getTable(parts[1]);
        ForeignKey fk = table.getForeignKey(parts[2]);
        return fk;
    }

    public List<ForeignKey> getAllRelationsForTable(Table table) {
        ArrayList<ForeignKey> fks = new ArrayList<ForeignKey>();
        fks.addAll(this.getFksForTable(table, 1));
        fks.addAll(this.getFksForTable(table, 0));
        return fks;
    }

    public List getFksForTable(Table table, int relation) {
        ArrayList<ForeignKey> tableFks = new ArrayList<ForeignKey>();
        String tblNm = table.getName();
        String schNm = table.getSchema().getName();
        for (ForeignKey fk : this.getAllFks()) {
            Table testTbl = relation == 1 ? fk.getChdTbl() : fk.getParTbl();
            if (!tblNm.equalsIgnoreCase(testTbl.getName()) || !schNm.equalsIgnoreCase(testTbl.getSchema().getName())) continue;
            tableFks.add(fk);
        }
        return tableFks;
    }

    public boolean getIsUsedInFk(Table table) {
        int fkCount = table.size(fkClz_);
        if (fkCount > 0) {
            return true;
        }
        List parRelations = this.getFksForTable(table, 0);
        return parRelations.size() > 0;
    }

    public void updateColumnNameInFks(Table table, String oldColumnName, String newColumnName) {
        ArrayList<String> changedFkNameList = new ArrayList<String>();
        HashMap<String, ForeignKey> changedOldFks = new HashMap<String, ForeignKey>();
        HashMap<String, ForeignKey> changedNewFks = new HashMap<String, ForeignKey>();
        List parentFks = this.getFksForTable(table, 0);
        for (ForeignKey fk : parentFks) {
            ForeignKey newFk = fk.getUpdatedColumnNameInstance(0, oldColumnName, newColumnName);
            if (newFk == null) continue;
            String fkName = fk.getName();
            changedFkNameList.add(fkName);
            changedOldFks.put(fkName, fk);
            changedNewFks.put(fkName, newFk);
        }
        List childFks = this.getFksForTable(table, 1);
        for (ForeignKey fk : childFks) {
            ForeignKey newFk = fk.getUpdatedColumnNameInstance(1, oldColumnName, newColumnName);
            if (newFk == null) continue;
            String fkName = fk.getName();
            changedFkNameList.add(fkName);
            changedOldFks.put(fkName, fk);
            changedNewFks.put(fkName, newFk);
        }
        for (String fkName : changedFkNameList) {
            ForeignKey oldFk = (ForeignKey)changedOldFks.get(fkName);
            ForeignKey newFk = (ForeignKey)changedNewFks.get(fkName);
            Table oldChdTbl = oldFk.getChdTbl();
            Table newChdTbl = newFk.getChdTbl();
            if (oldChdTbl.getDotNote().equalsIgnoreCase(newChdTbl.getDotNote())) {
                ITestResult iTestResult = oldChdTbl.updateItem(oldFk, newFk);
                continue;
            }
            oldChdTbl.remove(fkClz_, oldFk.getName());
            newChdTbl.add(newFk);
        }
    }
}

