/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.element;

import com.harrand.coreclasses.element.CollectorIdf;
import com.harrand.coreclasses.element.CollectorMapNm;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.nb.CentralLookup;
import com.harrand.coregui.nb.IWindowUtil;
import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import com.harrand.util.LogUtil;

public class CollectorProvider {
    private static CollectorProvider instance__ = new CollectorProvider();
    private CentralLookup lookup_ = CentralLookup.getDefault();
    private IWindowUtil windowUtil_ = null;

    private CollectorProvider() {
    }

    public static CollectorProvider getInstance() {
        return instance__;
    }

    public Table getTable() {
        Table tbl = null;
        tbl = (Table)this.lookup_.lookup(Table.class);
        if (tbl != null) {
            return tbl;
        }
        return tbl;
    }

    public Schema getSchema() {
        Schema sch = (Schema)this.lookup_.lookup(Schema.class);
        if (sch != null) {
            return sch;
        }
        return null;
    }

    public Diagram getDiagram() {
        Database db;
        String diagramNm;
        Diagram diagram = null;
        if (this.isWindowUtilSet() && (diagramNm = this.windowUtil_.getVisibleDiagramTC_Nm()) != null && (db = this.getDb()).contains(Diagram.getClassName(), diagramNm)) {
            diagram = db.getDiagram(diagramNm);
        }
        return diagram;
    }

    public void setWindowUtil(IWindowUtil util) {
        this.windowUtil_ = util;
    }

    public IWindowUtil getWindowUtil() {
        return this.windowUtil_;
    }

    private Database getDb() {
        return LookupUtil.getLookupDb();
    }

    private boolean isWindowUtilSet() {
        return this.windowUtil_ != null;
    }

    private Table getLastGlyphTable() {
        Table tbl = null;
        Glyph glyph = (Glyph)this.lookup_.lookup(Glyph.class);
        if (glyph instanceof DbTableGlyph) {
            DbTableGlyph tblGlyph = (DbTableGlyph)glyph;
            tbl = tblGlyph.getTable();
        }
        return tbl;
    }

    private Diagram getShowingDiagram() {
        return null;
    }

    private CollectorIdf getCollIdf() {
        return (CollectorIdf)this.lookup_.lookup(CollectorIdf.class);
    }

    private CollectorMapNm getCollMapNm() {
        return (CollectorMapNm)this.lookup_.lookup(CollectorMapNm.class);
    }

    private Collector getCollIdfCollector() {
        Collector coll = null;
        CollectorIdf collIdf = this.getCollIdf();
        if (collIdf != null) {
            LogUtil.logMsg("collProvider.getColl.collIdf: " + collIdf);
            coll = collIdf.getCollector();
        }
        return coll;
    }

    private Identifiable getCollIdfIdentifiable() {
        Identifiable idf = null;
        CollectorIdf collIdf = this.getCollIdf();
        if (collIdf != null) {
            LogUtil.logMsg("collProvider.getIdf.collIdf: " + collIdf);
            idf = collIdf.getIdentifiable();
        }
        return idf;
    }

    private Collector getCollMapNmCollector() {
        Collector coll = null;
        CollectorMapNm collMapNm = this.getCollMapNm();
        if (collMapNm != null) {
            coll = collMapNm.getCollector();
        }
        return coll;
    }
}

