/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.doc;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.doc.IDocBldr;
import com.harrand.coreclasses.doc.IDocCtrl;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.dbwrench.doc.BasicDocBldr;
import com.harrand.dbwrench.doc.MiscDocBldr;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.Trigger;
import com.harrand.util.FileHelper;
import com.harrand.util.HtmlHelper;
import com.harrand.util.LogUtil;
import com.harrand.util.XmlHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TriggerDocBldr
implements IDocBldr {
    private Database db_;
    private Table table_;
    private File baseFolder_;
    private BasicDocBldr basicBldr_;
    private HtmlHelper hh_;
    public static final String CSS_URL = "../css/doc.css";
    public static final String HEADER = "Header";

    public TriggerDocBldr(Database db, Table table, File baseFolder) {
        this.db_ = db;
        this.setTable(table);
        this.baseFolder_ = baseFolder;
        this.basicBldr_ = new BasicDocBldr(this.baseFolder_, "triggers", "doc.triggers");
        this.hh_ = new HtmlHelper();
    }

    @Override
    public void setDocCtrl(IDocCtrl docCtrl) {
        this.basicBldr_.setDocCtrl(docCtrl);
    }

    @Override
    public boolean getDocEnabled() {
        return this.basicBldr_.getDocEnabled();
    }

    public void setTable(Table table) {
        this.table_ = table;
    }

    @Override
    public ITestResult writePages() {
        DataEntryResult result = new DataEntryResult(true);
        this.basicBldr_.clearSubFolder();
        if (this.basicBldr_.getDocEnabled()) {
            try {
                this.basicBldr_.setMileStone("Writing trigger HTML files...");
                this.writeIndexPage();
                this.writePagesDisp();
            }
            catch (Exception e) {
                LogUtil.printStackTrace(e);
                result = new DataEntryResult(false, "Document Generation Error", e.getMessage());
            }
        }
        return result;
    }

    public Element getSummaryGrid(Document doc, Table table) {
        this.setTable(table);
        if (!table.hasTriggers()) {
            return this.hh_.getNoneGrid(doc, "Triggers");
        }
        Element elmGrid = doc.createElement("table");
        elmGrid.setAttribute("class", "flat");
        this.hh_.setDoc(doc);
        List items = this.getHeaderItems();
        elmGrid.appendChild(this.hh_.getBannerRow("Triggers", items.size()));
        Element elmHeader = this.hh_.getRowElement(items, HEADER);
        elmGrid.appendChild(elmHeader);
        this.hh_.setRowAltProps(true, table.size(Trigger.getClassName()));
        for (Trigger trigger : table.values(Trigger.getClassName())) {
            Element elmRow = this.getAsRowElement(doc, table, trigger);
            elmGrid.appendChild(elmRow);
        }
        return elmGrid;
    }

    private List getHeaderItems() {
        ArrayList<String> items = new ArrayList<String>();
        items.add("Name");
        items.add(Table.getClassName());
        items.add("On Delete");
        items.add("On Insert");
        items.add("On Update");
        items.add("Execute");
        items.add("For Each");
        items.add("SQL");
        return items;
    }

    private Element getAsRowElement(Document doc, Table tbl, Trigger trigger) {
        this.hh_.setDoc(doc);
        ArrayList<Object> items = new ArrayList<Object>();
        String name = trigger.getName();
        String dotNote = tbl.getDotNote() + "." + name;
        String fileNm = StrHelper.getDotNoteAsUnderScore(dotNote);
        String url = "../triggers/" + fileNm + ".html";
        Element anchor = this.hh_.getAnchor(name, url, null);
        items.add(anchor);
        String tblText = tbl.getSchema().getPrefixIfMany() + tbl.getName();
        Element tblAnchor = this.hh_.getAnchor(tblText, "../tables/" + StrHelper.getDotNoteAsUnderScore(tbl.getDotNote()) + ".html", null);
        items.add(tblAnchor);
        items.add(this.hh_.getBooleanImageElm("../images/ok12d.gif", trigger.getFireOnDeleteFlag()));
        items.add(this.hh_.getBooleanImageElm("../images/ok12d.gif", trigger.getFireOnInsertFlag()));
        items.add(this.hh_.getBooleanImageElm("../images/ok12d.gif", trigger.getFireOnUpdateFlag()));
        items.add(trigger.getExecWhenStr());
        items.add(trigger.getForEachStr());
        items.add(trigger.getSqlMaxLength(20));
        Element elmRow = this.hh_.getRowElement(items, null);
        return elmRow;
    }

    private void writeIndexPage() throws Exception {
        File file = FileHelper.getFile(this.basicBldr_.getSubFolder(), "index.html");
        this.setMileStone(file);
        Document doc = HtmlHelper.getHtmlDoc(CSS_URL, this.db_.getName() + " " + "Triggers");
        this.hh_.setDoc(doc);
        Element elmBody = HtmlHelper.getBodyElement(doc);
        MiscDocBldr.addPageHeader(doc, 1, this.db_.getName());
        Element elmGrid = doc.createElement("table");
        elmBody.appendChild(elmGrid);
        elmGrid.setAttribute("class", "flat");
        List items = this.getHeaderItems();
        elmGrid.appendChild(this.hh_.getBannerRow("Triggers", items.size()));
        Element elmHeader = this.hh_.getRowElement(items, HEADER);
        elmGrid.appendChild(elmHeader);
        items.clear();
        this.hh_.setRowAltProps(true, this.db_.getTotalTableItems(Trigger.getClassName()));
        TreeMap triggersMap = new TreeMap();
        for (Table table : this.db_.getAllTables()) {
            for (Trigger trigger : table.values(Trigger.getClassName())) {
                elmGrid.appendChild(this.getAsRowElement(doc, table, trigger));
            }
        }
        XmlHelper.writeElement(doc.getDocumentElement(), file);
    }

    private void writePagesDisp() throws Exception {
        ArrayList items = new ArrayList();
        int totalItems = this.db_.getTotalTableItems(Trigger.getClassName());
        int i = 0;
        Iterator itTable = this.db_.getAllTables().iterator();
        while (itTable.hasNext()) {
            this.setTable((Table)itTable.next());
            Schema schema = this.table_.getSchema();
            for (Trigger trigger : this.table_.values(Trigger.getClassName())) {
                items.clear();
                String trgName = trigger.getName();
                String dotNote = this.table_.getDotNote() + "." + trgName;
                String fileNm = StrHelper.getDotNoteAsUnderScore(dotNote);
                File file = FileHelper.getFile(this.basicBldr_.getSubFolder(), fileNm + ".html");
                this.setStatus(file, ++i, totalItems);
                Document doc = this.basicBldr_.getHtmlDoc(CSS_URL, (Collector)this.table_, trigger);
                this.hh_.setDoc(doc);
                Element elmBody = HtmlHelper.getBodyElement(doc);
                MiscDocBldr.addPageHeader(doc, 1, this.db_.getName());
                Element elmGrid = doc.createElement("table");
                elmBody.appendChild(elmGrid);
                elmGrid.setAttribute("class", "flat");
                elmGrid.appendChild(this.hh_.getBannerRow(trgName, "Trigger"));
                elmGrid.appendChild(this.hh_.getKeyValueRowElm("Name", trigger.getName()));
                String tblText = schema.getPrefixIfMany() + this.table_.getName();
                Element tblAnchor = this.hh_.getAnchor(tblText, "../tables/" + StrHelper.getDotNoteAsUnderScore(this.table_.getDotNote()) + ".html", null);
                elmGrid.appendChild(this.hh_.getKeyValueRowElm("Table", tblAnchor));
                Element elmBool = this.hh_.getBoolImgHorzElm("../images/ok12d.gif", trigger.getFireOnDeleteFlag());
                elmGrid.appendChild(this.hh_.getKeyValueRowElm("On Delete", elmBool));
                elmBool = this.hh_.getBoolImgHorzElm("../images/ok12d.gif", trigger.getFireOnInsertFlag());
                elmGrid.appendChild(this.hh_.getKeyValueRowElm("On Insert", elmBool));
                elmBool = this.hh_.getBoolImgHorzElm("../images/ok12d.gif", trigger.getFireOnUpdateFlag());
                elmGrid.appendChild(this.hh_.getKeyValueRowElm("On Update", elmBool));
                elmGrid.appendChild(this.hh_.getKeyValueRowElm("Execute", trigger.getExecWhenStr()));
                elmGrid.appendChild(this.hh_.getKeyValueRowElm("For Each", trigger.getForEachStr()));
                String sql = trigger.getSql();
                sql = sql.replaceAll("\r\n", "\n");
                elmGrid.appendChild(this.hh_.getKeyValueRowElm("SQL", this.hh_.getPreElm(sql)));
                XmlHelper.writeElement(doc.getDocumentElement(), file);
            }
        }
    }

    private void setMileStone(File file) {
        this.basicBldr_.setMileStone(file);
    }

    private void setStatus(File file, int currentItem, int totalItems) {
        this.basicBldr_.setStatus(file, "Trigger", currentItem, totalItems);
    }
}

