/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.doc;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.doc.IDocBldr;
import com.harrand.coreclasses.doc.IDocCtrl;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.implementation.BasicCollector;
import com.harrand.dbwrench.doc.BasicDocBldr;
import com.harrand.dbwrench.doc.MiscDocBldr;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Proc;
import com.harrand.dbwrench.object.Schema;
import com.harrand.util.FileHelper;
import com.harrand.util.HtmlHelper;
import com.harrand.util.LogUtil;
import com.harrand.util.XmlHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProcDocBldr
implements IDocBldr {
    private Database db_;
    private File baseFolder_;
    private BasicDocBldr basicBldr_;
    private HtmlHelper hh_;
    public static final String CSS_URL = "../css/doc.css";

    public ProcDocBldr(Database db, File baseFolder) {
        this.db_ = db;
        this.baseFolder_ = baseFolder;
        this.basicBldr_ = new BasicDocBldr(this.baseFolder_, "procedures", "doc.procs");
        this.hh_ = new HtmlHelper();
    }

    @Override
    public ITestResult writePages() {
        DataEntryResult result = new DataEntryResult(true);
        this.basicBldr_.clearSubFolder();
        if (this.basicBldr_.getDocEnabled()) {
            try {
                this.basicBldr_.setMileStone("Writing foreign key HTML files...");
                this.writeIndexPage();
                this.writePagesDisp();
            }
            catch (Exception e) {
                LogUtil.logMsg("ProDocBldr.err: " + e.getMessage());
                result = new DataEntryResult(false, "Document Generation Error", e.getMessage());
            }
        }
        return result;
    }

    @Override
    public void setDocCtrl(IDocCtrl docCtrl) {
        this.basicBldr_.setDocCtrl(docCtrl);
    }

    @Override
    public boolean getDocEnabled() {
        return this.basicBldr_.getDocEnabled();
    }

    private List getHeaderItems(boolean showSchema) {
        ArrayList<String> items = new ArrayList<String>();
        items.add("Name");
        items.add("Comment");
        if (showSchema) {
            items.add("Schema");
        }
        return items;
    }

    private void addSummaryRows(Element elmGrid, List procs, boolean showSchema) {
        ArrayList<Object> items = new ArrayList<Object>();
        for (Proc proc : procs) {
            Schema schema = proc.getSchema();
            String procName = proc.getName();
            String fileNm = StrHelper.getDotNoteAsUnderScore(proc.getDotNote());
            if (!showSchema) {
                fileNm = "../procedures/" + fileNm;
            }
            String procFileName = StrHelper.getFileSafeStr(fileNm);
            String url = procFileName + ".html";
            Element anchor = this.hh_.getAnchor(procName, url, null);
            items.clear();
            items.add(anchor);
            items.add(proc.getComment());
            if (showSchema) {
                items.add(schema.getName());
            }
            Element elmRow = this.hh_.getRowElement(items, null);
            elmGrid.appendChild(elmRow);
        }
    }

    private void writeIndexPage() throws Exception {
        File file = FileHelper.getFile(this.basicBldr_.getSubFolder(), "index.html");
        this.setMileStone(file);
        Document doc = this.basicBldr_.getHtmlDoc(CSS_URL, (Collector)this.db_, Proc.getClassName());
        this.hh_.setDoc(doc);
        Element elmBody = HtmlHelper.getBodyElement(doc);
        MiscDocBldr.addPageHeader(doc, 1, this.db_.getName());
        Element elmGrid = doc.createElement("table");
        elmBody.appendChild(elmGrid);
        elmGrid.setAttribute("class", "flat");
        List items = this.getHeaderItems(true);
        elmGrid.appendChild(this.hh_.getBannerRow("Procedures", items.size()));
        Element elmHeader = this.hh_.getRowElement(items, "Header");
        elmGrid.appendChild(elmHeader);
        List<Proc> idfs = this.db_.getAllProcs();
        BasicCollector.sortByNames(idfs);
        this.hh_.setRowAltProps(true, idfs.size());
        this.addSummaryRows(elmGrid, idfs, true);
        XmlHelper.writeElement(doc.getDocumentElement(), file);
    }

    private void writePagesDisp() throws Exception {
        List<Proc> items = this.db_.getAllProcs();
        int totalItems = items.size();
        int i = 0;
        for (Proc proc : items) {
            Schema schema = proc.getSchema();
            String procName = proc.getName();
            String fileNmRaw = StrHelper.getDotNoteAsUnderScore(proc.getDotNote());
            String fileNm = StrHelper.getFileSafeStr(fileNmRaw);
            File file = FileHelper.getFile(this.basicBldr_.getSubFolder(), fileNm + ".html");
            this.setStatus(file, ++i, totalItems);
            Document doc = this.basicBldr_.getHtmlDoc(CSS_URL, (Collector)this.db_, proc);
            this.hh_.setDoc(doc);
            Element elmBody = HtmlHelper.getBodyElement(doc);
            Element elmGrid = doc.createElement("table");
            MiscDocBldr.addPageHeader(doc, 1, this.db_.getName());
            elmBody.appendChild(elmGrid);
            elmGrid.setAttribute("class", "flat");
            elmGrid.appendChild(this.hh_.getBannerRow(procName, "Procedure"));
            elmGrid.appendChild(this.hh_.getKeyValueRowElm("Name", procName));
            elmGrid.appendChild(this.hh_.getKeyValueRowElm("Comment", proc.getComment()));
            String src = proc.getSrc();
            src = src.replaceAll("\r\n", "\n");
            elmGrid.appendChild(this.hh_.getKeyValueRowElm("Src", this.hh_.getPreElm(src)));
            XmlHelper.writeElement(doc.getDocumentElement(), file);
        }
    }

    public Element getSummaryGrid(Document doc, List idfs) {
        if (idfs.isEmpty()) {
            return this.hh_.getNoneGrid(doc, "Procedures");
        }
        Element elmGrid = doc.createElement("table");
        elmGrid.setAttribute("class", "flat");
        this.hh_.setDoc(doc);
        List headerItems = this.getHeaderItems(false);
        elmGrid.appendChild(this.hh_.getBannerRow("Procedures", headerItems.size()));
        Element elmHeader = this.hh_.getRowElement(headerItems, "header");
        elmGrid.appendChild(elmHeader);
        this.hh_.setRowAltProps(true, idfs.size());
        this.addSummaryRows(elmGrid, idfs, false);
        return elmGrid;
    }

    private void setMileStone(File file) {
        this.basicBldr_.setMileStone(file);
    }

    private void setStatus(File file, int currentItem, int totalItems) {
        this.basicBldr_.setStatus(file, "Procedure", currentItem, totalItems);
    }
}

