/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.doc;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.doc.IDocCtrl;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.util.FileHelper;
import com.harrand.util.HtmlHelper;
import com.harrand.util.XmlHelper;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MiscDocBldr {
    private static int folderLevel__ = 0;
    private IDocCtrl docCtrl_;

    public static void addPageHeader(Document doc, int folderLevel, String dbName) {
        HtmlHelper hh = new HtmlHelper();
        hh.setDoc(doc);
        folderLevel__ = folderLevel;
        ArrayList<Object> items = new ArrayList<Object>();
        Element elmBody = HtmlHelper.getBodyElement(doc);
        Element elmLogoGrid = doc.createElement("table");
        elmBody.appendChild(elmLogoGrid);
        elmLogoGrid.setAttribute("class", "logo");
        items.clear();
        Database db = LookupUtil.findDb();
        String strDocFor = db.getDisplayTitle();
        items.add(strDocFor);
        elmLogoGrid.appendChild(hh.getRowElement(items, "logo"));
        Element elmGrid = doc.createElement("table");
        elmBody.appendChild(elmGrid);
        String horzMenu = "horzMenu";
        elmGrid.setAttribute("class", horzMenu);
        items.clear();
        String pipe = "|";
        items.add(hh.getAnchor(" Home", MiscDocBldr.getUrl("index.html"), horzMenu));
        items.add(pipe);
        items.add(hh.getAnchor("Tables", MiscDocBldr.getUrl("tables/index.html"), horzMenu));
        items.add(pipe);
        items.add(hh.getAnchor("Schemas", MiscDocBldr.getUrl("schemas/index.html"), horzMenu));
        items.add(pipe);
        items.add(hh.getAnchor("Diagrams", MiscDocBldr.getUrl("diagrams/index.html"), horzMenu));
        items.add(pipe);
        items.add(hh.getAnchor("Foreign Keys", MiscDocBldr.getUrl("foreignKeys/index.html"), horzMenu));
        items.add(pipe);
        items.add(hh.getAnchor("Indexes", MiscDocBldr.getUrl("indexes/index.html"), horzMenu));
        Element elmFiller = XmlHelper.createElementSimple(doc, "td", "");
        elmFiller.setAttribute("class", "horzMenuFiller");
        Element elmRowMnu = hh.getRowElement(items, "horzMenu");
        elmRowMnu.appendChild(elmFiller);
        elmGrid.appendChild(elmRowMnu);
        Element elmHr = doc.createElement("hr");
        elmBody.appendChild(elmHr);
    }

    public void setDocCtrl(IDocCtrl docCtrl) {
        this.docCtrl_ = docCtrl;
    }

    public ITestResult checkSupportFiles(File baseFolder) {
        ITestResult result = new DataEntryResult(true);
        StringBuffer errBuff = new StringBuffer();
        File file = FileHelper.getFile(baseFolder, "images/ok12d.gif");
        result = this.checkSupportFileDisp(file, "ok12d.gif", false);
        if (!result.getPassed()) {
            errBuff.append(result.getDetail() + "\n");
        }
        if (!(result = this.checkSupportFileDisp(file = FileHelper.getFile(baseFolder, "images/pkb16.gif"), "pkb16.gif", false)).getPassed()) {
            errBuff.append(result.getDetail() + "\n");
        }
        for (int i = 0; i < 8; ++i) {
            int j = i + 1;
            String name = "pkIcons/pkb" + j + "_16.gif";
            file = FileHelper.getFile(baseFolder, "images/" + name);
            result = this.checkSupportFileDisp(file, name, false);
            if (result.getPassed()) continue;
            errBuff.append(result.getDetail() + "\n");
        }
        file = FileHelper.getFile(baseFolder, "css/doc.css");
        boolean overwriteCss = true;
        if (this.docCtrl_ != null) {
            IOptionMgr optionMgr = this.docCtrl_.getDocOptionMgr();
            overwriteCss = optionMgr.getBoolValue("doc.overwrite.css");
        }
        if (!(result = this.checkSupportFileDisp(file, "doc.css", overwriteCss)).getPassed()) {
            errBuff.append(result.getDetail() + "\n");
        }
        if (errBuff.length() > 0) {
            result = new DataEntryResult(false, errBuff.toString());
        }
        return result;
    }

    private ITestResult checkSupportFileDisp(File file, String resourceName, boolean overwrite) {
        DataEntryResult result = new DataEntryResult(true);
        if (!file.exists() || overwrite) {
            try {
                InputStream in = this.getClass().getResourceAsStream(resourceName);
                FileHelper.copy(in, file);
            }
            catch (Exception e) {
                result = new DataEntryResult(false, "Writing HTML Support Files Failed", "ERROR: " + e.getMessage());
            }
        }
        return result;
    }

    private static String getUrl(String fileName) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < folderLevel__; ++i) {
            sb.append("../");
        }
        return sb.toString() + fileName;
    }
}

