/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.doc;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.doc.IDocBldr;
import com.harrand.coreclasses.doc.IDocCtrl;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.dbwrench.doc.BasicDocBldr;
import com.harrand.dbwrench.doc.MiscDocBldr;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.util.FileHelper;
import com.harrand.util.HtmlHelper;
import com.harrand.util.XmlHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FkDocBldr
implements IDocBldr {
    private Database db_;
    private File baseFolder_;
    private BasicDocBldr basicBldr_;
    private HtmlHelper hh_;
    public static final String CSS_URL = "../css/doc.css";

    public FkDocBldr(Database db, File baseFolder) {
        this.db_ = db;
        this.baseFolder_ = baseFolder;
        this.basicBldr_ = new BasicDocBldr(this.baseFolder_, "foreignKeys", "doc.fks");
        this.hh_ = new HtmlHelper();
    }

    @Override
    public ITestResult writePages() {
        DataEntryResult result = new DataEntryResult(true);
        this.basicBldr_.clearSubFolder();
        if (this.basicBldr_.getDocEnabled()) {
            try {
                this.basicBldr_.setMileStone("Writing foreign key HTML files...");
                this.writeIndexPage();
                this.writePagesDisp();
            }
            catch (Exception e) {
                result = new DataEntryResult(false, "Document Generation Error", e.getMessage());
            }
        }
        return result;
    }

    @Override
    public void setDocCtrl(IDocCtrl docCtrl) {
        this.basicBldr_.setDocCtrl(docCtrl);
    }

    @Override
    public boolean getDocEnabled() {
        return this.basicBldr_.getDocEnabled();
    }

    public Element getSummaryGrid(Document doc, Table table, int relationId) {
        String relationStr;
        List fks = this.db_.getFkUtil().getFksForTable(table, relationId);
        String string = relationStr = relationId == 0 ? "Parent Relations" : "Foreign Keys";
        if (fks.isEmpty()) {
            return this.hh_.getNoneGrid(doc, relationStr);
        }
        Element elmGrid = doc.createElement("table");
        elmGrid.setAttribute("class", "flat");
        this.hh_.setDoc(doc);
        List items = this.getHeaderItems();
        elmGrid.appendChild(this.hh_.getBannerRow(relationStr, items.size()));
        Element elmHeader = this.hh_.getRowElement(items, "header");
        elmGrid.appendChild(elmHeader);
        this.hh_.setRowAltProps(true, fks.size());
        for (ForeignKey fk : fks) {
            Element elmRow = this.getAsRowElement(doc, fk);
            elmGrid.appendChild(elmRow);
        }
        return elmGrid;
    }

    private Element getAsRowElement(Document doc, ForeignKey fk) {
        this.hh_.setDoc(doc);
        ArrayList<Object> items = new ArrayList<Object>();
        String fkNm = fk.getName();
        String fkDotNote = fk.getDotNote();
        Schema schema = fk.getParTbl().getSchema();
        String fkAnchorText = fkNm;
        String url = "../foreignKeys/" + StrHelper.getDotNoteAsUnderScore(fkDotNote) + ".html";
        Element anchor = this.hh_.getAnchor(fkAnchorText, url, null);
        items.add(anchor);
        String parTblNm = fk.getParTbl().getName();
        String parTblDotNote = fk.getParTbl().getDotNote();
        String parAnchorText = schema.getPrefixIfMany() + parTblNm;
        Element parTblAnchor = this.hh_.getAnchor(parAnchorText, "../tables/" + StrHelper.getDotNoteAsUnderScore(parTblDotNote) + ".html", null);
        Table chdTbl = fk.getChdTbl();
        String chdTblNm = chdTbl.getName();
        String chdTblDotNote = chdTbl.getDotNote();
        String chdAnchorText = chdTbl.getSchema().getPrefixIfMany() + chdTblNm;
        Element chdTblAnchor = this.hh_.getAnchor(chdAnchorText, "../tables/" + StrHelper.getDotNoteAsUnderScore(chdTblDotNote) + ".html", null);
        items.add(parTblAnchor);
        items.add(chdTblAnchor);
        items.add(fk.getParentColumnsCsv());
        items.add(fk.getChildColumnsCsv());
        Element elmRow = this.hh_.getRowElement(items, null);
        return elmRow;
    }

    private List getHeaderItems() {
        ArrayList<String> items = new ArrayList<String>();
        items.add("Name");
        items.add("Parent Table");
        items.add("Child Table");
        items.add("Parent Columns");
        items.add("Child Columns");
        return items;
    }

    private void writeIndexPage() throws Exception {
        File file = FileHelper.getFile(this.basicBldr_.getSubFolder(), "index.html");
        this.setMileStone(file);
        Document doc = this.basicBldr_.getHtmlDoc(CSS_URL, (Collector)this.db_, ForeignKey.getClassName());
        this.hh_.setDoc(doc);
        Element elmBody = HtmlHelper.getBodyElement(doc);
        MiscDocBldr.addPageHeader(doc, 1, this.db_.getName());
        Element elmGrid = doc.createElement("table");
        elmBody.appendChild(elmGrid);
        elmGrid.setAttribute("class", "flat");
        List items = this.getHeaderItems();
        elmGrid.appendChild(this.hh_.getBannerRow("Foreign Keys", items.size()));
        Element elmHeader = this.hh_.getRowElement(items, "Header");
        elmGrid.appendChild(elmHeader);
        items.clear();
        this.hh_.setRowAltProps(true, this.db_.getTotalTableItems(ForeignKey.getClassName()));
        for (Schema sch : this.db_.values(Schema.getClassName())) {
            for (Table tbl : sch.values(Table.getClassName())) {
                for (ForeignKey fk : tbl.values(ForeignKey.getClassName())) {
                    elmGrid.appendChild(this.getAsRowElement(doc, fk));
                }
            }
        }
        XmlHelper.writeElement(doc.getDocumentElement(), file);
    }

    private void writePagesDisp() throws Exception {
        ArrayList items = new ArrayList();
        List allFks = this.db_.getFkUtil().getAllFks();
        int totalItems = allFks.size();
        int i = 0;
        for (ForeignKey fk : allFks) {
            Table parTbl = fk.getParTbl();
            Table chdTbl = fk.getChdTbl();
            Schema schema = chdTbl.getSchema();
            items.clear();
            String fkName = fk.getName();
            String fileNm = StrHelper.getDotNoteAsUnderScore(fk.getDotNote());
            File file = FileHelper.getFile(this.basicBldr_.getSubFolder(), fileNm + ".html");
            this.setStatus(file, ++i, totalItems);
            Document doc = this.basicBldr_.getHtmlDoc(CSS_URL, (Collector)this.db_, fk);
            MiscDocBldr.addPageHeader(doc, 1, this.db_.getName());
            this.hh_.setDoc(doc);
            Element elmBody = HtmlHelper.getBodyElement(doc);
            Element elmGrid = doc.createElement("table");
            elmBody.appendChild(elmGrid);
            elmGrid.setAttribute("class", "flat");
            elmGrid.appendChild(this.hh_.getBannerRow(fkName, "Foreign Key"));
            elmGrid.appendChild(this.hh_.getKeyValueRowElm("Name", fk.getName()));
            elmGrid.appendChild(this.hh_.getKeyValueRowElm("Comment", fk.getComment()));
            String tblParText = schema.getPrefixIfMany() + parTbl.getName();
            Element tblParAnchor = this.hh_.getAnchor(tblParText, "../tables/" + StrHelper.getDotNoteAsUnderScore(parTbl.getDotNote()) + ".html", null);
            elmGrid.appendChild(this.hh_.getKeyValueRowElm("Parent Table", tblParAnchor));
            String tblChdText = schema.getPrefixIfMany() + chdTbl.getName();
            Element tblChdAnchor = this.hh_.getAnchor(tblChdText, "../tables/" + StrHelper.getDotNoteAsUnderScore(chdTbl.getDotNote()) + ".html", null);
            elmGrid.appendChild(this.hh_.getKeyValueRowElm("Child Table", tblChdAnchor));
            elmGrid.appendChild(this.hh_.getKeyValueRowElm("Parent Columns", fk.getParentColumnsCsv()));
            elmGrid.appendChild(this.hh_.getKeyValueRowElm("Child Columns", fk.getChildColumnsCsv()));
            elmGrid.appendChild(this.hh_.getKeyValueRowElm("Parent Cardinality", fk.getParentCardinality().toString()));
            elmGrid.appendChild(this.hh_.getKeyValueRowElm("Child Cardinality", fk.getChildCardinality().toString()));
            elmGrid.appendChild(this.hh_.getKeyValueRowElm("Delete Action", fk.getDeleteActionStr()));
            elmGrid.appendChild(this.hh_.getKeyValueRowElm("Update Action", fk.getUpdateActionStr()));
            XmlHelper.writeElement(doc.getDocumentElement(), file);
        }
    }

    private void setMileStone(File file) {
        this.basicBldr_.setMileStone(file);
    }

    private void setStatus(File file, int currentItem, int totalItems) {
        this.basicBldr_.setStatus(file, "Foreign Key", currentItem, totalItems);
    }
}

