/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.doc;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.doc.IDocBldr;
import com.harrand.coreclasses.doc.IDocCtrl;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.dbwrench.diagram.DbDrawableOrderer;
import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.doc.BasicDocBldr;
import com.harrand.dbwrench.doc.MiscDocBldr;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Table;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.j2d.DiagramExporter;
import com.harrand.util.FileHelper;
import com.harrand.util.HtmlHelper;
import com.harrand.util.XmlHelper;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DiagramDocBldr
implements IDocBldr {
    private Database db_;
    private File baseFolder_;
    private BasicDocBldr basicBldr_;
    private HtmlHelper hh_;
    private String clazz_ = Diagram.getClassName();
    public static final String USED_IN_DIAGRAMS_STR = "Used in Diagrams";
    public static final String CSS_URL = "../css/doc.css";

    public DiagramDocBldr(Database db, File baseFolder) {
        this.db_ = db;
        this.baseFolder_ = baseFolder;
        this.basicBldr_ = new BasicDocBldr(this.baseFolder_, "diagrams", "doc.diagrams");
        this.hh_ = new HtmlHelper();
    }

    @Override
    public ITestResult writePages() {
        DataEntryResult result = new DataEntryResult(true);
        this.basicBldr_.clearSubFolder();
        if (this.basicBldr_.getDocEnabled()) {
            try {
                this.writeIndexPage();
                this.writePagesDisp();
            }
            catch (Exception e) {
                result = new DataEntryResult(false, "Document Generation Error", e.getMessage());
            }
        }
        return result;
    }

    @Override
    public void setDocCtrl(IDocCtrl docCtrl) {
        this.basicBldr_.setDocCtrl(docCtrl);
    }

    @Override
    public boolean getDocEnabled() {
        return this.basicBldr_.getDocEnabled();
    }

    public Element getSummaryGrid(Document doc, Table table) {
        Element elmGrid = doc.createElement("table");
        elmGrid.setAttribute("class", "flat");
        this.hh_.setDoc(doc);
        ArrayList<String> items = new ArrayList<String>();
        items.add("Diagram Name");
        elmGrid.appendChild(this.hh_.getBannerRow(USED_IN_DIAGRAMS_STR, items.size()));
        Element elmHeader = this.hh_.getRowElement(items, "Header");
        elmGrid.appendChild(elmHeader);
        boolean hasDiagram = false;
        for (Diagram diagram : this.db_.values(this.clazz_)) {
            List<String> list = diagram.getGlyphNames();
            if (!list.contains(table.getDotNote())) continue;
            elmGrid.appendChild(this.asRowElement(diagram));
            hasDiagram = true;
        }
        if (hasDiagram) {
            return elmGrid;
        }
        return this.hh_.getNoneGrid(doc, USED_IN_DIAGRAMS_STR);
    }

    private void writeIndexPage() throws Exception {
        File file = FileHelper.getFile(this.basicBldr_.getSubFolder(), "index.html");
        this.setMileStone(file);
        Document doc = this.basicBldr_.getHtmlDoc(CSS_URL, (Collector)this.db_, Diagram.getClassName());
        this.hh_.setDoc(doc);
        Element elmBody = HtmlHelper.getBodyElement(doc);
        MiscDocBldr.addPageHeader(doc, 1, this.db_.getName());
        Element elmGrid = doc.createElement("table");
        elmBody.appendChild(elmGrid);
        elmGrid.setAttribute("class", "flat");
        for (Diagram diagram : this.db_.values(this.clazz_)) {
            elmBody.appendChild(this.getThumbElm(doc, diagram));
            elmBody.appendChild(doc.createElement("br"));
        }
        XmlHelper.writeElement(doc.getDocumentElement(), file);
    }

    private void writePagesDisp() throws Exception {
        ArrayList<Element> items = new ArrayList<Element>();
        int totalItems = this.db_.size(Diagram.getClassName());
        int i = 0;
        for (Diagram diagram : this.db_.values(this.clazz_)) {
            Document doc = this.basicBldr_.getHtmlDoc(CSS_URL, (Collector)this.db_, diagram);
            MiscDocBldr.addPageHeader(doc, 1, this.db_.getName());
            this.hh_.setDoc(doc);
            Element elmBody = HtmlHelper.getBodyElement(doc);
            String diagramName = diagram.getName();
            File file = FileHelper.getFile(this.basicBldr_.getSubFolder(), diagramName + ".html");
            this.setMileStone(file);
            this.setStatus(file, ++i, totalItems);
            Element pageTitleGrid = doc.createElement("table");
            elmBody.appendChild(pageTitleGrid);
            pageTitleGrid.setAttribute("class", "pageTitle");
            Element elmName = XmlHelper.createElementSimple(doc, "td", diagramName);
            elmName.setAttribute("class", "title_nm");
            Element elmType = XmlHelper.createElementSimple(doc, "td", "(Diagram)");
            elmType.setAttribute("class", "watermark_right");
            items.clear();
            items.add(elmName);
            items.add(elmType);
            pageTitleGrid.appendChild(this.hh_.getRowElement(items, "pageTitle"));
            elmBody.appendChild(doc.createElement("br"));
            elmBody.appendChild(this.getImageLinkMap(doc, diagram));
            String imgName = diagramName + ".png";
            Element elmImg = this.hh_.getImageElm(imgName, null);
            elmImg.setAttribute("usemap", "#imgmap");
            elmBody.appendChild(elmImg);
            XmlHelper.writeElement(doc.getDocumentElement(), FileHelper.getFile(this.basicBldr_.getSubFolder(), diagramName + ".html"));
            File pngFile = FileHelper.getFile(this.basicBldr_.getSubFolder(), imgName);
            DiagramExporter.export(diagram, new DbDrawableOrderer(), "png", pngFile);
        }
    }

    private Element asRowElement(Diagram diagram) {
        ArrayList<Element> items = new ArrayList<Element>();
        String diagramName = diagram.getName();
        String url = "../diagrams/" + diagramName + ".html";
        Element anchor = this.hh_.getAnchor(diagramName, url, null);
        items.add(anchor);
        Element elmRow = this.hh_.getRowElement(items, null);
        return elmRow;
    }

    private Element getThumbElm(Document doc, Diagram diagram) {
        String diagramName = diagram.getName();
        String href = "../diagrams/" + diagramName + ".html";
        String src = "../diagrams/" + diagramName + ".png";
        Rectangle2D bounds = diagram.getBounds2D();
        double ratio = bounds.getHeight() / bounds.getWidth();
        int width = 500;
        int height = (int)((double)width * ratio);
        ArrayList<Element> items = new ArrayList<Element>();
        Element miniGrid = doc.createElement("table");
        miniGrid.setAttribute("class", "flat");
        Element elmTxtAnchor = this.hh_.getAnchor(diagram.getName(), href, null);
        items.clear();
        items.add(elmTxtAnchor);
        Element elmTxtRow = this.hh_.getRowElement(items, "header");
        miniGrid.appendChild(elmTxtRow);
        Element elmImgAnchor = this.hh_.getAnchor("", href, null);
        Element elmImg = this.hh_.getImageElm(src, null);
        elmImgAnchor.appendChild(elmImg);
        elmImg.setAttribute("width", Integer.toString(width));
        elmImg.setAttribute("height", Integer.toString(height));
        items.clear();
        items.add(elmImgAnchor);
        Element elmImgRow = this.hh_.getRowElement(items, "diagramThumb");
        miniGrid.appendChild(elmImgRow);
        return miniGrid;
    }

    private Element getImageLinkMap(Document doc, Diagram diagram) {
        Element elmMap = doc.createElement("map");
        elmMap.setAttribute("id", "imgmap");
        elmMap.setAttribute("name", "imgmap");
        for (Glyph glyph : diagram.getOnlyGlyphs()) {
            if (!(glyph instanceof DbTableGlyph)) continue;
            String glyphNm = glyph.getName();
            double zmLevel = diagram.getZoom().getLevel();
            Rectangle2D bounds = glyph.getBounds2D();
            int x1 = (int)(bounds.getMinX() * zmLevel);
            int y1 = (int)(bounds.getMinY() * zmLevel);
            int x2 = (int)(bounds.getMaxX() * zmLevel);
            int y2 = (int)(bounds.getMaxY() * zmLevel);
            Element elmArea = doc.createElement("area");
            elmArea.setAttribute("shape", "rect");
            String href = "../tables/" + StrHelper.getDotNoteAsUnderScore(glyphNm) + ".html";
            elmArea.setAttribute("href", href);
            String coordStr = x1 + ", " + y1 + ", " + x2 + ", " + y2;
            elmArea.setAttribute("coords", coordStr);
            elmMap.appendChild(elmArea);
        }
        return elmMap;
    }

    private void setMileStone(File file) {
        this.basicBldr_.setMileStone(file);
    }

    private void setStatus(File file, int currentItem, int totalItems) {
        this.basicBldr_.setStatus(file, "Diagram", currentItem, totalItems);
    }
}

