/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.doc;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.option.BooleanOption;
import com.harrand.coreclasses.option.IOption;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coregui.option.BasicOptionMgr;
import com.harrand.dbwrench.object.Database;
import com.harrand.util.XmlHelper;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DbDocOptionMgr
implements IOptionMgr {
    private BasicOptionMgr basicMgr_;
    private Database db_;
    public static final String NAME = "db.doc.option.mgr";
    public static final String DOC_TABLES = "doc.tables";
    public static final String DOC_DIAGRAMS = "doc.diagrams";
    public static final String DOC_FOREIGN_KEYS = "doc.fks";
    public static final String DOC_INDEXES = "doc.indexes";
    public static final String DOC_PROCS = "doc.procs";
    public static final String DOC_TRIGGERS = "doc.triggers";
    public static final String DOC_SCHEMAS = "doc.schemas";
    public static final String DOC_SEQUENCES = "doc.sequences";
    public static final String DOC_VIEWS = "doc.views";
    public static final String DOC_OVERWRITE_CSS = "doc.overwrite.css";

    public DbDocOptionMgr(Database db) {
        this.db_ = db;
        List defaultOptions = DbDocOptionMgr.getDefaultOptions();
        this.basicMgr_ = new BasicOptionMgr(NAME, defaultOptions);
    }

    public DbDocOptionMgr(Database db, List options) {
        this.db_ = db;
        this.basicMgr_ = new BasicOptionMgr(NAME, options);
    }

    private static List getDefaultOptions() {
        ArrayList<BooleanOption> options = new ArrayList<BooleanOption>();
        options.add(new BooleanOption(DOC_TABLES, true));
        options.add(new BooleanOption(DOC_SCHEMAS, true));
        options.add(new BooleanOption(DOC_DIAGRAMS, true));
        options.add(new BooleanOption(DOC_FOREIGN_KEYS, true));
        options.add(new BooleanOption(DOC_INDEXES, true));
        options.add(new BooleanOption(DOC_PROCS, true));
        options.add(new BooleanOption(DOC_TRIGGERS, true));
        options.add(new BooleanOption(DOC_SEQUENCES, true));
        options.add(new BooleanOption(DOC_VIEWS, true));
        options.add(new BooleanOption(DOC_OVERWRITE_CSS, true));
        return options;
    }

    public static String clazz() {
        return "DbDocOptionMgr";
    }

    @Override
    public Element asXmlElement() {
        Document doc = XmlHelper.getNewDocument();
        Element elmDbDoc = doc.createElement(DbDocOptionMgr.clazz());
        Element elmBasicOptMgr = this.basicMgr_.asXmlElement();
        XmlHelper.addForeignElement(doc, elmDbDoc, elmBasicOptMgr);
        return elmDbDoc;
    }

    public static DbDocOptionMgr fromXml(Element element, Database db) {
        Element elmBasicMgr = XmlHelper.getFirstElementByTagName(element, BasicOptionMgr.clazz());
        BasicOptionMgr basicMgr = BasicOptionMgr.fromXml(elmBasicMgr);
        List options = basicMgr.getAllOptions();
        for (BooleanOption defaultOpt : DbDocOptionMgr.getDefaultOptions()) {
            if (basicMgr.containsBoolOption(defaultOpt.getName())) continue;
            options.add(defaultOpt);
        }
        DbDocOptionMgr docOptionMgr = new DbDocOptionMgr(db, options);
        return docOptionMgr;
    }

    @Override
    public void addOption(IOption option) {
        this.basicMgr_.addOption(option);
    }

    @Override
    public boolean getBoolValue(String key) {
        return this.basicMgr_.getBoolValue(key);
    }

    @Override
    public String getTextValue(String key) {
        return this.basicMgr_.getTextValue(key);
    }

    @Override
    public int getIntValue(String key) {
        return this.basicMgr_.getIntValue(key);
    }

    @Override
    public IOption getOption(String mapName, String key) {
        return this.basicMgr_.getOption(mapName, key);
    }

    @Override
    public List getOptions(String mapName) {
        return this.basicMgr_.getOptions(mapName);
    }

    @Override
    public List getAllOptions() {
        return this.basicMgr_.getAllOptions();
    }

    @Override
    public List getAllOptionNames() {
        return this.basicMgr_.getAllOptionNames();
    }

    @Override
    public void setBoolValue(String key, boolean value) {
        this.basicMgr_.setBoolValue(key, value);
    }

    @Override
    public void setIntValue(String key, int value) {
        this.basicMgr_.setIntValue(key, value);
    }

    @Override
    public void setTextValue(String key, String value) {
        this.basicMgr_.setTextValue(key, value);
    }

    @Override
    public int size(String mapName) {
        return this.basicMgr_.size(mapName);
    }

    @Override
    public ImageIcon getIcon() {
        return this.basicMgr_.getIcon();
    }

    @Override
    public String getTitle() {
        return this.basicMgr_.getTitle();
    }

    @Override
    public String getToolTip() {
        return this.basicMgr_.getToolTip();
    }

    @Override
    public String getName() {
        return this.basicMgr_.getName();
    }

    @Override
    public void setName(String newName) {
        StrHelper.throwProgExcept(DbDocOptionMgr.clazz() + " does not implement setName().");
    }
}

