/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.doc;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.doc.IDocBldr;
import com.harrand.coreclasses.doc.IDocCtrl;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.dbwrench.doc.MiscDocBldr;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Index;
import com.harrand.dbwrench.object.Proc;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Sequence;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.object.Trigger;
import com.harrand.dbwrench.object.View;
import com.harrand.sketch.core.Diagram;
import com.harrand.util.FileHelper;
import com.harrand.util.HtmlHelper;
import com.harrand.util.XmlHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DatabaseDocBldr
implements IDocBldr {
    private Database db_;
    private File baseFolder_;
    private List items_ = new ArrayList();
    private HtmlHelper hh_;
    private IDocCtrl docCtrl_ = null;
    public static final String CSS_URL = "css/doc.css";
    public static final String FLAT_NM = "flat";

    public DatabaseDocBldr(Database db, File baseFolder) {
        this.db_ = db;
        this.baseFolder_ = baseFolder;
        this.hh_ = new HtmlHelper();
    }

    @Override
    public ITestResult writePages() {
        DataEntryResult result = new DataEntryResult(true);
        try {
            XmlHelper.writeElement(this.getIndexPage(), FileHelper.getFile(this.baseFolder_, "index.html"));
        }
        catch (Exception e) {
            result = new DataEntryResult(false, "Document Generation Error", e.getMessage());
        }
        return result;
    }

    @Override
    public void setDocCtrl(IDocCtrl docCtrl) {
        this.docCtrl_ = docCtrl;
    }

    private Element getIndexPage() {
        Document doc = HtmlHelper.getHtmlDoc(CSS_URL, this.db_.getName() + " " + "Documentation");
        this.hh_.setDoc(doc);
        Element elmBody = HtmlHelper.getBodyElement(doc);
        MiscDocBldr.addPageHeader(doc, 0, this.db_.getName());
        Element elmTable = doc.createElement("table");
        elmBody.appendChild(elmTable);
        elmTable.setAttribute("class", FLAT_NM);
        elmTable.appendChild(this.hh_.getBannerRow(this.db_.getName(), "Database"));
        String tdClass = "";
        ArrayList<String> items = new ArrayList<String>();
        items.add("Objects");
        items.add("Count");
        elmTable.appendChild(this.hh_.getRowElement(items, "header"));
        items.clear();
        this.addStatRow(elmTable, "Tables", Table.getClassName(), tdClass, "doc.tables");
        this.addStatRow(elmTable, "Diagrams", Diagram.getClassName(), tdClass, "doc.diagrams");
        this.addStatRow(elmTable, "Schemas", Schema.getClassName(), tdClass, "doc.schemas");
        this.addStatRow(elmTable, "Indexes", Index.getClassName(), tdClass, "doc.indexes");
        this.addStatRow(elmTable, "Foreign Keys", ForeignKey.getClassName(), tdClass, "doc.fks");
        this.addStatRow(elmTable, "Triggers", Trigger.getClassName(), tdClass, "doc.triggers");
        this.addStatRow(elmTable, "Procedures", Proc.getClassName(), tdClass, "doc.procs");
        this.addStatRow(elmTable, "Views", View.getClassName(), tdClass, "doc.views");
        this.addStatRow(elmTable, "Sequences", Sequence.getClassName(), tdClass, "doc.sequences");
        Date now = new Date();
        String timeStr = StrHelper.defaultDateTimeFormatter_.format(now);
        Element elmLine = XmlHelper.createElementSimple(doc, "p", "");
        Element elmBold = XmlHelper.createElementSimple(doc, "b", "Documented with DbWrench  ");
        Element elmTime = XmlHelper.createElementSimple(doc, "k", timeStr);
        elmBody.appendChild(XmlHelper.createElementSimple(doc, "br", ""));
        elmBody.appendChild(elmLine);
        elmLine.appendChild(elmBold);
        elmLine.appendChild(elmTime);
        return doc.getDocumentElement();
    }

    private void addStatRow(Element elmTable, String display, String mapName, String tdClass, String optionName) {
        boolean docEnabled = true;
        if (this.docCtrl_ != null) {
            IOptionMgr optionMgr = this.docCtrl_.getDocOptionMgr();
            docEnabled = optionMgr.getBoolValue(optionName);
        }
        if (docEnabled) {
            String folder = display.toLowerCase();
            if (mapName.equals(ForeignKey.getClassName())) {
                folder = "foreignKeys";
            }
            String url = folder + "/index.html";
            Element anchor = this.hh_.getAnchor(display, url, null);
            this.items_.clear();
            this.items_.add(anchor);
            int count = 0;
            count = mapName.equals(Trigger.getClassName()) ? Trigger.getTotalDbCount(this.db_) : (mapName.equals(Index.getClassName()) ? Index.getTotalDbCount(this.db_) : (mapName.equals(ForeignKey.getClassName()) ? this.db_.getFkUtil().getAllFks().size() : (mapName.equals(Table.getClassName()) ? this.db_.getAllTables().size() : (mapName.equals(Sequence.getClassName()) ? this.db_.getAllSeqs().size() : (mapName.equals(Proc.getClassName()) ? this.db_.getAllProcs().size() : (mapName.equals(View.getClassName()) ? this.db_.getAllViews().size() : (mapName.equals(Schema.getClassName()) ? this.db_.size(Schema.getClassName()) : this.db_.size(mapName))))))));
            this.items_.add(Integer.toString(count));
            Element elmRow = this.hh_.getRowElement(this.items_, tdClass);
            elmTable.appendChild(elmRow);
        }
    }

    @Override
    public boolean getDocEnabled() {
        return true;
    }
}

