/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.doc;

import com.harrand.coreclasses.doc.IDocCtrl;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.util.FileHelper;
import com.harrand.util.HtmlHelper;
import java.io.File;
import org.w3c.dom.Document;

public class BasicDocBldr {
    private IDocCtrl docCtrl_;
    private String optionName_;
    private File subFolder_;

    public BasicDocBldr(File baseFolder, String subFolderName, String optionName) {
        this.subFolder_ = FileHelper.getFile(baseFolder, subFolderName);
        this.optionName_ = optionName;
    }

    public IDocCtrl getDocCtrl() {
        return this.docCtrl_;
    }

    public void setDocCtrl(IDocCtrl docCtrl) {
        this.docCtrl_ = docCtrl;
    }

    public boolean getDocEnabled() {
        boolean enabled = true;
        if (this.optionName_ != null && this.docCtrl_ != null) {
            IOptionMgr optionMgr = this.docCtrl_.getDocOptionMgr();
            enabled = optionMgr.getBoolValue(this.optionName_);
        }
        return enabled;
    }

    public File getSubFolder() {
        return this.subFolder_;
    }

    public void clearSubFolder() {
        if (this.subFolder_.exists()) {
            File[] files = this.subFolder_.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                String fileNmLC = file.getName().toLowerCase();
                if (fileNmLC.indexOf(".html") > 0) {
                    file.delete();
                }
                if (fileNmLC.indexOf(".png") <= 0) continue;
                file.delete();
            }
        }
    }

    public void setMileStone(String str) {
        if (this.docCtrl_ != null) {
            this.docCtrl_.setMileStone(str);
        }
    }

    public void setMileStone(File file) {
        if (this.docCtrl_ != null) {
            this.docCtrl_.setWriteMileStone(file);
        }
    }

    public void setStatus(String status) {
        if (this.docCtrl_ != null) {
            this.docCtrl_.setStatus(status);
        }
    }

    public void setStatus(File file, String itemClass, int currentItem, int totalItems) {
        String msg = "Writing " + itemClass + " (" + currentItem + "/" + totalItems + "): " + file.getName() + "...";
        this.setStatus(msg);
    }

    public Document getHtmlDoc(String styleSheetRelPath, Collector collector, Identifiable idf) {
        String title = idf.getName() + " - " + collector.getDisplayName(idf.getMapName());
        return HtmlHelper.getHtmlDoc(styleSheetRelPath, title);
    }

    public Document getHtmlDoc(String styleSheetRelPath, Collector collector, String idfClassName) {
        String title = collector.getName() + " " + collector.getDisplayPlural(idfClassName);
        return HtmlHelper.getHtmlDoc(styleSheetRelPath, title);
    }
}

