/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.diagram.table;

import com.harrand.coregui.helper.GuiHelper;
import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.diagram.DbVerbosity;
import com.harrand.dbwrench.diagram.column.ColumnDiagramTextFormatter;
import com.harrand.dbwrench.diagram.table.TableTitleStringBldr;
import com.harrand.dbwrench.jdbc.IDataType;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Table;
import com.harrand.sketch.core.RenderConfig;
import com.harrand.sketch.glyph.calc.IconGlyphSizeCalc;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;

public class TableGlyphWidthCalc {
    private DbTableGlyph tableGlyph;
    private Table table;
    private final DbVerbosity vb;
    private double colNmMaxWidth;
    private IconGlyphSizeCalc iconGlyphSizeCalc = new IconGlyphSizeCalc();
    private int headerWidth;
    private double totalWidth;
    private TableTitleStringBldr tableTitleStrBldr = new TableTitleStringBldr();
    public static final int TEXT_SPACE = 5;
    public static final int EDGE_ICON_COUNT = 4;
    public static final int AFTER_COL_NM_ICON_COUNT = 2;

    public TableGlyphWidthCalc(DbTableGlyph tableGlyph) {
        this.tableGlyph = tableGlyph;
        this.vb = (DbVerbosity)this.getRenderConfig().getVerbosityConfig();
        this.table = tableGlyph.getTable();
    }

    public double getWidth() {
        this.doCalcs();
        return this.totalWidth;
    }

    public double getColNmMaxWidth() {
        this.doCalcs();
        return this.colNmMaxWidth;
    }

    private void doCalcs() {
        this.calcHeaderWidth();
        ArrayList<String> colNames = new ArrayList<String>();
        double maxDetailWidth = 0.0;
        for (Column column : this.getDisplayColumns()) {
            colNames.add(column.getName());
            double detailWidth = this.calcColumnDetailsWidth(column);
            maxDetailWidth = Math.max(detailWidth, maxDetailWidth);
        }
        this.colNmMaxWidth = (double)GuiHelper.getMaxStringWidth(this.getFont(), colNames) + this.getAfterNmIconSpace();
        this.totalWidth = this.colNmMaxWidth + maxDetailWidth + this.getEdgeIconSpace();
        if (!this.getDisplayColumns().isEmpty()) {
            this.totalWidth = Math.max((double)this.headerWidth, this.totalWidth);
        }
    }

    private void calcHeaderWidth() {
        int titleWidth = GuiHelper.getSwingStringLength(this.getTitleStr(), this.getRenderConfig().getHeaderFont());
        int tableHeaderIconCnt = 3;
        this.headerWidth = titleWidth + tableHeaderIconCnt * this.getIconSpace();
    }

    private double calcColumnDetailsWidth(Column column) {
        ColumnDiagramTextFormatter columnTextFormatter = new ColumnDiagramTextFormatter(column);
        StringBuilder sb = new StringBuilder();
        int phraseCount = 0;
        if (this.vb.getShowFlag(DbVerbosity.getKeyDataType())) {
            sb.append(this.getDataTypeText(column));
            ++phraseCount;
        }
        if (this.vb.getShowFlag(DbVerbosity.getKeySigned())) {
            sb.append(columnTextFormatter.getSignedText());
            ++phraseCount;
        }
        if (this.vb.getShowFlag(DbVerbosity.getKeyAutoNumber())) {
            sb.append(columnTextFormatter.getAutoNumberText());
            ++phraseCount;
        }
        if (this.vb.getShowFlag(DbVerbosity.getKeyDefault())) {
            sb.append(columnTextFormatter.getDefaultText());
            ++phraseCount;
        }
        if (this.vb.getShowFlag(DbVerbosity.getKeyComment())) {
            sb.append(columnTextFormatter.getCommentText());
            ++phraseCount;
        }
        String detailStr = sb.toString();
        int strWidth = GuiHelper.getSwingStringLength(detailStr, this.getFont());
        int totalSpace = phraseCount > 0 ? (phraseCount - 1) * 5 : 0;
        double totalWidthLocal = strWidth + totalSpace;
        return totalWidthLocal;
    }

    private String getDataTypeText(Column column) {
        ColumnDiagramTextFormatter columnTextFormatter = new ColumnDiagramTextFormatter(column);
        boolean showLengthFlag = this.vb.getShowFlag(DbVerbosity.getKeyLength());
        IDataType dataType = column.getDataType();
        boolean displayLength = showLengthFlag && dataType.isLengthUsed();
        StringBuilder sb = new StringBuilder();
        sb.append(column.getDataTypeDesc());
        if (displayLength) {
            sb.append(columnTextFormatter.getLengthScaleText());
        }
        sb.append(columnTextFormatter.getIsArrayText());
        String str = sb.toString();
        return str;
    }

    private String getTitleStr() {
        return this.tableTitleStrBldr.getTitleStr(this.table, this.vb);
    }

    private double getAfterNmIconSpace() {
        double iconsSpace = 2 * this.getIconSpace() + 2;
        return iconsSpace;
    }

    private double getEdgeIconSpace() {
        double iconsSpace = 4 * this.getIconSpace() + 8;
        return iconsSpace;
    }

    private int getIconSpace() {
        return this.iconGlyphSizeCalc.getIconSpace(this.getRenderConfig().getScaleFactor());
    }

    private Font getFont() {
        return this.getRenderConfig().getFont();
    }

    private RenderConfig getRenderConfig() {
        return this.tableGlyph.getRenderConfig();
    }

    private List<Column> getDisplayColumns() {
        return this.tableGlyph.getDisplayColumns();
    }
}

