/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.diagram.column;

import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.diagram.DbTableTextBuilder;
import com.harrand.dbwrench.object.Column;
import com.harrand.sketch.core.GlyphTextLine;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public final class ColumnTextLineStore {
    private final Column column;
    private List<GlyphTextLine> textLines;
    private final DbTableTextBuilder tableTextBldr;
    private Point2D start;

    public ColumnTextLineStore(DbTableGlyph tableGlyph, Column column) {
        this.column = column;
        this.tableTextBldr = new DbTableTextBuilder(tableGlyph);
    }

    public List<GlyphTextLine> getColumnGlyphTexts(Column inColumn, Point2D start) {
        if (this.getNeedsRefresh(inColumn)) {
            this.start = start;
            this.refresh();
        }
        return this.textLines;
    }

    public String getColumnNm() {
        return this.column.getName();
    }

    private void refresh() {
        this.buildTextLines();
        this.populateArray();
    }

    private void populateArray() {
        this.textLines.clear();
        this.addIfNotNull(this.tableTextBldr.getAutonumberTextLine());
        this.addIfNotNull(this.tableTextBldr.getColumnDefaultTextLine());
        this.addIfNotNull(this.tableTextBldr.getColumnNmTextLine());
        this.addIfNotNull(this.tableTextBldr.getDataTypeTextLine());
        this.addIfNotNull(this.tableTextBldr.getEndBracketLine());
        this.addIfNotNull(this.tableTextBldr.getIsArrayTextLine());
        this.addIfNotNull(this.tableTextBldr.getLengthTextLine());
        this.addIfNotNull(this.tableTextBldr.getScaleTextLine());
        this.addIfNotNull(this.tableTextBldr.getSignedTextLine());
        this.addIfNotNull(this.tableTextBldr.getSpacerTextLine());
        this.addIfNotNull(this.tableTextBldr.getStartBracketLine());
        this.addIfNotNull(this.tableTextBldr.getCommaTextLine());
        this.addIfNotNull(this.tableTextBldr.getCommentTextLine());
    }

    private void addIfNotNull(GlyphTextLine textLine) {
        if (textLine != null) {
            this.textLines.add(textLine);
        }
    }

    private boolean getNeedsRefresh(Column inColumn) {
        boolean notInit;
        boolean bl = notInit = this.textLines == null;
        if (notInit) {
            this.textLines = new ArrayList<GlyphTextLine>();
        }
        boolean columnChanged = !inColumn.equals(this.column);
        boolean needsRefresh = notInit || columnChanged;
        return needsRefresh;
    }

    private void buildTextLines() {
        this.tableTextBldr.buildColumnGlyphTexts(this.column, this.start);
    }
}

