/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.diagram.bldr;

import com.harrand.coregui.display.status.IStatusDisplayer;
import com.harrand.coregui.jdesktop.swingworker.IThreadObserver;
import com.harrand.coregui.jdesktop.swingworker.SwingWorker;
import com.harrand.dbwrench.diagram.bldr.DbTableLayoutDisp;
import com.harrand.dbwrench.diagram.bldr.DefaultDbwDiagramBldr;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchgui.db.worker.helper.DbWorkerUpdateHelper;
import com.harrand.sketch.core.Diagram;
import java.awt.Point;
import java.util.List;
import javax.swing.JButton;

public final class DiagramBldrWorker
extends SwingWorker<Void, Void> {
    private Database db;
    private DefaultDbwDiagramBldr diagramBldr = new DefaultDbwDiagramBldr();
    private IThreadObserver threadObserver;
    private DbWorkerUpdateHelper updateHelper = new DbWorkerUpdateHelper();
    public static final String CREATING_DIAGRAMS_STR = "Creating Diagrams...";
    public static final String CREATING_DIAGRAM_STR = "Creating Diagram: ";
    public static final int LOTS_OF_TABLES = 40;
    public static final Point TOP_LEFT_ORIGIN = new Point(50, 50);

    public void createDiagrams(Database db, IThreadObserver threadObserver) {
        this.db = db;
        this.threadObserver = threadObserver;
        try {
            this.execute();
        }
        catch (Exception ex) {
            this.updateHelper.handleExecuteException(ex, this.getClass().getName());
        }
    }

    public Database getDb() {
        return this.db;
    }

    public void setDisabledButton(JButton btn) {
        this.updateHelper.setDisabledBtn(btn);
    }

    public void setStatusDisplayer(IStatusDisplayer statusDisplayer) {
        this.updateHelper.setSvrStatusDisplayer(statusDisplayer);
    }

    @Override
    protected Void doInBackground() throws Exception {
        this.updateHelper.setStatusMsg(CREATING_DIAGRAMS_STR);
        this.updateHelper.startAnimation();
        this.createDiagramDisp();
        return null;
    }

    @Override
    protected void done() {
        super.done();
        this.updateHelper.displayReady();
        this.updateHelper.stopAnimation();
        this.threadObserver.threadDone(this);
    }

    private void createDiagramDisp() {
        this.db = this.db;
        if (this.getBuildManyDiagrams()) {
            this.addDiagramPerSchema();
        } else {
            this.addDefaultDiagram();
        }
    }

    private void addDiagramPerSchema() {
        int i = 0;
        int total = this.db.getSchemaCount();
        for (Schema sch : this.db.getSchemas()) {
            List<Table> tables = sch.getTables();
            String diaNm = sch.getName();
            this.updateStatus(++i, total, diaNm);
            this.createDiagram(tables, diaNm);
        }
    }

    private void addDefaultDiagram() {
        List<Table> tables = this.db.getAllTablesGen();
        String diaNm = "diagramA";
        this.updateStatus(1, 1, diaNm);
        this.createDiagram(tables, diaNm);
    }

    private boolean getBuildManyDiagrams() {
        int schCount = this.db.size(Schema.getClassName());
        boolean hasManySchemas = schCount > 1;
        int tblCount = this.db.getAllTables().size();
        boolean hasLotsOfTables = tblCount > 40;
        return hasManySchemas && hasLotsOfTables;
    }

    private void createDiagram(List<Table> tables, String diaNm) {
        Diagram diagram = this.diagramBldr.createDiagram(this.db, diaNm);
        this.db.add(diagram);
        this.layoutGlyphs(tables, diagram);
    }

    private void layoutGlyphs(List<Table> tables, Diagram diagram) {
        new DbTableLayoutDisp().layoutTables(diagram, tables);
    }

    private void updateStatus(int i, int total, String diaNm) {
        String iOfTotalStr = "(" + i + "/" + total + ")";
        String msg = CREATING_DIAGRAM_STR + diaNm + " " + iOfTotalStr;
        this.updateHelper.setStatusMsg(msg);
    }
}

