/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.diagram.bldr;

import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.dbwrench.diagram.DbVerbosity;
import com.harrand.dbwrench.diagram.KeyToKeyStrategy;
import com.harrand.dbwrench.diagram.relation.notation.erNotation.DbwErNotationFactory;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.RenderConfig;
import com.harrand.sketch.core.VerbosityConfig;
import com.harrand.sketch.linkStrategies.LinkStrategy;
import com.harrand.sketch.linkStrategies.OffsetDirect;
import com.harrand.sketch.linkStrategies.right_angle.RightAngleStrategy;
import com.harrand.sketch.relation.notation.erNotation.IErNotation;
import com.harrand.sketch.xml.DiagramProps;
import java.awt.Font;
import java.util.ArrayList;

public class DefaultDbwDiagramBldr {
    public static final String DEFAULT_DIA_NM = "diagramA";

    public Diagram createDefaultDiagram(Database db) {
        return this.createDiagram(db, DEFAULT_DIA_NM);
    }

    public Diagram createDiagram(Database db, String name) {
        DbUser user = App.getUser();
        LinkStrategy strategy = new RightAngleStrategy();
        int fontSize = 11;
        boolean showFkNms = true;
        if (user != null) {
            IOptionMgr diagramOptMgr = user.getOptionMgr("diagram.option.mgr");
            int strategyId = diagramOptMgr.getIntValue("diagram.default.strategy");
            if (strategyId == 2) {
                strategy = new KeyToKeyStrategy(db);
            }
            if (strategyId == 3) {
                strategy = new RightAngleStrategy();
            }
            if (strategyId == 0) {
                strategy = new OffsetDirect();
            }
            fontSize = diagramOptMgr.getIntValue("diagram.default.font.size");
            showFkNms = diagramOptMgr.getBoolValue("diagram.show.fk.nms");
        }
        Font newFont = new Font("Verdana", 0, fontSize);
        DbVerbosity dbVerbosity = new DbVerbosity();
        RenderConfig rc = new RenderConfig(1.0, strategy, (VerbosityConfig)dbVerbosity);
        rc.setFont(newFont);
        Diagram diagram = new Diagram(name, rc, new ArrayList());
        DiagramProps props = diagram.getDiagramProps();
        props.setErNotation(this.getErNotation());
        props.setShowFkNames(showFkNms);
        return diagram;
    }

    private IErNotation getErNotation() {
        return DbwErNotationFactory.getInstance().getBestGuessNotation();
    }
}

