/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.diagram.autoLayout;

import com.harrand.dbwrench.diagram.autoLayout.TableFkInfo;
import com.harrand.dbwrench.object.Table;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LonerSorter {
    private int vGap_ = 15;
    private int hGap_ = 60;

    public Map getTablePositions(List lonerInfos, Point origin, int preferredHeight) {
        ArrayList dupLonerInfos = new ArrayList(lonerInfos);
        Collections.sort(dupLonerInfos);
        int vertCursor = origin.y;
        int horzCursor = origin.x;
        int maxWidth = 0;
        int yCutoff = origin.y + preferredHeight;
        HashMap<String, Point> tablePositions = new HashMap<String, Point>();
        for (TableFkInfo info : dupLonerInfos) {
            int tableHeight = info.getBounds().height;
            Point tablePos = new Point(horzCursor, vertCursor);
            tablePositions.put(info.getName(), tablePos);
            maxWidth = Math.max(maxWidth, info.getBounds().width);
            if ((vertCursor += tableHeight + this.vGap_) < yCutoff) continue;
            horzCursor += maxWidth + this.hGap_;
            vertCursor = origin.y;
        }
        return tablePositions;
    }

    public Map<Table, Point> getTablePositionsBox(List lonerInfos, Point origin) {
        ArrayList dupLonerInfos = new ArrayList(lonerInfos);
        int infoCount = dupLonerInfos.size();
        Collections.sort(dupLonerInfos);
        int sideCount = this.getBoxSideCount(dupLonerInfos);
        int[] colWidths = this.getColWidths(sideCount, dupLonerInfos);
        int[] rowHeights = this.getRowHeights(sideCount, dupLonerInfos);
        boolean column = false;
        boolean maxWidth = false;
        HashMap<Table, Point> tablePositions = new HashMap<Table, Point>();
        int horzCursor = origin.x;
        int vertCursor = origin.y;
        for (int r = 0; r < sideCount; ++r) {
            for (int c = 0; c < sideCount; ++c) {
                int pos = r * sideCount + c;
                if (pos < infoCount) {
                    TableFkInfo info = (TableFkInfo)dupLonerInfos.get(pos);
                    Point tablePt = new Point(horzCursor, vertCursor);
                    tablePositions.put(info.getTable(), tablePt);
                }
                horzCursor += colWidths[c] + this.hGap_;
            }
            horzCursor = origin.x;
            vertCursor += rowHeights[r] + this.vGap_;
        }
        return tablePositions;
    }

    private int getBoxSideCount(List infos) {
        int sqrtInt;
        double sqrt = Math.sqrt(infos.size());
        int sideCount = sqrt > (double)(sqrtInt = (int)sqrt) ? sqrtInt + 1 : sqrtInt;
        return sideCount;
    }

    private int[] getColWidths(int sideCount, List infos) {
        int infoCount = infos.size();
        int[] colWidths = new int[sideCount];
        for (int col = 0; col < sideCount; ++col) {
            int maxWidth = 0;
            for (int row = 0; row < sideCount; ++row) {
                int pos = row * sideCount + col;
                if (pos >= infoCount) continue;
                TableFkInfo info = (TableFkInfo)infos.get(pos);
                maxWidth = Math.max(maxWidth, info.getBounds().width);
            }
            colWidths[col] = maxWidth;
        }
        return colWidths;
    }

    private int[] getRowHeights(int sideCount, List infos) {
        int infoCount = infos.size();
        int[] rowHeights = new int[sideCount];
        for (int row = 0; row < sideCount; ++row) {
            int maxHeight = 0;
            for (int col = 0; col < sideCount; ++col) {
                int pos = row * sideCount + col;
                if (pos >= infoCount) continue;
                TableFkInfo info = (TableFkInfo)infos.get(pos);
                int ht = info.getBounds().height;
                maxHeight = Math.max(maxHeight, ht);
            }
            rowHeights[row] = maxHeight;
        }
        return rowHeights;
    }
}

