/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.diagram.autoLayout;

import com.harrand.dbwrench.diagram.autoLayout.TableBranch;
import com.harrand.dbwrench.diagram.autoLayout.TableCluster;
import com.harrand.dbwrench.diagram.autoLayout.TableFkInfo;
import java.util.ArrayList;
import java.util.List;

public class BranchBldr {
    private TableCluster cluster_;
    private List tableNmsNotPlaced_;
    private List branchQueue_ = new ArrayList();
    private boolean fkNmsShownFlag;

    public void setFkNmsShownFlag(boolean fkNmsShownFlag) {
        this.fkNmsShownFlag = fkNmsShownFlag;
    }

    public TableBranch getRootBranch(TableCluster cluster) {
        this.cluster_ = cluster;
        this.tableNmsNotPlaced_ = this.cluster_.getTableNms();
        int depth = 0;
        TableFkInfo rootInfo = this.cluster_.getRootTableFkInfo();
        TableBranch rootBranch = new TableBranch(rootInfo, null, null, depth);
        rootBranch.setFkNmsShownFlag(this.fkNmsShownFlag);
        this.branchQueue_.add(rootBranch);
        this.beenPlaced(rootBranch.getName());
        while (this.branchQueue_.size() > 0) {
            TableBranch branch = (TableBranch)this.branchQueue_.get(0);
            depth = branch.getDepth();
            TableFkInfo tableFkInfo = branch.getTableFkInfo();
            List allTblNms = tableFkInfo.getConnectedTblDotNotes();
            ArrayList usableTblNms = new ArrayList(allTblNms);
            usableTblNms.retainAll(this.tableNmsNotPlaced_);
            ArrayList conflictedNms = new ArrayList(allTblNms);
            conflictedNms.removeAll(this.tableNmsNotPlaced_);
            branch.addConflictedTblNms(conflictedNms);
            this.addLeaves(branch, usableTblNms);
            this.addSubBranches(branch, usableTblNms, depth + 1);
            this.branchQueue_.remove(0);
        }
        return rootBranch;
    }

    private void beenPlaced(String tableNm) {
        this.tableNmsNotPlaced_.remove(tableNm);
    }

    private void addLeaves(TableBranch branch, List relatedTblNms) {
        for (String tblNm : relatedTblNms) {
            TableFkInfo tableFkInfo = this.cluster_.getTableFkInfo(tblNm);
            if (!tableFkInfo.isLeaf()) continue;
            tableFkInfo.setDirection(branch.getDirection());
            branch.addLeaf(tableFkInfo);
            this.beenPlaced(tblNm);
        }
    }

    private void addSubBranches(TableBranch branch, List relatedTblNms, int subDepth) {
        for (String tblNm : relatedTblNms) {
            TableFkInfo tableFkInfo = this.cluster_.getTableFkInfo(tblNm);
            if (!tableFkInfo.isBranchTable() || branch.getSubBranchNms().contains(tblNm)) continue;
            String srcColumnNm = branch.getSubsSrcColumnNm(tblNm);
            TableBranch subBranch = new TableBranch(tableFkInfo, branch.getName(), srcColumnNm, subDepth);
            subBranch.setFkNmsShownFlag(this.fkNmsShownFlag);
            branch.addSubBranch(subBranch);
            this.beenPlaced(tblNm);
            this.branchQueue_.add(subBranch);
        }
    }
}

