/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.diagram.autoLayout;

import com.harrand.dbwrench.diagram.autoLayout.AffinityStrength;
import com.harrand.dbwrench.diagram.autoLayout.TableBranch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BranchAffinity
implements Comparable {
    private TableBranch branch_;
    private List peerBranches_;
    private List directLinkNms_;
    private List subBranchLinkNms_;

    public BranchAffinity(TableBranch branch, List allPeerBranches) {
        this.branch_ = branch;
        this.peerBranches_ = new ArrayList(allPeerBranches);
        this.peerBranches_.remove(this.branch_);
        this.buildDirectLinks();
        this.buildSubBranchLinks();
    }

    public int compareTo(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (!(obj instanceof BranchAffinity)) {
            return 0;
        }
        BranchAffinity other = (BranchAffinity)obj;
        int otherDirectLinkCount = other.getDirectLinkNms().size();
        if (this.getDirectLinkNms().size() > otherDirectLinkCount) {
            return 1;
        }
        if (this.getDirectLinkNms().size() < otherDirectLinkCount) {
            return -1;
        }
        Integer otherSubBranchInt = new Integer(other.getSubBranchLinkNms().size());
        Integer subBranchInt = new Integer(this.getSubBranchLinkNms().size());
        return subBranchInt.compareTo(otherSubBranchInt);
    }

    public AffinityStrength getNeighborStrength(List availableBranchNms) {
        List directNms = this.getDirectLinkNms();
        directNms.retainAll(availableBranchNms);
        List subBranchNms = this.getSubBranchLinkNms();
        subBranchNms.retainAll(availableBranchNms);
        ArrayList bothNms = new ArrayList(directNms);
        bothNms.retainAll(subBranchNms);
        AffinityStrength strength = null;
        if (!bothNms.isEmpty()) {
            strength = new AffinityStrength(this.getName(), (String)bothNms.get(0), 3);
        } else if (!directNms.isEmpty()) {
            strength = new AffinityStrength(this.getName(), (String)directNms.get(0), 2);
        } else if (!subBranchNms.isEmpty()) {
            strength = new AffinityStrength(this.getName(), (String)subBranchNms.get(0), 1);
        } else {
            ArrayList localAvailable = new ArrayList(availableBranchNms);
            Collections.sort(localAvailable);
            strength = new AffinityStrength(this.getName(), (String)localAvailable.get(0), 0);
        }
        return strength;
    }

    public String getName() {
        return this.branch_.getName();
    }

    public List getDirectLinkNms() {
        return new ArrayList(this.directLinkNms_);
    }

    public List getSubBranchLinkNms() {
        return new ArrayList(this.subBranchLinkNms_);
    }

    private void buildDirectLinks() {
        this.directLinkNms_ = new ArrayList();
        for (TableBranch peerBranch : this.peerBranches_) {
            if (!peerBranch.getConflictedTblNms().contains(this.getName())) continue;
            this.directLinkNms_.add(peerBranch.getName());
        }
    }

    private void buildSubBranchLinks() {
        this.subBranchLinkNms_ = new ArrayList();
        ArrayList subBranchNms = new ArrayList(this.branch_.getSubBranchNms());
        for (TableBranch peerBranch : this.peerBranches_) {
            List peerConflicts = peerBranch.getSubBranchConflictNms();
            peerConflicts.retainAll(subBranchNms);
            if (peerConflicts.isEmpty()) continue;
            this.subBranchLinkNms_.add(peerBranch.getName());
        }
    }
}

