/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.diagram;

import com.harrand.coreclasses.display.IFontDependent;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.list.NamedList;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.dbwrench.diagram.FkRightAngleLinkCtrl;
import com.harrand.dbwrench.diagram.ForeignKeyGlyph;
import com.harrand.dbwrench.diagram.RightAngleLinesCtrl;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Table;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Link;
import com.harrand.sketch.core.RenderConfig;
import com.harrand.sketch.linkStrategies.LinkStrategy;
import com.harrand.sketch.relation.joint.JointDimensionCalc;
import com.harrand.util.LogUtil;
import com.harrand.util.XmlHelper;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KeyToKeyStrategy
implements LinkStrategy,
IFontDependent {
    private Database db_;
    private Font font_ = null;
    private double headerHeight_ = 0.0;
    private double standardRowHeight_ = 0.0;
    private double separatorHeight_ = 0.0;
    private double scaleFactor_ = 1.0;
    private JointDimensionCalc jntDimCalc = new JointDimensionCalc(this.scaleFactor_);
    public static final String XML_NM = "KeyToKeyStrategy";
    public static final String DISPLAY_NM = "Primary Key to Foreign Key Column";
    public static final int STRATEGY_ID = 2;

    public KeyToKeyStrategy(Database db) {
        this.db_ = db;
    }

    @Override
    public NamedList updateLinks(NamedList links) {
        RightAngleLinesCtrl lineCalcCtrl = new RightAngleLinesCtrl();
        this.setJointDimensions(lineCalcCtrl);
        ArrayList<Object> chdTbls = new ArrayList<Object>();
        HashMap<String, FkRightAngleLinkCtrl> linkCtrlsMap = new HashMap<String, FkRightAngleLinkCtrl>();
        Iterator it = links.iterator();
        while (it.hasNext()) {
            ForeignKeyGlyph link = (ForeignKeyGlyph)it.next();
            FkRightAngleLinkCtrl linkCtrl = new FkRightAngleLinkCtrl(this.db_, link);
            this.setHeights(linkCtrl);
            linkCtrl.refreshCalcs();
            this.moveJoints(link, linkCtrl);
            this.rotateJoints(link, linkCtrl);
            linkCtrlsMap.put(linkCtrl.getName(), linkCtrl);
            Table chdTable = link.getForeignKey().getChdTbl();
            chdTbls.add(chdTable);
        }
        HashMap linkLinesMap = new HashMap();
        ArrayList<String> chdTblsDoneDotNotes = new ArrayList<String>();
        for (Table table : chdTbls) {
            String chdTblDotNotes = table.getDotNote();
            if (chdTblsDoneDotNotes.contains(chdTblDotNotes)) continue;
            Map tblLinkLinesMap = lineCalcCtrl.getLinkLines(links, linkCtrlsMap, table);
            linkLinesMap.putAll(tblLinkLinesMap);
            chdTblsDoneDotNotes.add(chdTblDotNotes);
        }
        Iterator itLinksB = links.iterator();
        while (itLinksB.hasNext()) {
            ForeignKeyGlyph foreignKeyGlyph = (ForeignKeyGlyph)itLinksB.next();
            List linesList = (List)linkLinesMap.get(foreignKeyGlyph.getName());
            if (linesList != null) {
                foreignKeyGlyph.setShapes(linesList);
                continue;
            }
            LogUtil.logErr("KeyToKeyStrat.lines not found for:" + foreignKeyGlyph.getName());
            LogUtil.logErr("Valid maps keys for lines are: " + StrHelper.getCsvList(new ArrayList(linkLinesMap.keySet())));
        }
        return links;
    }

    @Override
    public boolean getAreLinksMovable() {
        return false;
    }

    private void moveJoints(Link link, FkRightAngleLinkCtrl ctrl) {
        Point2D.Double ptChild = new Point2D.Double(ctrl.getChildX(), ctrl.getChildY());
        Point2D.Double ptParent = new Point2D.Double(ctrl.getParentX(), ctrl.getParentY());
        link.moveJoint(link.getChildJointName(), ptChild);
        link.moveJoint(link.getParentJointName(), ptParent);
    }

    private void rotateJoints(Link link, FkRightAngleLinkCtrl ctrl) {
        link.rotateJoint(link.getChildJointName(), this.getRotateAngle(ctrl.getChildEdge()));
        link.rotateJoint(link.getParentJointName(), this.getRotateAngle(ctrl.getParentEdge()));
    }

    private double getRotateAngle(int edge) {
        double angle = edge == 3 ? 180.0 : 0.0;
        return angle;
    }

    private void setJointDimensions(RightAngleLinesCtrl lineCalcCtrl) {
        lineCalcCtrl.setJointHeight(this.jntDimCalc.getHeight());
        lineCalcCtrl.setJointLength(this.jntDimCalc.getLength());
        lineCalcCtrl.setParallelGap(10.0 * this.scaleFactor_);
    }

    private void setHeights(FkRightAngleLinkCtrl linkCtrl) {
        linkCtrl.setHeaderHeight(this.headerHeight_);
        linkCtrl.setStandardRowHeight(this.standardRowHeight_);
        linkCtrl.setSeparatorHeight(this.separatorHeight_);
        linkCtrl.refreshCalcs();
    }

    @Override
    public void setFont(Font font) {
        this.font_ = font;
        int vertStep = GuiHelper.getFontLineHeight(font);
        this.headerHeight_ = this.standardRowHeight_ = (double)vertStep;
        this.separatorHeight_ = 0.3 * this.standardRowHeight_;
        this.scaleFactor_ = RenderConfig.calcScaleFactor(font);
        this.jntDimCalc.setFontScaleFactor(this.scaleFactor_);
    }

    @Override
    public Font getFont() {
        return this.font_;
    }

    @Override
    public String getName() {
        return XML_NM;
    }

    @Override
    public int getStrategyId() {
        return 2;
    }

    @Override
    public Element asXmlElement() {
        Document doc = XmlHelper.getNewDocument();
        Element element = XmlHelper.createElementSimple(doc, "LinkStrategy", this.getName());
        return element;
    }

    @Override
    public void setDiagram(Diagram diagram) {
    }

    @Override
    public Diagram getDiagram() {
        return null;
    }
}

