/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.diagram;

import com.harrand.coreclasses.display.IColorable;
import com.harrand.coreclasses.geometry.positioningCoord.IPositioningCoord;
import com.harrand.coreclasses.interfaces.INamed;
import com.harrand.coreclasses.interfaces.IRefreshable;
import com.harrand.coreclasses.list.NamedList;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.notification.dirty.IDirtyTrackable;
import com.harrand.coreclasses.notification.dirty.IDirtyTracker;
import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.coregui.mouse.IRollOverable;
import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.diagram.fk.FkNameDrawer;
import com.harrand.dbwrench.diagram.hilight.FkGlyphHilighter;
import com.harrand.dbwrench.diagram.hilight.color.IColorScheme;
import com.harrand.dbwrench.diagram.relation.notation.erNotation.DbwErNotationFactory;
import com.harrand.dbwrench.diagram.table.extract.GlyphByTableExtractor;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.core.IJoint;
import com.harrand.sketch.core.IRawLineSource;
import com.harrand.sketch.core.Link;
import com.harrand.sketch.core.link.joint.IJointBackboneLengthSource;
import com.harrand.sketch.glyph.interfaces.IDetailableGlyph;
import com.harrand.sketch.interfaces.IHilightableGlyph;
import com.harrand.sketch.interfaces.IObjGlyph;
import com.harrand.sketch.j2d.EnhancedShape;
import com.harrand.sketch.j2d.draw.IDrawable;
import com.harrand.sketch.linkStrategies.LinkStrategy;
import com.harrand.sketch.linkStrategies.positioner.ILinkPositioner;
import com.harrand.sketch.linkStrategies.right_angle.positioner.user.LinkLineExtractor;
import com.harrand.sketch.linkStrategies.rollover.ISingleLinkLinePossible;
import com.harrand.sketch.relation.edge.Edge;
import com.harrand.sketch.relation.edge.IEdgeTrackable;
import com.harrand.sketch.relation.glyph.JointGlyph;
import com.harrand.sketch.relation.joint.JointDimensionCalc;
import com.harrand.sketch.relation.line.LineCloseByCtrl;
import com.harrand.sketch.relation.line.LineTrackable;
import com.harrand.sketch.relation.line.PositionableLine;
import com.harrand.sketch.relation.notation.erNotation.IErNotation;
import com.harrand.sketch.relation.primitive.JointPrimitiveCalc;
import com.harrand.sketch.relation.rect.LinkRect;
import com.harrand.sketch.support.DrawableUtil;
import com.harrand.util.LogUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public final class ForeignKeyGlyph
implements Glyph,
Link,
IHilightableGlyph,
IColorable,
IObservable,
IDirtyTrackable,
INamed,
IObjGlyph,
IDrawable,
IRollOverable,
IRefreshable,
IDetailableGlyph,
LineTrackable,
IRawLineSource,
IEdgeTrackable,
ISingleLinkLinePossible,
IJointBackboneLengthSource {
    public static final String CHILD_JOINT_NM = "ChildJoint";
    public static final String PARENT_JOINT_NM = "ParentJoint";
    private boolean selected_;
    private ForeignKey fk_;
    private final Diagram diagram;
    private Color strokeColor = Color.BLACK;
    private final BasicObservable observable_ = new BasicObservable();
    private IDirtyTracker dirtyTracker_;
    private List<EnhancedShape> enhancedShapes = new ArrayList<EnhancedShape>();
    private List<? extends Shape> shapes = new ArrayList<Shape>();
    private final List<Line2D> rawLines = new ArrayList<Line2D>();
    private Glyph parentGlyph_;
    private Glyph childGlyph_;
    private final List<EnhancedShape> enhancedConnectors = new ArrayList<EnhancedShape>();
    private final List<EnhancedShape> unusedEnhancedConnectors = new ArrayList<EnhancedShape>();
    private TreeMap<String, JointGlyph> joints_ = new TreeMap();
    private FkGlyphHilighter hilighter_;
    private FkNameDrawer nmDrawer;
    private Edge childEdge;
    private Edge parentEdge;
    private boolean isMouseOver = false;
    private boolean isUserPositioned;
    private boolean isSingleLinkLinePossible;
    private ILinkPositioner linkPositioner;
    private final LineCloseByCtrl closeByCtrl = new LineCloseByCtrl(14);
    public static final String XML_PLURAL = "ForeignKeyGlyphs";
    public static final String XML_NAME = "Name";
    public static final String BACK_COLOR = "BackColor";
    public static final int DISTANCE_OK = 14;

    public ForeignKeyGlyph(ForeignKey fk, Diagram diagram, Color strokeColor) {
        this.fk_ = fk;
        this.diagram = diagram;
        this.strokeColor = strokeColor;
        this.updateJoints();
    }

    @Override
    public void setBoxes(NamedList glyphs) {
        GlyphByTableExtractor extractor = new GlyphByTableExtractor();
        this.parentGlyph_ = (Glyph)((Object)extractor.getGlyphByTable(glyphs.asList(), this.fk_.getParTbl()));
        this.childGlyph_ = (Glyph)((Object)extractor.getGlyphByTable(glyphs.asList(), this.fk_.getChdTbl()));
        if (this.childGlyph_ == null) {
            LogUtil.logErr("FkGlyph.childGlyphNull: " + this.fk_.getChdTbl().getDotNote());
        }
        this.buildEnhancedShapes();
    }

    public void updateJoints() {
        this.joints_ = new TreeMap();
        String parentTableName = this.fk_.getParTbl().getName();
        String childTableName = this.fk_.getChdTbl().getName();
        JointDimensionCalc jntDimCalc = this.diagram.getJointDimensionCalc();
        JointPrimitiveCalc jntPrimitiveCalcPar = new JointPrimitiveCalc(new Point2D.Double(0.0, 0.0), 0.0, jntDimCalc);
        JointPrimitiveCalc jntPrimitiveCalcChd = new JointPrimitiveCalc(new Point2D.Double(0.0, 0.0), 0.0, jntDimCalc);
        LinkStrategy linkStrategy = this.diagram.getRenderConfig().getLinkStrategy();
        boolean isSelfJoin = this.fk_.getIsSelfJoin();
        JointGlyph jntParent = new JointGlyph(this.getErNotation(), jntPrimitiveCalcPar, this.fk_.getParentCardinality(), this.strokeColor, parentTableName, this.getForeignKeyName(), linkStrategy, isSelfJoin);
        this.joints_.put(this.getParentJointName(), jntParent);
        JointGlyph jntChild = new JointGlyph(this.getErNotation(), jntPrimitiveCalcChd, this.fk_.getChildCardinality(), this.strokeColor, childTableName, this.getForeignKeyName(), linkStrategy, isSelfJoin);
        this.joints_.put(this.getChildJointName(), jntChild);
    }

    private IErNotation getErNotation() {
        if (this.diagram != null) {
            return this.diagram.getDiagramProps().getErNotation();
        }
        return DbwErNotationFactory.getInstance().getDefaultNotation();
    }

    public ForeignKey getFk() {
        return this.fk_;
    }

    public void setFk(ForeignKey fk) {
        this.fk_ = fk;
    }

    public static String getClassName() {
        return "ForiegnKeyGlyph";
    }

    public ForeignKey getForeignKey() {
        return this.fk_;
    }

    public String getForeignKeyName() {
        return this.fk_.getName();
    }

    public String getObjectName() {
        return this.getForeignKeyName();
    }

    @Override
    public String getChildJointName() {
        return CHILD_JOINT_NM;
    }

    @Override
    public String getParentJointName() {
        return PARENT_JOINT_NM;
    }

    @Override
    public String getChildBoxName() {
        return "Child";
    }

    @Override
    public String getParentBoxName() {
        return "Parent";
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public Object getGlyphObject() {
        return this.getForeignKey();
    }

    @Override
    public boolean contains(Point2D p) {
        boolean found = false;
        Iterator<JointGlyph> it = this.joints_.values().iterator();
        while (it.hasNext() && !found) {
            found = ((Glyph)it.next()).contains(p);
        }
        if (!found) {
            found = this.isCloseBy(p);
        }
        if (this.isNamedDrawerSet() && !found) {
            found = this.nmDrawer.contains(p);
        }
        return found;
    }

    @Override
    public boolean contains(double x, double y) {
        return this.contains(new Point2D.Double(x, y));
    }

    @Override
    public Rectangle2D getBounds2D() {
        Rectangle2D rectChild = this.getJoint(this.getChildJointName()).getBounds2D();
        Rectangle2D rectParent = this.getJoint(this.getParentJointName()).getBounds2D();
        double minX = Math.min(rectChild.getMinX(), rectParent.getMinX());
        double minY = Math.min(rectChild.getMinY(), rectParent.getMinY());
        double maxX = Math.max(rectChild.getMaxX(), rectParent.getMaxX());
        double maxY = Math.max(rectChild.getMaxY(), rectParent.getMaxY());
        return new Rectangle2D.Double(minX, minY, maxX - minX, maxY - minY);
    }

    @Override
    public LinkRect getBox(String key) {
        Rectangle2D box = key.equals("Child") ? this.childGlyph_.getBounds2D() : this.parentGlyph_.getBounds2D();
        return new LinkRect(box, key);
    }

    public Glyph getParentGlyph() {
        return this.parentGlyph_;
    }

    public Glyph getChildGlyph() {
        return this.childGlyph_;
    }

    @Override
    public IJoint getJoint(String key) {
        return this.joints_.get(key);
    }

    @Override
    public boolean getIsSelfJoin() {
        return this.fk_.getIsSelfJoin();
    }

    @Override
    public String getName() {
        return this.fk_.getDotNote();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        LinkLineExtractor extractor = new LinkLineExtractor();
        for (PositionableLine line : extractor.getPositionableLines(this)) {
            sb.append("\n").append(line.toString());
        }
        String geometricInfo = String.format(" ParEdge: %s, ChdEdge: %s, Positioner: %s", new Object[]{this.parentEdge, this.childEdge, this.linkPositioner.getClass().getSimpleName()});
        return ForeignKeyGlyph.getClassName() + ": " + this.getName() + geometricInfo + sb.toString();
    }

    @Override
    public boolean dependsOn(String key) {
        boolean depends = key.equals(this.fk_.getParTbl().getDotNote()) || key.equals(this.fk_.getChdTbl().getDotNote());
        return depends;
    }

    private void buildEnhancedShapes() {
        this.updateEnhancedConnectors();
        this.enhancedShapes = new ArrayList<EnhancedShape>();
        this.enhancedShapes.addAll(this.enhancedConnectors);
        for (JointGlyph joint : this.joints_.values()) {
            joint.setErNotation(this.getErNotation());
            this.enhancedShapes.addAll(joint.getEnhancedShapes());
        }
    }

    private void updateEnhancedConnectors() {
        this.enhancedConnectors.addAll(this.unusedEnhancedConnectors);
        int i = 0;
        for (Shape shape : this.shapes) {
            EnhancedShape eShape;
            if (i < this.enhancedConnectors.size()) {
                eShape = this.enhancedConnectors.get(i);
                eShape.setShape(shape);
                eShape.setStrokeColor(this.strokeColor);
            } else {
                eShape = new EnhancedShape(shape, this.getColor(BACK_COLOR));
                this.enhancedConnectors.add(eShape);
            }
            eShape.setIsDashed(this.getUseDashedLines());
            ++i;
        }
        this.unusedEnhancedConnectors.clear();
        for (int j = this.enhancedConnectors.size() - 1; j >= i; --j) {
            this.unusedEnhancedConnectors.add(this.enhancedConnectors.get(j));
            this.enhancedConnectors.remove(j);
        }
    }

    public boolean getUseDashedLines() {
        boolean useDashed = this.getErNotation().getDashLinesFlag(this.fk_.getParentCardinality(), this.fk_.getChildCardinality());
        return useDashed;
    }

    @Override
    public Line2D getContainingLine(Point2D pt) {
        Line2D closeByLine = this.closeByCtrl.getCloseByLine(this.shapes, pt);
        return closeByLine;
    }

    private boolean isCloseBy(Point2D pt) {
        return this.getContainingLine(pt) != null;
    }

    @Override
    public List<IDrawable> getHilightDrawables(Diagram diagram) {
        if (this.isHilighterSet()) {
            return this.hilighter_.getHilightShapes(diagram);
        }
        return new ArrayList<IDrawable>();
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public void move(Point p) {
    }

    @Override
    public void setScaleFactor(double scaleFactor) {
    }

    @Override
    public void setAngle(double angle) {
    }

    @Override
    public void rotateJoint(String key, double angle) {
        Glyph joint = this.joints_.get(key);
        joint.setAngle(angle);
    }

    @Override
    public void moveJoint(String key, Point2D p) {
        Glyph joint = this.joints_.get(key);
        joint.move(new Point((int)p.getX(), (int)p.getY()));
    }

    @Override
    public void setShapes(List<? extends Shape> shapes) {
        this.shapes = shapes;
        LinkLineExtractor.extractLines(shapes, this.rawLines);
        this.buildEnhancedShapes();
    }

    public List getEShapes() {
        ArrayList<EnhancedShape> list = new ArrayList<EnhancedShape>();
        list.addAll(this.enhancedShapes);
        if (this.isNamedDrawerSet()) {
            list.addAll(this.nmDrawer.getSvgShapes());
        }
        return list;
    }

    public List<IDrawable> getDrawables() {
        return this.getEShapes();
    }

    @Override
    public List<? extends Shape> getShapes() {
        return this.shapes;
    }

    @Override
    public List<Line2D> getRawLines() {
        return new ArrayList<Line2D>(this.rawLines);
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected_ = selected;
    }

    @Override
    public boolean getSelected() {
        return this.selected_;
    }

    @Override
    public boolean requiredBoxGlyphPresent(Diagram diagram, String boxName) {
        boolean found = false;
        Iterator<Glyph> it = diagram.getOnlyGlyphs().iterator();
        while (it.hasNext() && !found) {
            Glyph obj = it.next();
            if (!(obj instanceof DbTableGlyph)) continue;
            DbTableGlyph tableGlyph = (DbTableGlyph)obj;
            found = tableGlyph.getTableName().equalsIgnoreCase(boxName);
        }
        return found;
    }

    @Override
    public Color getColor(String key) {
        Color color = null;
        if (this.isBackColorKey(key)) {
            color = this.strokeColor;
        }
        return color;
    }

    @Override
    public List getKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add(BACK_COLOR);
        return keys;
    }

    @Override
    public void setColorScheme(IColorScheme colorScheme) {
        if (this.isHilighterSet()) {
            this.hilighter_.setColorScheme(colorScheme);
        }
    }

    @Override
    public void setColor(String key, Color color) {
        if (!this.isBackColorKey(key)) {
            LogUtil.logErr("ForeignKeyGlyph invalid color key: " + key);
        }
        this.strokeColor = color;
        for (JointGlyph jointGlyph : this.joints_.values()) {
            jointGlyph.setStrokeColor(this.strokeColor);
        }
        this.refresh();
        this.notifyDirty();
        this.notifyObservers(new UpdateChain(color));
    }

    private boolean isBackColorKey(String key) {
        return key.equals(BACK_COLOR) || key.equals("MainBox");
    }

    @Override
    public void setNmPosCoord(IPositioningCoord nmPosCoord) {
        if (!this.isNamedDrawerSet()) {
            this.nmDrawer = new FkNameDrawer(this.diagram, this);
        }
        if (!this.isHilighterSet()) {
            this.hilighter_ = new FkGlyphHilighter(this, this.nmDrawer);
        }
        this.nmDrawer.setNmPosCoord(nmPosCoord);
    }

    @Override
    public void refresh() {
        if (!this.getIsSelfJoin() && this.diagram.getRenderConfig().isRightAngleLinkStrategy() && this.linkPositioner != null) {
            this.linkPositioner.updateShapePositions(this);
        }
        this.buildEnhancedShapes();
    }

    @Override
    public void draw(Graphics2D g2, Zoom zoom) {
        DrawableUtil.drawMixedItems(this.enhancedShapes, g2, zoom);
        if (this.isNamedDrawerSet()) {
            this.nmDrawer.draw(g2, zoom);
        }
    }

    private boolean isNamedDrawerSet() {
        return this.nmDrawer != null;
    }

    private boolean isHilighterSet() {
        return this.hilighter_ != null;
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }

    @Override
    public void setDirtyTracker(IDirtyTracker tracker) {
        this.dirtyTracker_ = tracker;
    }

    private void notifyDirty() {
        if (this.dirtyTracker_ != null) {
            this.dirtyTracker_.notifyDirty(this);
        }
    }

    @Override
    public boolean isMouseOver() {
        return this.isMouseOver;
    }

    @Override
    public void setIsMouseOver(boolean isOver) {
        this.isMouseOver = isOver;
    }

    @Override
    public void setChildEdge(Edge edge) {
        this.childEdge = edge;
    }

    @Override
    public Edge getChildEdge() {
        return this.childEdge;
    }

    @Override
    public void setParentEdge(Edge edge) {
        this.parentEdge = edge;
    }

    @Override
    public Edge getParentEdge() {
        return this.parentEdge;
    }

    @Override
    public void setSingleLinkLinePossible(boolean isSingleLinkLinePossible) {
        this.isSingleLinkLinePossible = isSingleLinkLinePossible;
    }

    @Override
    public boolean getSingleLinkLinePossible() {
        return this.isSingleLinkLinePossible;
    }

    @Override
    public void setIsUserPositioned(boolean isUserPositioned) {
        this.isUserPositioned = isUserPositioned;
    }

    @Override
    public boolean getIsUserPositioned() {
        return this.isUserPositioned;
    }

    @Override
    public void setLinkPositioner(ILinkPositioner linkPositioner) {
        this.linkPositioner = linkPositioner;
    }

    @Override
    public ILinkPositioner getLinkPositioner() {
        return this.linkPositioner;
    }

    @Override
    public double getJointBackLengthFixed() {
        return this.diagram.getRenderConfig().getJointDimensionCalc().getBackBoneLength();
    }
}

