/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.diagram;

import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.diagram.DbVerbosity;
import com.harrand.dbwrench.diagram.ForeignKeyGlyph;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.xml.DbTableGlyphXmlCtrl;
import com.harrand.dbwrench.xml.FkGlyphXmlCtrl;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.IGlyphStore;
import com.harrand.sketch.core.RenderConfig;
import com.harrand.sketch.core.VerbosityConfig;
import com.harrand.sketch.xml.RenderConfigXmlCtrl;
import com.harrand.util.XmlHelper;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DbwGlyphStore
implements IGlyphStore {
    private Database db_;
    private RenderConfigXmlCtrl rcXmlCtrl_;
    private DbTableGlyphXmlCtrl dbGlyphXmlCtrl_;
    private FkGlyphXmlCtrl fkGlyphXmlCtrl_;

    public DbwGlyphStore(Database db) {
        this.db_ = db;
        this.rcXmlCtrl_ = new RenderConfigXmlCtrl();
        this.dbGlyphXmlCtrl_ = new DbTableGlyphXmlCtrl();
        this.fkGlyphXmlCtrl_ = new FkGlyphXmlCtrl();
    }

    @Override
    public List getStoredGlyphs(Element elmDiagram, Diagram diagram) {
        ArrayList<DbTableGlyph> glyphs = new ArrayList<DbTableGlyph>();
        NodeList nl = elmDiagram.getElementsByTagName("TbGl");
        for (int i = 0; i < nl.getLength(); ++i) {
            glyphs.add(DbTableGlyphXmlCtrl.fromXml((Element)nl.item(i), this.db_, diagram));
        }
        return glyphs;
    }

    @Override
    public RenderConfig getRenderConfig(Element elmDiagram) {
        Element elmRc = XmlHelper.getFirstElementByTagName(elmDiagram, "RnCf");
        RenderConfig rcOut = this.rcXmlCtrl_.fromXml(elmRc);
        VerbosityConfig vbCfg = rcOut.getVerbosityConfig();
        DbVerbosity dbVbCfg = new DbVerbosity(vbCfg.getShowFlagsMap());
        rcOut.set(dbVbCfg);
        return rcOut;
    }

    @Override
    public List getStoredLinks(Element elmDiagram, Diagram diagram) {
        ArrayList<ForeignKeyGlyph> links = new ArrayList<ForeignKeyGlyph>();
        NodeList nl = elmDiagram.getElementsByTagName("FkGl");
        for (int i = 0; i < nl.getLength(); ++i) {
            ForeignKeyGlyph link = FkGlyphXmlCtrl.fromXml((Element)nl.item(i), this.db_, diagram);
            links.add(link);
        }
        return links;
    }
}

