/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.diagram;

import com.harrand.coregui.mouse.IRollOverable;
import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.diagram.ForeignKeyGlyph;
import com.harrand.dbwrench.diagram.fk.FkGlyphExtractor;
import com.harrand.dbwrench.diagram.table.DbTableGlyphExtractor;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.glyph.AnchorGlyph;
import com.harrand.sketch.glyph.NoteGlyph;
import com.harrand.sketch.glyph.ZoneGlyph;
import com.harrand.sketch.glyph.interfaces.IAnchorGlyphStore;
import com.harrand.sketch.interfaces.IDiagramPlugin;
import com.harrand.sketch.interfaces.IHilightableGlyph;
import com.harrand.sketch.j2d.draw.IDrawable;
import com.harrand.sketch.j2d.draw.IDrawableOrderer;
import com.harrand.sketch.object.DiagramCollector;
import com.harrand.sketch.xml.svg.common.ISvgShape;
import java.util.ArrayList;
import java.util.List;

public class DbDrawableOrderer
implements IDrawableOrderer,
IAnchorGlyphStore {
    private Diagram diagram;
    private DiagramCollector diagramColl;
    private List<AnchorGlyph> anchorGlyphs = new ArrayList<AnchorGlyph>();
    private List<IDrawable> tblHighlightDrawables = new ArrayList<IDrawable>();
    private List<IDrawable> fkHighlightDrawables = new ArrayList<IDrawable>();
    private List<IDrawable> noteHighlightDrawables = new ArrayList<IDrawable>();
    private List<IDrawable> zoneHighlightDrawables = new ArrayList<IDrawable>();
    private IDiagramPlugin diagramPlugin;

    @Override
    public List<IDrawable> getOrderedDrawables(Diagram diagram) {
        ArrayList<IDrawable> drawables = new ArrayList<IDrawable>();
        this.setDiagram(diagram);
        this.diagramColl = diagram.getCollector();
        this.setHighLightedGlyphs();
        drawables.addAll(this.zoneHighlightDrawables);
        drawables.addAll(this.diagramColl.getZoneGlyphs());
        drawables.addAll(this.getShadows());
        drawables.addAll(this.noteHighlightDrawables);
        drawables.addAll(this.tblHighlightDrawables);
        drawables.addAll(this.getFkGlyphs());
        drawables.addAll(this.diagramColl.getNoteGlyphs());
        drawables.addAll(this.getDbTableGlyphs());
        drawables.addAll(this.fkHighlightDrawables);
        drawables.addAll(this.anchorGlyphs);
        if (this.diagramPlugin != null) {
            drawables.addAll(this.diagramPlugin.getDrawables());
        }
        return drawables;
    }

    public void setDiagram(Diagram diagram) {
        this.diagram = diagram;
    }

    @Override
    public void setDiagramPlugin(IDiagramPlugin diagramPlugin) {
        this.diagramPlugin = diagramPlugin;
    }

    private List<DbTableGlyph> getDbTableGlyphs() {
        return new DbTableGlyphExtractor().getDbTableGlyphs(this.diagram);
    }

    private List<ForeignKeyGlyph> getFkGlyphs() {
        return new FkGlyphExtractor().getFkGlyphs(this.diagram);
    }

    public List<IDrawable> getShadows() {
        ArrayList<IDrawable> shadows = new ArrayList<IDrawable>();
        for (DbTableGlyph dbTableGlyph : this.getDbTableGlyphs()) {
            shadows.add(dbTableGlyph.getShadow());
        }
        return shadows;
    }

    public List<ISvgShape> getShadowSvgShapes() {
        ArrayList<ISvgShape> shadows = new ArrayList<ISvgShape>();
        for (DbTableGlyph dbTableGlyph : this.getDbTableGlyphs()) {
            shadows.add(dbTableGlyph.getShadow());
        }
        return shadows;
    }

    private void setHighLightedGlyphs() {
        this.tblHighlightDrawables = new ArrayList<IDrawable>();
        this.fkHighlightDrawables = new ArrayList<IDrawable>();
        this.noteHighlightDrawables = new ArrayList<IDrawable>();
        this.zoneHighlightDrawables = new ArrayList<IDrawable>();
        this.anchorGlyphs = new ArrayList<AnchorGlyph>();
        for (Glyph glyph : this.diagram.getAllGlyphs()) {
            boolean isMouseOver = this.getIsMouseOver(glyph);
            boolean selected = glyph.getSelected();
            if (!selected && !isMouseOver || !(glyph instanceof IHilightableGlyph)) continue;
            IHilightableGlyph hlGlyph = (IHilightableGlyph)((Object)glyph);
            List<IDrawable> hilightDrawables = hlGlyph.getHilightDrawables(this.diagram);
            if (hlGlyph instanceof DbTableGlyph) {
                this.tblHighlightDrawables.addAll(hilightDrawables);
            }
            if (hlGlyph instanceof ForeignKeyGlyph) {
                this.fkHighlightDrawables.addAll(hilightDrawables);
            }
            if (hlGlyph instanceof NoteGlyph) {
                this.noteHighlightDrawables.addAll(hilightDrawables);
            }
            if (hlGlyph instanceof ZoneGlyph) {
                this.zoneHighlightDrawables.addAll(hilightDrawables);
            }
            this.checkForAnchorGlyphs(hilightDrawables);
        }
    }

    private void checkForAnchorGlyphs(List hilightShapes) {
        for (Object obj : hilightShapes) {
            if (!(obj instanceof AnchorGlyph)) continue;
            AnchorGlyph anchor = (AnchorGlyph)obj;
            this.anchorGlyphs.add(anchor);
        }
    }

    private boolean getIsMouseOver(Glyph glyph) {
        boolean isOver = false;
        if (glyph instanceof IRollOverable) {
            IRollOverable rollOverable = (IRollOverable)((Object)glyph);
            isOver = rollOverable.isMouseOver();
        }
        return isOver;
    }

    @Override
    public List<AnchorGlyph> getAnchorGlyphs() {
        return new ArrayList<AnchorGlyph>(this.anchorGlyphs);
    }
}

