/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.diagram;

import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.dbwrench.diagram.DbLinkSource;
import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.diagram.DbVerbosity;
import com.harrand.dbwrench.diagram.ForeignKeyGlyph;
import com.harrand.dbwrench.diagram.KeyToKeyStrategy;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.testData.DataGen;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.RenderConfig;
import com.harrand.sketch.core.TestData;
import com.harrand.sketch.core.VerbosityConfig;
import com.harrand.sketch.linkStrategies.LinkStrategy;
import com.harrand.sketch.linkStrategies.OffsetDirect;
import com.harrand.sketch.object.Note;
import com.harrand.sketch.object.Zone;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.openide.util.Exceptions;

public final class DataGenSketch {
    public static final String CAR_NM = "Car";
    public static final String ENGINE_NM = "Engine";
    public static String DIAGRAM_A_NAME = "diagramA";
    public static String DIAGRAM_B_NAME = "diagramB";
    public static String ZONE_A_NM = "zoneA";
    public static String ZONE_B_NM = "zoneB";
    public static String NOTE_A_NM = "noteA";
    public static String NOTE_B_NM = "noteB";
    public static final int CAR_X = 25;
    public static final int CAR_Y = 25;
    public static final int ENGINE_X = 300;
    public static final int ENGINE_Y = 100;
    public static final Point START_CAR_PT = new Point(25, 25);
    public static final Point START_ENGINE_PT = new Point(300, 100);
    public static final String SCH_NM = "schemaA";
    public static final String LINK_FQN_NAME = "schemaA.Car.fkEngineId";
    public static boolean showAllCols_ = false;
    public static boolean showFk = true;
    public static boolean showPk = false;

    public static Database getDatabaseAndDiagramData() {
        Database db = DataGen.getDatabaseData();
        DataGenSketch.attachDiagrams(db);
        return db;
    }

    private static void writeDb(Database db) {
        db.setFolder("C:/Users/Harnek/DocumentsDbw/userdata/databases");
        try {
            db.write();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static void attachDiagrams(Database dbByRef) {
        Iterator it = DataGenSketch.getDiagrams(dbByRef).iterator();
        while (it.hasNext()) {
            ITestResult iTestResult = dbByRef.add((Diagram)it.next());
        }
    }

    public static RenderConfig getRenderConfigDefault(Database db) {
        RenderConfig rc = new RenderConfig(1.0, (LinkStrategy)new KeyToKeyStrategy(db), (VerbosityConfig)new DbVerbosity());
        return rc;
    }

    public static void addDiagramItems(Database db, Diagram diagram) {
        Schema schema = db.getSchema(SCH_NM);
        Table tabCar = schema.getTable(CAR_NM);
        Table tabEngine = schema.getTable(ENGINE_NM);
        RenderConfig rc = DataGenSketch.getRenderConfigDefault(db);
        DbTableGlyph glyphCar = new DbTableGlyph(START_CAR_PT, tabCar, diagram);
        glyphCar.setColor("MainBox", Color.BLUE);
        DbTableGlyph glyphEngine = new DbTableGlyph(START_ENGINE_PT, tabEngine, diagram);
        glyphEngine.setColor("MainBox", Color.GREEN);
        ArrayList<DbTableGlyph> glyphs = new ArrayList<DbTableGlyph>();
        glyphs.add(glyphCar);
        glyphs.add(glyphEngine);
        diagram.initAddGlyphs(glyphs);
        Zone zoneA = new Zone(ZONE_A_NM, "First Zone", new Rectangle(5, 10, 260, 200));
        zoneA.setColor(Color.PINK);
        diagram.add(zoneA);
        Note noteA = new Note("First Note", new Point(300, 260));
        noteA.setColor(Color.YELLOW);
        diagram.add(noteA);
    }

    public static ArrayList getDiagrams(Database db) {
        RenderConfig configA = new RenderConfig(1.0, (LinkStrategy)new KeyToKeyStrategy(db), (VerbosityConfig)DataGenSketch.getVerbosity());
        RenderConfig configB = new RenderConfig(0.8, (LinkStrategy)new OffsetDirect(), (VerbosityConfig)DataGenSketch.getVerbosity());
        Diagram diagramA = new Diagram(DIAGRAM_A_NAME, configA);
        Diagram diagramB = new Diagram(DIAGRAM_B_NAME, configB);
        DataGenSketch.addDiagramItems(db, diagramA);
        DataGenSketch.addDiagramItems(db, diagramB);
        DbLinkSource linkSource = new DbLinkSource(db);
        diagramA.setLinkSource(linkSource);
        diagramB.setLinkSource(linkSource);
        Schema schema = db.getSchema(SCH_NM);
        Table tabCar = schema.getTable(CAR_NM);
        String fkName = DataGen.getForeignKeyName();
        ForeignKey fk = tabCar.getForeignKey(fkName);
        ForeignKeyGlyph fkGlyphA = (ForeignKeyGlyph)diagramA.getLink(fk.getDotNote());
        fkGlyphA.setColor("BackColor", Color.BLUE);
        ArrayList<Diagram> diagrams = new ArrayList<Diagram>();
        diagrams.add(diagramA);
        diagrams.add(diagramB);
        return diagrams;
    }

    public static DbVerbosity getVerbosity() {
        DbVerbosity config = new DbVerbosity();
        config.setShowFlag(DbVerbosity.getKeyColumName(), true);
        config.setShowFlag(DbVerbosity.getKeyLength(), true);
        config.setShowFlag(DbVerbosity.getKeyDataType(), true);
        config.setShowFlag(DbVerbosity.getKeyNullable(), true);
        config.setShowFlag(DbVerbosity.getKeyAutoNumber(), false);
        config.setShowFlag(DbVerbosity.getKeyDefault(), false);
        config.setShowFlag(DbVerbosity.getKeyCheck(), false);
        return config;
    }

    public static Diagram getEmptyDiagram(Database db, String name) {
        RenderConfig rc = new RenderConfig(1.0, (LinkStrategy)new KeyToKeyStrategy(db), (VerbosityConfig)new DbVerbosity());
        Diagram diagram = new Diagram(name, rc, new ArrayList());
        return diagram;
    }

    public static Font getFont9() {
        return TestData.getFont9();
    }

    public static Font getFont7() {
        return TestData.getFont7();
    }
}

