/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.db.comm;

import com.harrand.coregui.jdesktop.swingworker.IProcessObserver;
import com.harrand.dbwrench.db.comm.SqlParser;
import com.harrand.dbwrench.jdbc.ConnMgr;
import com.harrand.dbwrench.jdbc.Dbms;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.translate.QueryTranslation;
import com.harrand.dbwrench.translate.TranslatorCtrl;
import com.harrand.dbwrenchgui.db.worker.sql.SqlWorker;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;

public class SqlSender
implements IProcessObserver {
    private static SqlSender instance__ = new SqlSender();
    private List<IProcessObserver> processObservers_ = new ArrayList<IProcessObserver>();
    private TranslatorCtrl translatorCtrl_ = new TranslatorCtrl();
    private boolean isFinished_ = true;
    private String translationDesc_ = "";

    private SqlSender() {
    }

    public static SqlSender getInstance() {
        return instance__;
    }

    public void addSqlProcessObserver(IProcessObserver processObserver) {
        this.processObservers_.add(processObserver);
    }

    public boolean isFinished() {
        return this.isFinished_;
    }

    public void sendSql(JButton disabledBtn, JLabel statusLbl, String unparsedSql) {
        JdbcConfig cfg = this.getConfig();
        ArrayList<String> sqlStrs = new ArrayList<String>();
        List<String> rawSqlStrs = SqlParser.parse(unparsedSql);
        ArrayList<String> translationMsgs = new ArrayList<String>();
        for (String rawSql : rawSqlStrs) {
            String sql = this.applyTranslation(cfg, rawSql);
            sqlStrs.add(sql);
            translationMsgs.add(this.translationDesc_);
        }
        SqlWorker sqlWorker = new SqlWorker();
        sqlWorker.setDisabledButton(disabledBtn);
        sqlWorker.setStatusLabel(statusLbl);
        sqlWorker.setProcessObserver(this);
        sqlWorker.setTranslationMsgs(translationMsgs);
        sqlWorker.startSqlCmds(sqlStrs, null);
    }

    private String applyTranslation(JdbcConfig cfg, String rawSql) {
        String sql;
        this.translationDesc_ = "";
        Dbms toDbms = cfg.getDbms();
        QueryTranslation translation = this.translatorCtrl_.getTranslation(rawSql, toDbms, cfg);
        if (translation != null) {
            sql = translation.getQuery().getQueryText();
            this.translationDesc_ = translation.toString();
        } else {
            sql = rawSql;
        }
        return sql;
    }

    private JdbcConfig getConfig() {
        return ConnMgr.getInstance().getCurrentCfg();
    }

    @Override
    public void process(List chunks) {
        for (IProcessObserver processObserver : this.processObservers_) {
            processObserver.process(chunks);
        }
    }
}

