/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.db.auto.sequence;

import com.harrand.dbwrench.db.auto.ctrl.IAutoAddEntitiesCtrl;
import com.harrand.dbwrench.db.auto.sequence.AutonumberDefaultValueGenerator;
import com.harrand.dbwrench.jdbc.ConnMgr;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Sequence;
import com.harrand.dbwrench.object.Table;
import com.harrand.util.LogUtil;
import java.util.HashMap;
import java.util.Map;

public final class AutoAddSequencesCtrl
implements IAutoAddEntitiesCtrl {
    private Map<Sequence, Table> seqTableMap = new HashMap<Sequence, Table>();
    private final AutonumberDefaultValueGenerator defaultValueGenerator = new AutonumberDefaultValueGenerator();
    private boolean immediatesDone;

    @Override
    public void doImmediateUpdates() {
        if (this.immediatesDone) {
            LogUtil.logErr("AutoAddSequencesCtrl.doImmediateUpdates already done.");
            return;
        }
        JdbcConfig config = ConnMgr.getInstance().getCurrentCfg();
        if (config == null) {
            LogUtil.logErr(this, "JdbcConfig can not be null.");
        }
        this.immediatesDone = true;
    }

    @Override
    public void doPostScriptUpdates() {
        for (Sequence sequence : this.seqTableMap.keySet()) {
            Schema schema = sequence.getSchema();
            if (!this.checkSchemaSet(sequence)) continue;
            schema.add(sequence);
            String defaultValue = this.defaultValueGenerator.getNewDefaulValue(sequence);
            this.setTableDefaultValue(sequence, defaultValue);
        }
    }

    @Override
    public void rollbackUpdates() {
        for (Sequence sequence : this.seqTableMap.keySet()) {
            Schema schema = sequence.getSchema();
            if (!this.checkSchemaSet(sequence)) continue;
            schema.remove(sequence.getMapName(), sequence.getName());
        }
    }

    @Override
    public void clear() {
        this.seqTableMap = new HashMap<Sequence, Table>();
        this.immediatesDone = false;
    }

    public Map<Sequence, Table> getSeqTableMap() {
        return this.seqTableMap;
    }

    public void setSequenceTableMap(Map<Sequence, Table> seqTableMap) {
        this.seqTableMap = seqTableMap;
        this.doImmediateUpdates();
    }

    private void setTableDefaultValue(Sequence sequence, String defaultValue) {
        Table table = this.seqTableMap.get(sequence);
        if (table != null) {
            Column autonumberColumn = table.getAutoNumberColumn();
            if (autonumberColumn != null) {
                autonumberColumn.setDefaultValue(defaultValue);
            } else {
                LogUtil.logErr(this.getClassName() + ", autonumber column not found for table: " + table.getName());
            }
        } else {
            LogUtil.logErr(this.getClassName() + ", no table found in map for sequence: " + sequence.getName());
        }
    }

    private String getClassName() {
        return this.getClass().getSimpleName();
    }

    private boolean checkSchemaSet(Sequence sequence) {
        if (sequence.getSchema() == null) {
            LogUtil.logErr(this.getClassName() + ": No schema set for sequence: " + sequence.getName());
            return false;
        }
        return true;
    }
}

