/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.db;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coregui.jdesktop.swingworker.IThreadObserver;
import com.harrand.coregui.jdesktop.swingworker.SwingWorker;
import com.harrand.dbwrench.db.BasicSqlGenerator;
import com.harrand.dbwrench.db.IDbValue;
import com.harrand.dbwrench.db.ISqlGenerator;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrenchgui.db.worker.sql.SqlWorker;
import com.harrand.util.MathUtil;
import com.harrand.util.ResMgr;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;

public final class JdbcRowCtrl
implements IThreadObserver {
    private Table table_;
    private ISqlGenerator sqlGenerator_;
    private JdbcConfig config_;
    private Map currentValues_ = null;
    private JButton disabledBtn;
    private JLabel statusLbl;
    private String msgTitle;
    private String msgPrefix;
    private String fullMsg;
    private ITestResult sqlCmdResult;
    private IThreadObserver externalThreadObserver;

    public JdbcRowCtrl(Table table, JdbcConfig config, Map currentValues) {
        this.table_ = table;
        this.setConfig(config);
        this.setCurrentValues(currentValues);
    }

    public void setConfig(JdbcConfig config) {
        this.config_ = config;
        this.sqlGenerator_ = this.config_ != null ? new BasicSqlGenerator(this.config_.getDbms()) : null;
    }

    public void setCurrentValues(Map currentValues) {
        this.currentValues_ = currentValues;
    }

    public Map getCurrentValues() {
        return this.currentValues_;
    }

    public Object getCurrentValue(String columnName) {
        IDbValue value;
        Object valObject = null;
        if (this.currentValues_ != null && (value = (IDbValue)this.currentValues_.get(columnName)) != null) {
            valObject = value.getValueObject();
        }
        return valObject;
    }

    public ITestResult getSqlCmdResult() {
        return this.sqlCmdResult;
    }

    public void setDisabledBtn(JButton disabledBtn) {
        this.disabledBtn = disabledBtn;
    }

    public void setStatusLabel(JLabel statusLbl) {
        this.statusLbl = statusLbl;
    }

    public void setThreadObserver(IThreadObserver threadObserver) {
        this.externalThreadObserver = threadObserver;
    }

    public ITestResult startRowInsert(Map dbValues, Integer newIdByRef) {
        if (!this.isConfigSet()) {
            return this.getConfigNotSetResult();
        }
        this.msgPrefix = ResMgr.getRes("insert.success.into.table") + this.table_.getName();
        this.msgTitle = ResMgr.getRes("insert.success.title");
        String sql = this.getInsertSql(dbValues);
        String valueStr = this.getInsertedValueStr(sql);
        this.fullMsg = this.msgPrefix + "\n" + valueStr;
        this.startSqlWorker(sql);
        newIdByRef = new Integer(-1);
        DataEntryResult result = new DataEntryResult(true, this.msgTitle, this.msgPrefix);
        return result;
    }

    public ITestResult startRowUpdate(Map newDbValues) {
        if (!this.isConfigSet()) {
            return this.getConfigNotSetResult();
        }
        ITestResult changedResult = this.ensureValuesChanged(newDbValues);
        if (!changedResult.getPassed()) {
            return changedResult;
        }
        String msg = ResMgr.getRes("update.success.table") + ": " + this.table_.getName();
        String title = ResMgr.getRes("update.success.title");
        boolean passed = true;
        String sql = this.getUpdateSql(newDbValues);
        this.startSqlWorker(sql);
        DataEntryResult result = new DataEntryResult(passed, title, msg);
        return result;
    }

    public ITestResult startRowDelete() {
        if (!this.isConfigSet()) {
            return this.getConfigNotSetResult();
        }
        String msg = ResMgr.getRes("delete.success.table") + ": " + this.table_.getName();
        String title = ResMgr.getRes("delete.success.title");
        boolean passed = true;
        String sql = this.getDeleteSql();
        this.startSqlWorker(sql);
        DataEntryResult result = new DataEntryResult(passed, title, msg);
        return result;
    }

    private void startSqlWorker(String sql) {
        SqlWorker sqlWorker = new SqlWorker();
        sqlWorker.setDisabledButton(this.disabledBtn);
        sqlWorker.setStatusLabel(this.statusLbl);
        sqlWorker.startSqlCmd(sql, this);
    }

    public String getDeleteSql() {
        String sql = this.isConfigSet() ? this.sqlGenerator_.getDeleteSql(this.table_, this.currentValues_) : "";
        return sql;
    }

    public String getInsertSql(Map dbValues) {
        String sql = "";
        if (this.isConfigSet()) {
            LinkedHashMap<String, IDbValue> filteredValues = new LinkedHashMap<String, IDbValue>();
            for (IDbValue dbValue : dbValues.values()) {
                Column column = dbValue.getColumn();
                if (column.getAutoNumber()) continue;
                filteredValues.put(dbValue.getName(), dbValue);
            }
            sql = this.sqlGenerator_.getInsertSql(this.table_, new ArrayList(filteredValues.values()));
        }
        return sql;
    }

    public String getUpdateSql(Map newDbValues) {
        String sql = this.isConfigSet() ? this.sqlGenerator_.getUpdateSql(this.table_, this.currentValues_, newDbValues) : "";
        return sql;
    }

    private String getInsertedValueStr(String fullSql) {
        String valueStr = "";
        String findStr = "VALUES\n (";
        int start = fullSql.indexOf(findStr);
        try {
            valueStr = fullSql.substring(start, fullSql.length());
        }
        catch (Exception e) {
            System.out.println("JdbcRowCtrl.insertValue: " + e.getMessage());
        }
        return valueStr;
    }

    private ITestResult ensureValuesChanged(Map newDbValues) {
        DataEntryResult result = new DataEntryResult(false, ResMgr.getRes("values.not.modified.err"));
        Iterator it = newDbValues.values().iterator();
        while (it.hasNext() && !result.getPassed()) {
            Object oldObj;
            IDbValue newDbValue = (IDbValue)it.next();
            IDbValue oldDbValue = (IDbValue)this.currentValues_.get(newDbValue.getName());
            Object newObj = newDbValue.getValueObject();
            if (MathUtil.isEquivalent(newObj, oldObj = oldDbValue.getValueObject())) continue;
            result = new DataEntryResult(true);
        }
        return result;
    }

    private boolean isConfigSet() {
        return this.config_ != null;
    }

    private ITestResult getConfigNotSetResult() {
        String msg = ResMgr.getRes("connection.not.defined");
        DataEntryResult result = new DataEntryResult(false, msg);
        return result;
    }

    @Override
    public void threadDone(SwingWorker threadWorker) {
        SqlWorker sqlCmdWorker = (SqlWorker)threadWorker;
        ITestResult workerResult = sqlCmdWorker.getResult();
        this.sqlCmdResult = workerResult.getPassed() ? new DataEntryResult(true, this.msgTitle, this.fullMsg) : workerResult;
        this.externalThreadObserver.threadDone(threadWorker);
    }
}

