/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.db;

import com.harrand.coreclasses.db.DbDataResult;
import com.harrand.coreclasses.db.SqlHelper;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.list.DateComparator;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coregui.jdesktop.swingworker.IThreadObserver;
import com.harrand.coregui.jdesktop.swingworker.SwingWorker;
import com.harrand.dbwrench.db.FkDataItem;
import com.harrand.dbwrench.db.table.data.ITableDataQueryBuilder;
import com.harrand.dbwrench.db.table.data.TableDataQueryBuilderFactory;
import com.harrand.dbwrench.jdbc.ConnectionFactory;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.dbwrenchgui.db.worker.sql.SqlWorker;
import com.harrand.util.LogUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;

public final class JdbcDbTableCtrl
implements IThreadObserver {
    private Database db_;
    private Table table_;
    private JdbcConfig config_;
    private DateComparator dateComparator_ = new DateComparator();
    private IOptionMgr tblDataVwOptMgr_;
    private JButton disabledBtn;
    private JLabel statusLbl;
    private IThreadObserver externalThreadObserver;
    private ITestResult sqlCmdResult;

    public JdbcDbTableCtrl(Database db, Table table, JdbcConfig config) {
        this.db_ = db;
        this.table_ = table;
        this.setConfig(config);
        DbUser user = App.getUser();
        this.tblDataVwOptMgr_ = user.getOptionMgr("tbl.data.view.opt.mgr");
    }

    public void setConfig(JdbcConfig config) {
        this.config_ = config;
    }

    public void setDisabledBtn(JButton disabledBtn) {
        this.disabledBtn = disabledBtn;
    }

    public void setStatusLabel(JLabel statusLbl) {
        this.statusLbl = statusLbl;
    }

    public void setThreadObserver(IThreadObserver threadObserver) {
        this.externalThreadObserver = threadObserver;
    }

    public List getDomainValues(String columnName) {
        Column column = this.table_.getColumn(columnName);
        if (column.getDataTypeId() == 706) {
            return this.getDomainValuesEnum(columnName);
        }
        return this.getDomainValuesFk(columnName);
    }

    private List getDomainValuesFk(String colNm) {
        List domainValues = null;
        if (!this.tblDataVwOptMgr_.getBoolValue("tbl.data.vw.cbo.fk")) {
            return domainValues;
        }
        List fks = this.db_.getFkUtil().getFksForTable(this.table_, 1);
        for (ForeignKey fk : fks) {
            if (!fk.getChildColumnsOld().contains(colNm)) continue;
            Table parentTable = fk.getParTbl();
            ArrayList parentCols = fk.getParentColumnsOld();
            if (parentCols.size() != 1) continue;
            String idColName = (String)parentCols.get(0);
            Column idCol = parentTable.getColumn(idColName);
            boolean intType = idCol.isIntegerColumn();
            boolean strType = idCol.getDataType().isStringLikeType();
            if (!intType && !strType) continue;
            Column descCol = this.getDescCol(parentTable, null);
            if (descCol == null) {
                descCol = idCol;
            }
            if (descCol == null) continue;
            domainValues = this.getIdsForParent(parentTable, idCol, descCol);
        }
        return domainValues;
    }

    private List getDomainValuesEnum(String columnName) {
        ArrayList<FkDataItem> list = new ArrayList<FkDataItem>();
        Column column = this.table_.getColumn(columnName);
        String[] items = column.getEnumCsv().split(",");
        for (int i = 0; i < items.length; ++i) {
            String rawStr = items[i];
            String cleanStr = rawStr.replaceAll("'", "");
            list.add(new FkDataItem(Integer.toString(i + 1), cleanStr));
        }
        list.add(new FkDataItem("0", "''"));
        return list;
    }

    public void startGetTableData() {
        ITableDataQueryBuilder queryBuilder = TableDataQueryBuilderFactory.getTableDataQueryBuilder(this.config_.getDbms());
        String sql = queryBuilder.getQueryText(this.getColumnNameSql(), this.getForEngNm(this.table_));
        SqlWorker sqlWorker = new SqlWorker();
        sqlWorker.setDisabledButton(this.disabledBtn);
        sqlWorker.setStatusLabel(this.statusLbl);
        sqlWorker.setExecutingText(StrHelper.REFRESHING_DATA_STR);
        sqlWorker.startSqlCmd(sql, this);
    }

    private String getForEngNm(Identifiable idf) {
        return this.config_.getForEngNm(idf);
    }

    public Map getColumnComparators() {
        HashMap<String, DateComparator> comparatorMap = new HashMap<String, DateComparator>();
        for (Column column : this.table_.values(Column.getClassName())) {
            if (!column.getDataType().isDateLikeType()) continue;
            comparatorMap.put(column.getName(), this.dateComparator_);
        }
        return comparatorMap;
    }

    public String getColumnNameSql() {
        StringBuffer sb = new StringBuffer();
        for (Column column : this.table_.values(Column.getClassName())) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(this.config_.getFormattedName(column));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getIdsForParent(Table parentTable, Column idColumn, Column descColumn) {
        ArrayList<FkDataItem> ids = new ArrayList<FkDataItem>();
        String tblForEngNm = this.getForEngNm(parentTable);
        String parTblPrefix = tblForEngNm + ".";
        String idColSql = parTblPrefix + this.config_.getDbms().getFormattedName(idColumn.getName());
        String descColSql = parTblPrefix + this.config_.getDbms().getFormattedName(descColumn.getName());
        Connection conn = null;
        String sql = "SELECT " + idColSql + ", " + descColSql + "\nFROM " + tblForEngNm + "\nORDER BY " + descColSql;
        try {
            conn = ConnectionFactory.getConnection(this.config_);
            ResultSet rs = ConnectionFactory.doSql(conn, sql);
            while (rs.next()) {
                String strId;
                String desc = strId = rs.getString(idColumn.getName());
                if (this.config_.getDbmsId() == 2) {
                    try {
                        desc = rs.getString(descColumn.getName());
                    }
                    catch (Exception e) {
                        LogUtil.logErr("JdbcDbTableCtrl.ODBC.err: " + e.getMessage());
                    }
                } else {
                    desc = rs.getString(descColumn.getName());
                }
                FkDataItem fkDataItem = new FkDataItem(strId, desc);
                ids.add(fkDataItem);
            }
        }
        catch (Exception e) {
            System.out.println("JdbcDbTableCtrl.parentIds.error: " + e.getMessage());
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    System.out.println("JdbcDbTablCtrl.parentIds Conn Close Err:" + e.getMessage());
                }
            }
        }
        return ids;
    }

    private Column getDescCol(Table table, String userWildCard) {
        Column column = null;
        if (userWildCard != null) {
            column = this.getColumnContainsName(table, userWildCard);
        }
        if (column == null) {
            column = this.getColumnWithName(table, "name");
        }
        if (column == null) {
            column = this.getColumnWithName(table, "desc");
        }
        if (column == null) {
            column = this.getColumnContainsName(table, "name");
        }
        if (column == null) {
            column = this.getColumnContainsName(table, "desc");
        }
        return column;
    }

    public Column getColumnWithName(Table table, String name) {
        Column matchColumn = null;
        Iterator it = table.values(Column.getClassName()).iterator();
        while (it.hasNext() && matchColumn == null) {
            Column column = (Column)it.next();
            if (!column.getName().equalsIgnoreCase(name)) continue;
            matchColumn = column;
        }
        return matchColumn;
    }

    public Column getColumnContainsName(Table table, String name) {
        Column matchColumn = null;
        String nameLc = name.toLowerCase();
        Iterator it = table.values(Column.getClassName()).iterator();
        while (it.hasNext() && matchColumn == null) {
            Column column = (Column)it.next();
            String colNameLc = column.getName().toLowerCase();
            if (colNameLc.indexOf(name.toLowerCase()) < 0) continue;
            matchColumn = column;
        }
        return matchColumn;
    }

    @Override
    public void threadDone(SwingWorker threadWorker) {
        SqlWorker sqlCmdWorker = (SqlWorker)threadWorker;
        DbDataResult workerResult = (DbDataResult)sqlCmdWorker.getResult();
        if (workerResult.getPassed()) {
            this.sqlCmdResult = workerResult;
        } else {
            String svrMsg = workerResult.getDetail();
            Object[][] data = SqlHelper.getEmptyDataMatrix();
            this.sqlCmdResult = new DbDataResult(false, data, true);
            String fullMsg = "Server Message: " + svrMsg + "\n\n" + "Ensure the correct Connection is selected above\n" + "and that this table exists on that server.";
            this.sqlCmdResult.setSummary("Data Retrieval Failed");
            this.sqlCmdResult.setDetail(fullMsg);
        }
        this.externalThreadObserver.threadDone(threadWorker);
    }
}

