/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.db;

import com.harrand.dbwrench.db.IDbValue;
import com.harrand.dbwrench.db.ISqlGenerator;
import com.harrand.dbwrench.jdbc.Dbms;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.PrimaryKey;
import com.harrand.dbwrench.object.Table;
import com.harrand.util.MathUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class BasicSqlGenerator
implements ISqlGenerator {
    private Dbms dbms_;
    private boolean useNullForBlanks_ = true;

    public BasicSqlGenerator(Dbms dbms) {
        this.setDbms(dbms);
    }

    private String getForEngNm(Table table) {
        boolean doDblQuote = this.dbms_.checkDblQuotePsqlNm(table.getDotNote());
        return table.getForEngNm(table.getName(), this.dbms_.supportsSchemas(), doDblQuote, this.dbms_.getStrEscapeCtrl());
    }

    @Override
    public String getDeleteSql(Table table, Map oldDbValues) {
        StringBuffer sb = new StringBuffer("\nDELETE FROM " + this.getForEngNm(table) + " ");
        String sqlWhere = this.getWhereClause(table, oldDbValues);
        sb.append(sqlWhere);
        return sb.toString();
    }

    @Override
    public String getInsertSql(Table table, List dbValues) {
        StringBuffer sbMain = new StringBuffer("INSERT INTO " + this.getForEngNm(table) + "\n (");
        StringBuffer sbValues = new StringBuffer("\nVALUES\n (");
        int count = 0;
        for (IDbValue dbValue : dbValues) {
            Column column = dbValue.getColumn();
            boolean exclude = false;
            if (exclude) continue;
            if (count > 0) {
                sbMain.append(", ");
                sbValues.append(", ");
            }
            sbMain.append(this.dbms_.getFormattedName(column));
            sbValues.append(this.dbms_.getFormattedValue(dbValue));
            ++count;
        }
        sbMain.append(")");
        sbValues.append(")");
        sbMain.append(sbValues.toString());
        return sbMain.toString();
    }

    @Override
    public String getUpdateSql(Table table, Map oldDbValues, Map newDbValues) {
        StringBuffer sb = new StringBuffer("\nUPDATE " + this.getForEngNm(table) + " SET");
        int count = 0;
        for (IDbValue newDbValue : newDbValues.values()) {
            IDbValue oldDbValue = (IDbValue)oldDbValues.get(newDbValue.getName());
            Object newObj = newDbValue.getValueObject();
            Object oldObj = oldDbValue.getValueObject();
            boolean exclude = false;
            if (exclude || !newDbValue.isFunction() && MathUtil.isEquivalent(newObj, oldObj)) continue;
            if (count > 0) {
                sb.append(", ");
            }
            sb.append("\n    ");
            sb.append(this.dbms_.getFormattedName(newDbValue.getColumn()) + " = ");
            sb.append(this.dbms_.getFormattedValue(newDbValue));
            ++count;
        }
        sb.append(this.getWhereClause(table, oldDbValues));
        return sb.toString();
    }

    @Override
    public String getWhereClause(Table table, Map oldDbValues) {
        StringBuffer sb = new StringBuffer("\nWHERE ");
        PrimaryKey pk = table.getPrimaryKey();
        ArrayList colNames = pk != null ? pk.getKeyColumnNames() : new ArrayList(table.getKeys(Column.getClassName()));
        Iterator it = colNames.iterator();
        int count = 0;
        while (it.hasNext()) {
            String colName = (String)it.next();
            Column column = table.getColumn(colName);
            if (++count > 1) {
                sb.append("AND ");
            }
            sb.append(this.dbms_.getFormattedName(column));
            IDbValue dbValue = (IDbValue)oldDbValues.get(colName);
            if (dbValue.getValueObject() == null) {
                sb.append(" IS ");
            } else {
                sb.append(" = ");
            }
            sb.append(this.dbms_.getFormattedValue(dbValue)).append("\n");
        }
        return sb.toString();
    }

    @Override
    public boolean getUseNullForBlank() {
        return this.useNullForBlanks_;
    }

    @Override
    public void setUseNullForBlank(boolean flag) {
        this.useNullForBlanks_ = flag;
    }

    @Override
    public Dbms getDbms() {
        return this.dbms_;
    }

    @Override
    public void setDbms(Dbms dbms) {
        this.dbms_ = dbms;
    }

    public boolean getExcludeEmptyDefault(IDbValue dbValue) {
        Column column = dbValue.getColumn();
        boolean hasDefaultValue = column.getDefault().length() > 0;
        Object valueObj = dbValue.getValueObject();
        boolean isEmptyValue = false;
        if (valueObj instanceof String && ((String)valueObj).equals("")) {
            isEmptyValue = true;
        }
        boolean exclude = hasDefaultValue && isEmptyValue;
        return exclude;
    }
}

