/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.db;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.dbwrench.db.IDbValue;
import com.harrand.dbwrench.db.function.OracleFunctionChecker;
import com.harrand.dbwrench.jdbc.IDataType;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrenchgui.db.dataEdit.WidgetOverrideCtrl;
import com.harrand.util.ResMgr;
import java.text.DateFormat;
import java.util.Date;

public final class BasicDbValue
implements IDbValue {
    private WidgetOverrideCtrl widgetOverrideCtrl = new WidgetOverrideCtrl();
    private Column column_;
    private Object valueObject_;
    private boolean isFunction_;
    private static String invalidTitle__ = ResMgr.getRes("err.data.entry.invalid.title");

    public BasicDbValue(Column column, Object valueObject, boolean isFunction) {
        this.setValues(column, valueObject, isFunction);
    }

    public BasicDbValue(Column column, String valueAsStr) {
        IDataType dataType = column.getDataType();
        boolean isStrType = column.getDataType().isStringLikeType();
        boolean isIntColumn = column.isIntegerColumn();
        if (this.widgetOverrideCtrl.useDefaultTextWidget(column)) {
            this.setValues(column, valueAsStr, false);
        } else if (!isStrType && valueAsStr.length() == 0) {
            this.setValues(column, null, false);
        } else if (this.isFunctionStr(valueAsStr)) {
            this.setValues(column, valueAsStr, true);
        } else if (isIntColumn) {
            try {
                int intPrimitive = Integer.parseInt(valueAsStr);
                this.setValues(column, new Integer(intPrimitive), false);
            }
            catch (Exception e) {
                this.printConvertError(e, valueAsStr, column);
            }
        } else if (dataType.isNumberLikeType()) {
            try {
                double dblPrimitive = Double.parseDouble(valueAsStr);
                this.setValues(column, new Double(dblPrimitive), false);
            }
            catch (Exception e) {
                this.printConvertError(e, valueAsStr, column);
            }
        } else if (dataType.isDateLikeType()) {
            this.parseDateTimes(column, valueAsStr);
        } else {
            this.setValues(column, valueAsStr, false);
        }
    }

    @Override
    public Column getColumn() {
        return this.column_;
    }

    @Override
    public String getName() {
        return this.column_.getName();
    }

    @Override
    public Object getValueObject() {
        return this.valueObject_;
    }

    @Override
    public boolean isFunction() {
        return this.isFunction_;
    }

    public String toString() {
        if (this.valueObject_ == null) {
            return "";
        }
        return this.valueObject_.toString();
    }

    private void setValues(Column column, Object valueObject, boolean isFunction) {
        ITestResult result;
        this.column_ = column;
        this.valueObject_ = valueObject;
        this.isFunction_ = isFunction;
        if (valueObject != null && !this.isFunction() && !(result = this.validateValue(valueObject)).getPassed()) {
            System.out.println("BasicDbValue.Invalid: " + result.getDetail());
        }
    }

    @Override
    public ITestResult validateValue(Object value) {
        DataEntryResult result = new DataEntryResult(true);
        String msg = "";
        String colName = this.column_.getName();
        if (this.column_.getAutoNumber()) {
            return result;
        }
        if (this.widgetOverrideCtrl.useDefaultTextWidget(this.column_)) {
            return result;
        }
        if (value == null) {
            if (this.column_.getIsNullable()) {
                return result;
            }
            msg = ResMgr.getRes("column.null.value.invalid.msg") + colName;
            result = new DataEntryResult(false, invalidTitle__, msg);
            return result;
        }
        String valueStr = value.toString();
        if (this.isFunctionStr(valueStr)) {
            return result;
        }
        if (this.column_.isIntegerColumn() && !StrHelper.isInteger(valueStr)) {
            msg = ResMgr.getRes("column.int.value.req.msg") + colName;
            result = new DataEntryResult(false, invalidTitle__, msg);
            return result;
        }
        if (this.column_.getDataType().isNumberLikeType() && !StrHelper.isNumeric(valueStr)) {
            msg = ResMgr.getRes("column.numeric.value.req.msg") + colName;
            result = new DataEntryResult(false, invalidTitle__, msg);
            return result;
        }
        if (this.column_.getDataType().isDateLikeType()) {
            if (value instanceof Date) {
                return result;
            }
            return this.validateDate(valueStr);
        }
        int dataTypeId = this.column_.getDataType().getId();
        if ((dataTypeId == 1 || dataTypeId == 12) && this.isStrTooLong(valueStr)) {
            msg = ResMgr.getRes("column.value.too.large.msg") + colName;
            result = new DataEntryResult(false, invalidTitle__, msg);
            return result;
        }
        return result;
    }

    private boolean isStrTooLong(String valueStr) {
        boolean lengthNull;
        boolean tooLong = false;
        Integer lengthInt = this.column_.getLength();
        boolean bl = lengthNull = lengthInt == null;
        if (!lengthNull && valueStr.length() > lengthInt) {
            tooLong = true;
        }
        return tooLong;
    }

    private void parseDateTimes(Column column, String valueAsStr) {
        int id = column.getDataTypeId();
        Date date = null;
        date = id == 91 ? StrHelper.parseDate(valueAsStr) : StrHelper.parseDateTime(valueAsStr);
        this.setValues(column, date, false);
        if (date == null) {
            System.out.println("Could not parse date: " + valueAsStr);
        }
    }

    private ITestResult validateDate(String dateStr) {
        DataEntryResult result = new DataEntryResult(true);
        Date date = StrHelper.parseDate(dateStr);
        if (date == null) {
            date = StrHelper.parseDateTime(dateStr);
        }
        if (date == null) {
            try {
                DateFormat format = DateFormat.getDateInstance();
                format.setLenient(false);
                date = format.parse(dateStr);
            }
            catch (Exception e) {
                result = new DataEntryResult(false, e.getMessage());
            }
        }
        return result;
    }

    private void printConvertError(Exception e, String valueAsStr, Column column) {
        System.out.println("BasicDbValue.convertError:" + e.getMessage() + ". For: " + valueAsStr + ", column: " + column.getName());
    }

    private boolean isFunctionStr(String str) {
        boolean hasParenthesis = str.indexOf("()") >= 0;
        boolean isOracleFunction = OracleFunctionChecker.getInstance().isFunction(str);
        return hasParenthesis || isOracleFunction;
    }
}

