/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.dataConversion;

import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.IOrderedMap;
import com.harrand.coreclasses.interfaces.implementation.BasicOrderedMap;
import com.harrand.coreclasses.interfaces.implementation.BasicSortable;
import com.harrand.coreclasses.list.abstraction.IComboArrayCtrl;
import com.harrand.coreclasses.list.abstraction.IComboArrayDisplay;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class DbConversionComboArrayCtrl
implements IComboArrayCtrl {
    private Collector db_;
    private Map preSelectedItems_;

    public DbConversionComboArrayCtrl(Collector db, Map preSelectedItems) {
        this.db_ = db;
        this.preSelectedItems_ = preSelectedItems;
    }

    @Override
    public List getComboItems(String comboName, IComboArrayDisplay display) {
        List items;
        if (comboName.equals(Table.getClassName())) {
            items = new ArrayList();
            Database dbColl = (Database)this.db_;
            items = dbColl.getAllTables();
        } else if (comboName.equals(Column.getClassName())) {
            Collector parent = (Collector)display.getSelectedItem(Table.getClassName());
            items = parent.values(Column.getClassName());
        } else {
            throw new IllegalArgumentException("DbConversionComboArrayCtrl.getComboItems does not support\nComboName: " + comboName);
        }
        return items;
    }

    @Override
    public IOrderedMap getComboNames() {
        BasicOrderedMap map = new BasicOrderedMap();
        map.add(new BasicSortable(Table.getClassName(), 0));
        map.add(new BasicSortable(Column.getClassName(), 1));
        return map;
    }

    @Override
    public Map getPreSelectedItems() {
        return this.preSelectedItems_;
    }
}

