/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.dbwrench.command.bldr.column;

import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.prompt.PromptCollectionUpdate;
import com.harrand.dbwrench.object.Column;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.dbwrench.object.Table;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrenchgui.command.PromptQuickFk;
import com.harrand.dbwrenchgui.panel.ForeignKeyPanel;
import com.harrand.sketch.core.Diagram;
import java.util.List;

public class SetFkCmdBldr {
    private Table table;
    private Column column;
    private Diagram diagram;
    public static final String MAP_NM = ForeignKey.getClassName();

    public Command getCommand(Diagram diagram, Table table, Column column) {
        this.table = table;
        this.column = column;
        this.diagram = diagram;
        return this.createCommand();
    }

    private Command createCommand() {
        List<ForeignKey> fks = this.table.getFksForColumn(this.column);
        boolean hasForeignKey = !fks.isEmpty();
        Database db = LookupUtil.getLookupDb();
        ForeignKey oldFk = hasForeignKey ? fks.get(0) : null;
        Command cmd = null;
        if (hasForeignKey) {
            ForeignKeyPanel editor = new ForeignKeyPanel(oldFk, db);
            cmd = new PromptCollectionUpdate(this.table, oldFk, editor);
            cmd.setCommandChain(App.getCommandChain());
        } else {
            cmd = new PromptQuickFk(App.getUser(), db, this.diagram, this.table);
        }
        return cmd;
    }
}

